#include <cinttypes>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <pthread.h>
//#include <mpi.h>
#include <cassert>
#include <chrono>
#include <iostream>

#include "globals.h"

#include "utils/graphIO.h"
#include "utils/debug.h"
#include "utils/diffAnalysis.h"

#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "representations/diffGraphR.h"

#include "coders/myVarintByteBasedCoder.h"
#include "coders/myVarintByteBasedRecCoder.h"
#include "coders/myVarintByteBasedHybridCoder.h"
#include "coders/myVarintByteBasedHybridOpt1Coder.h"
#include "coders/myVarintByteBasedHybridReducedCoder.h"
#include "coders/myVarintByteBasedHybridOpt1ReducedCoder.h"
#include "coders/myVarintByteBasedRecOpt1Coder.h"
#include "coders/myVarintByteBasedNoDiffCoder.h"
#include "coders/myVarintWordBasedCoder.h"
#include "coders/myVarintWordBasedRecCoder.h"
#include "coders/myVarintWordBasedNoDiffCoder.h"

#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsPtrsCompressed.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBVCompressed.h"

#include "offsetStructures/offsetsPtrsLogn.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBV_IL.h"
#include "offsetStructures/offsetsBV_SD.h"
#include "offsetStructures/offsetsBV_RRR.h"

DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_B;
DiffGraphR<OffsetsPtrs, MyVarintByteBasedNoDiffCoder>* dif_B_nodif;
DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_B_nodif_diff;

DiffGraphR<OffsetsPtrs, MyVarintWordBasedCoder>* dif_W;
DiffGraphR<OffsetsPtrs, MyVarintWordBasedNoDiffCoder>* dif_W_nodif;
DiffGraphR<OffsetsPtrs, MyVarintWordBasedCoder>* dif_W_nodif_diff;

std::string GRAPH_S;
std::string GRAPH_NAME;
std::string GRAPH_FILE_T;
std::string GRAPH_FILE_R;

ofstream f_cat;

TradListGraphR* rep_original_t = NULL;
MetisR* rep_original_m = NULL;
SimpleRecGraphR* rep_bisected_r = NULL;

int MAX_ITERATIONS = 10000;
int ITERATIONS_PER_WARMUP = 100;
int MAX_THREADS = 1;

pthread_barrier_t thread_barrier;
pthread_mutex_t thread_mutex;

typedef struct thread_params_t {
  int thread_id;
  int num_threads;
} thread_params;

//double start_time = 0;
//double end_time = 0;

std::chrono::time_point<std::chrono::system_clock> start_time, end_time;

////////////////////////////////////////////////////////////

void measure_deg_rb_B(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg = dif_B->getVertexDegree(rand_v[i]);
  } 
}

void measure_N_rb_B(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg;
    v_id* N = dif_B->getVertexNeighborsAndDegree(rand_v[i], &deg);
  } 
}

void measure_adj_rb_B(int thread_id, v_id* rand_v1, v_id* rand_v2) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    bool b = dif_B->adjUseMinNeighbors(rand_v1[i], rand_v2[i]);
  } 
}

////////////////////////////////////////////////////////////

void measure_deg_dm_B(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg = dif_B_nodif->getVertexDegree(rand_v[i]);
  } 
}

void measure_N_dm_B(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg;
    v_id* N = dif_B_nodif->getVertexNeighborsAndDegree(rand_v[i], &deg);
  } 
}

void measure_adj_dm_B(int thread_id, v_id* rand_v1, v_id* rand_v2) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    bool b = dif_B_nodif->adjUseMinNeighbors(rand_v1[i], rand_v2[i]);
  } 
}

////////////////////////////////////////////////////////////

void measure_deg_dmd_B(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg = dif_B_nodif_diff->getVertexDegree(rand_v[i]);
  } 
}

void measure_N_dmd_B(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg;
    v_id* N = dif_B_nodif_diff->getVertexNeighborsAndDegree(rand_v[i], &deg);
  } 
}

void measure_adj_dmd_B(int thread_id, v_id* rand_v1, v_id* rand_v2) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    bool b = dif_B_nodif_diff->adjUseMinNeighbors(rand_v1[i], rand_v2[i]);
  } 
}














////////////////////////////////////////////////////////////

void measure_deg_rb_W(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg = dif_W->getVertexDegree(rand_v[i]);
  } 
}

void measure_N_rb_W(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg;
    v_id* N = dif_W->getVertexNeighborsAndDegree(rand_v[i], &deg);
  } 
}

void measure_adj_rb_W(int thread_id, v_id* rand_v1, v_id* rand_v2) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    bool b = dif_W->adjUseMinNeighbors(rand_v1[i], rand_v2[i]);
  } 
}

////////////////////////////////////////////////////////////

void measure_deg_dm_W(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg = dif_W_nodif->getVertexDegree(rand_v[i]);
  } 
}

void measure_N_dm_W(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg;
    v_id* N = dif_W_nodif->getVertexNeighborsAndDegree(rand_v[i], &deg);
  } 
}

void measure_adj_dm_W(int thread_id, v_id* rand_v1, v_id* rand_v2) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    bool b = dif_W_nodif->adjUseMinNeighbors(rand_v1[i], rand_v2[i]);
  } 
}

////////////////////////////////////////////////////////////

void measure_deg_dmd_W(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg = dif_W_nodif_diff->getVertexDegree(rand_v[i]);
  } 
}

void measure_N_dmd_W(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg;
    v_id* N = dif_W_nodif_diff->getVertexNeighborsAndDegree(rand_v[i], &deg);
  } 
}

void measure_adj_dmd_W(int thread_id, v_id* rand_v1, v_id* rand_v2) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    bool b = dif_W_nodif_diff->adjUseMinNeighbors(rand_v1[i], rand_v2[i]);
  } 
}












////////////////////////////////////////////////////////////

void measure_deg_trad(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    v_id deg = rep_original_m->getVertexDegree(rand_v[i]);;
  } 
}

void measure_N_trad(int thread_id, v_id* rand_v) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }
    v_id deg;
    v_id* N = rep_original_m->getVertexNeighborsAndDegree(rand_v[i], &deg);
  } 
}

void measure_adj_trad(int thread_id, v_id* rand_v1, v_id* rand_v2) {
  pthread_barrier_wait(&thread_barrier);

  for (int i = 0; i < ITERATIONS_PER_WARMUP + MAX_ITERATIONS; i++) {
    if(i == ITERATIONS_PER_WARMUP) {
      pthread_barrier_wait(&thread_barrier);
      if(thread_id == 0) {
        start_time = std::chrono::high_resolution_clock::now(); //MPI_Wtime();
      }
    }

    //bool b = dif_W_nodif_diff->adjUseMinNeighbors(rand_v1[i], rand_v2[i]);
  } 
}












void* measure(void* args) {
  thread_params* params = (thread_params*)args;

  int thread_id = params->thread_id;
  int num_threads = params->num_threads;

  int64_t* rand_v = new int64_t[MAX_ITERATIONS + ITERATIONS_PER_WARMUP]();
  int64_t* rand_v1 = new int64_t[MAX_ITERATIONS + ITERATIONS_PER_WARMUP]();
  int64_t* rand_v2 = new int64_t[MAX_ITERATIONS + ITERATIONS_PER_WARMUP]();

  for(int64_t i = 0; i < (MAX_ITERATIONS + ITERATIONS_PER_WARMUP); ++i) {
    rand_v[i] = rand() % rep_original_t->n_;
    rand_v1[i] = rand() % rep_original_t->n_;
    rand_v2[i] = rand() % rep_original_t->n_;
  }

/*  measure_deg_rb_B(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " byte RB deg " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_N_rb_B(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " byte RB N " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_adj_rb_B(thread_id, rand_v1, rand_v2);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " byte RB adj " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }


  measure_deg_dm_B(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " byte DMf deg " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_N_dm_B(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " byte DMf N " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_adj_dm_B(thread_id, rand_v1, rand_v2);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " byte DMf adj " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }


  measure_deg_dmd_B(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " byte DMd deg " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_N_dmd_B(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " byte DMd N " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_adj_dmd_B(thread_id, rand_v1, rand_v2);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " byte DMd adj " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }



  /////////////////////////////////////////////////////


  measure_deg_rb_W(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " word RB deg " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_N_rb_W(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " word RB N " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_adj_rb_W(thread_id, rand_v1, rand_v2);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " word RB adj " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }


  measure_deg_dm_W(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " word DMf deg " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_N_dm_W(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " word DMf N " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_adj_dm_W(thread_id, rand_v1, rand_v2);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " word DMf adj " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }


  measure_deg_dmd_W(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " word DMd deg " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_N_dmd_W(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " word DMd N " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_adj_dmd_W(thread_id, rand_v1, rand_v2);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " word DMd adj " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  ////////////////////////////////////
*/
  measure_deg_trad(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " x CSR deg " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_N_trad(thread_id, rand_v);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " x CSR N " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }

  measure_adj_trad(thread_id, rand_v1, rand_v2);
  pthread_barrier_wait(&thread_barrier);

  if(thread_id == 0) {
    end_time = std::chrono::high_resolution_clock::now();
    std::chrono::duration<double> elapsed_seconds = end_time-start_time;
    f_cat << GRAPH_S << " " << num_threads << " x CSR adj " << elapsed_seconds.count() << " " << elapsed_seconds.count() / MAX_ITERATIONS << endl;
  }



  free(params);

  delete [] rand_v;
  delete [] rand_v1;
  delete [] rand_v2;

  pthread_exit(NULL);
}

int main (int argc, char *argv[]) {
  GRAPH_S = argv[1];
  GRAPH_NAME = argv[2];
  GRAPH_FILE_T = argv[3];
  GRAPH_FILE_R = argv[4];

  string dir = argv[5];
  string file = argv[6];

  if(GRAPH_FILE_T == "" || GRAPH_FILE_R == "") {
    return EXIT_FAILURE;
  }

  MAX_THREADS = atoi(argv[7]);
  MAX_ITERATIONS = atoi(argv[8]);
  ITERATIONS_PER_WARMUP = atoi(argv[9]);

  assert(argc == 10);

  srand(time(NULL));

  GraphIO::loadGraph(GRAPH_FILE_T.c_str(), &rep_original_t, &rep_original_m);
  rep_bisected_r = GraphIO::readRecursivePartitioningFromFile(GRAPH_FILE_R);

  dif_B = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_nodif = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);
  dif_B_nodif_diff = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);

  dif_W = new DiffGraphR<OffsetsPtrs, MyVarintWordBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_W_nodif = new DiffGraphR<OffsetsPtrs, MyVarintWordBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);
  dif_W_nodif_diff = new DiffGraphR<OffsetsPtrs, MyVarintWordBasedCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);

  f_cat.open(dir + "/" + file, ios::app);

  for(int i = MAX_THREADS; i <= MAX_THREADS; i *= 2) {
    pthread_attr_t attr;
    pthread_t* threads = new pthread_t[i];
    //for(int j = 0; j < i; ++j) {
    //  threads[j] = new pthread_t();
    //}
    void* status;

    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);  

    pthread_barrier_init(&thread_barrier, NULL, i);
    pthread_mutex_init(&thread_mutex, NULL);

    for(int j = 0; j < i; j++) {
      thread_params* params = (thread_params*) malloc(sizeof(thread_params));
      params->thread_id = j;
      params->num_threads = i;

      pthread_create(&threads[j], &attr, measure, (void*)params);
    }

    pthread_attr_destroy(&attr);

    for(int j = 0; j < i; j++) {
      pthread_join(threads[j], &status);
    }

    pthread_barrier_destroy(&thread_barrier);
    pthread_mutex_destroy(&thread_mutex);

    //for(int j = 0; j < i; ++j) {
    //  delete threads[j];
    //}
    delete [] threads;
  }

  f_cat.close();

  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  delete rep_original_t;
  delete rep_original_m;

  delete dif_B;
  delete dif_B_nodif;
  delete dif_B_nodif_diff;
  delete dif_W;
  delete dif_W_nodif;
  delete dif_W_nodif_diff;

  return EXIT_SUCCESS;
}
