#include <cinttypes>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <pthread.h>
#include <cassert>
#include <chrono>
#include <iostream>

#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "utils/diffAnalysis.h"

#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "representations/diffGraphR.h"

#include "partitioners/recPart.h"

#include "coders/myVarintByteBasedCoder.h"
#include "coders/myVarintByteBasedRecCoder.h"
#include "coders/myVarintByteBasedHybridCoder.h"
#include "coders/myVarintByteBasedHybridOpt1Coder.h"
#include "coders/myVarintByteBasedHybridReducedCoder.h"
#include "coders/myVarintByteBasedHybridOpt1ReducedCoder.h"
#include "coders/myVarintByteBasedRecOpt1Coder.h"
#include "coders/myVarintByteBasedNoDiffCoder.h"
#include "coders/myVarintWordBasedCoder.h"
#include "coders/myVarintWordBasedRecCoder.h"
#include "coders/myVarintWordBasedNoDiffCoder.h"

#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBV_IL.h"
#include "offsetStructures/offsetsBV_SD.h"
#include "offsetStructures/offsetsBV_RRR.h"

using namespace std;

std::string GRAPH_S;
std::string GRAPH_NAME;
std::string GRAPH_FILE_T;
std::string GRAPH_FILE_R;

////////////////////////////////////////////////////////////

TradListGraphR* rep_original_t = NULL;
TradListGraphR* rep_original_blelloch_inorder_t = NULL;
TradListGraphR* rep_original_degree_t = NULL;
TradListGraphR* rep_bisected_t = NULL;

MetisR* rep_original_m = NULL;
SimpleRecGraphR* rep_bisected_r = NULL;

DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>* dif_B;
DiffGraphR<OffsetsBV_SD, MyVarintByteBasedNoDiffCoder>* dif_B_nodif;

DiffGraphR<OffsetsBV_SD, MyVarintWordBasedCoder>* dif_W;
DiffGraphR<OffsetsBV_SD, MyVarintWordBasedNoDiffCoder>* dif_W_nodif;

bool hack = true;

std::chrono::time_point<std::chrono::system_clock> s, e;

int main (int argc, char *argv[]) {
  GRAPH_S = argv[1];
  GRAPH_NAME = argv[2];
  GRAPH_FILE_T = argv[3];
  GRAPH_FILE_R = argv[4];
  string do_ilp = argv[5];
  string do_lp = argv[6];

  string dir = argv[7];
  string file = argv[8];

  assert(argc == 9);

  if(GRAPH_FILE_T == "" || GRAPH_FILE_R == "") {
    return EXIT_FAILURE;
  }

  GraphIO::loadGraph(GRAPH_FILE_T.c_str(), &rep_original_t, &rep_original_m);
  rep_bisected_r = GraphIO::readRecursivePartitioningFromFile(GRAPH_FILE_R);

  RecPart part;
  SimpleRecGraphR* r = NULL;
  CutResults* res = NULL;
  int balance = 1;
  int full = 1;
  int lvls = 1;

  ofstream f_cat;
  f_cat.open(dir + "/" + file, ios::app);

  s = std::chrono::high_resolution_clock::now();
  part.recEdgePartition(METIS_PARTITIONING, rep_original_m, balance, full, lvls, &r, &res);
  e = std::chrono::high_resolution_clock::now();
  std::chrono::duration<double> cnt = e - s; 

  f_cat << GRAPH_S << " x Part " << cnt.count() << endl;

  s = std::chrono::high_resolution_clock::now();
  part.recEdgePartition(METIS_PARTITIONING_MULTITHREADED, rep_original_m, balance, full, lvls, &r, &res);
  e = std::chrono::high_resolution_clock::now();
  cnt = e - s; 

  f_cat << GRAPH_S << " x PartT " << cnt.count() << endl;



  s = std::chrono::high_resolution_clock::now();
  dif_B = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  e = std::chrono::high_resolution_clock::now();
  cnt = e - s; 

  f_cat << GRAPH_S << " byte Trad " << cnt.count() << endl;
  delete dif_B;

  s = std::chrono::high_resolution_clock::now();
  dif_B = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  e = std::chrono::high_resolution_clock::now();
  cnt = e - s; 

  f_cat << GRAPH_S << " byte RB " << cnt.count() << endl;
  delete dif_B;

  s = std::chrono::high_resolution_clock::now();
  dif_B = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);
  e = std::chrono::high_resolution_clock::now();
  cnt = e - s; 

  f_cat << GRAPH_S << " byte DMd " << cnt.count() << endl;
  delete dif_B;

  s = std::chrono::high_resolution_clock::now();
  dif_B_nodif = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);
  e = std::chrono::high_resolution_clock::now();
  cnt = e - s; 

  f_cat << GRAPH_S << " byte DMf " << cnt.count() << endl;
  delete dif_B_nodif;



  s = std::chrono::high_resolution_clock::now();
  dif_W = new DiffGraphR<OffsetsBV_SD, MyVarintWordBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  e = std::chrono::high_resolution_clock::now();
  cnt = e - s; 

  f_cat << GRAPH_S << " word Trad " << cnt.count() << endl;
  delete dif_W;

  s = std::chrono::high_resolution_clock::now();
  dif_W = new DiffGraphR<OffsetsBV_SD, MyVarintWordBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  e = std::chrono::high_resolution_clock::now();
  cnt = e - s; 

  f_cat << GRAPH_S << " word RB " << cnt.count() << endl;
  delete dif_W;

  s = std::chrono::high_resolution_clock::now();
  dif_W = new DiffGraphR<OffsetsBV_SD, MyVarintWordBasedCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);
  e = std::chrono::high_resolution_clock::now();
  cnt = e - s; 

  f_cat << GRAPH_S << " word DMd " << cnt.count() << endl;
  delete dif_W;

  s = std::chrono::high_resolution_clock::now();
  dif_W_nodif = new DiffGraphR<OffsetsBV_SD, MyVarintWordBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);
  e = std::chrono::high_resolution_clock::now();
  cnt = e - s; 

  f_cat << GRAPH_S << " word DMf " << cnt.count() << endl;
  delete dif_W_nodif;


  f_cat.close();

  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  delete rep_bisected_r;
  delete rep_original_t;
  delete rep_original_m;

  return EXIT_SUCCESS;
}
