#include <cinttypes>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <pthread.h>
#include <cassert>
#include <chrono>
#include <iostream>

#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "utils/diffAnalysis.h"

#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "representations/diffGraphR.h"

#include "partitioners/recPart.h"

#include "coders/myVarintByteBasedCoder.h"
#include "coders/myVarintByteBasedRecCoder.h"
#include "coders/myVarintByteBasedRecOpt1Coder.h"
#include "coders/myVarintByteBasedNoDiffCoder.h"
#include "coders/myVarintWordBasedCoder.h"
#include "coders/myVarintWordBasedRecCoder.h"
#include "coders/myVarintWordBasedNoDiffCoder.h"

#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBV_IL.h"
#include "offsetStructures/offsetsBV_SD.h"
#include "offsetStructures/offsetsBV_RRR.h"

using namespace std;

std::string GRAPH_S;
std::string GRAPH_NAME;
std::string GRAPH_FILE_T;
std::string GRAPH_FILE_R;

////////////////////////////////////////////////////////////

TradListGraphR* rep_original_t = NULL;
TradListGraphR* rep_original_blelloch_inorder_t = NULL;
TradListGraphR* rep_original_degree_t = NULL;
TradListGraphR* rep_bisected_t = NULL;

TradListGraphR* rep_original_opt_nn_un_ilp = NULL;
TradListGraphR* rep_original_opt_nn_un_lp = NULL;
TradListGraphR* rep_original_opt_nn_con_ilp = NULL;
TradListGraphR* rep_original_opt_nn_con_lp = NULL;
TradListGraphR* rep_original_opt_vn_un_ilp = NULL;
TradListGraphR* rep_original_opt_vn_un_lp = NULL;
TradListGraphR* rep_original_opt_vn_con_ilp = NULL;
TradListGraphR* rep_original_opt_vn_con_lp = NULL;

TradListGraphR* rep_original_o_nn_un_ilp = NULL;
TradListGraphR* rep_original_o_nn_con_ilp = NULL;
TradListGraphR* rep_original_o_vn_un_ilp = NULL;
TradListGraphR* rep_original_o_vn_con_ilp = NULL;



MetisR* rep_original_m = NULL;

SimpleRecGraphR* rep_bisected_r = NULL;

bool hack = true;



int main (int argc, char *argv[]) {
  GRAPH_S = argv[1];
  GRAPH_NAME = argv[2];
  GRAPH_FILE_T = argv[3];
  GRAPH_FILE_R = argv[4];
  string do_ilp = argv[5];
  string do_lp = argv[6];

  assert(argc == 7);

  if(GRAPH_FILE_T == "" || GRAPH_FILE_R == "") {
    return EXIT_FAILURE;
  }

  cerr << ">>> Loading original adjacency list from file." << endl; 
  GraphIO::loadGraph(GRAPH_FILE_T.c_str(), &rep_original_t, &rep_original_m); 
  cerr << "Done" << endl; 

  cerr << ">>> Loading bisected representation from file." << endl; 
  rep_bisected_r = GraphIO::readRecursivePartitioningFromFile(GRAPH_FILE_R); 
  cerr << "Done" << endl;

  RecPermuter* p = new RecPermuter();

  cerr << ">>> Loading (permuting-NO_CHANGES) from original representation." << endl;
  double rep_original_t_SUM_first_neighbors = -1;
  double rep_original_t_SUM_rest_neighbors = -1;
  getSumOfDifferences(rep_original_t, &rep_original_t_SUM_rest_neighbors, &rep_original_t_SUM_first_neighbors);
  double rep_original_t_SUM_total = rep_original_t_SUM_first_neighbors + rep_original_t_SUM_rest_neighbors;

  cerr << ">>> Loading (permuting-INORDER) from original representation." << endl;
  rep_original_blelloch_inorder_t = p->permute(rep_bisected_r, rep_original_t, INORDER);
  cerr << "  > Verifying..." << endl;
  verifyTradListGraphR(rep_original_blelloch_inorder_t);
  double rep_original_blelloch_inorder_t_SUM_first_neighbors = -1;
  double rep_original_blelloch_inorder_t_SUM_rest_neighbors = -1;
  getSumOfDifferences(rep_original_blelloch_inorder_t, &rep_original_blelloch_inorder_t_SUM_rest_neighbors, &rep_original_blelloch_inorder_t_SUM_first_neighbors);
  double rep_original_blelloch_inorder_t_SUM_total = rep_original_blelloch_inorder_t_SUM_first_neighbors + rep_original_blelloch_inorder_t_SUM_rest_neighbors;

  double rep_original_opt_nn_con_ilp_SUM_first_neighbors = -1;
  double rep_original_opt_nn_con_ilp_SUM_rest_neighbors = -1;
  double rep_original_opt_nn_con_ilp_SUM_total = -1;

  double rep_original_opt_nn_un_ilp_SUM_first_neighbors = -1;
  double rep_original_opt_nn_un_ilp_SUM_rest_neighbors = -1;
  double rep_original_opt_nn_un_ilp_SUM_total = -1;

  double rep_original_opt_vn_con_ilp_SUM_first_neighbors = -1;
  double rep_original_opt_vn_con_ilp_SUM_rest_neighbors = -1;
  double rep_original_opt_vn_con_ilp_SUM_total = -1;

  double rep_original_opt_vn_un_ilp_SUM_first_neighbors = -1;
  double rep_original_opt_vn_un_ilp_SUM_rest_neighbors = -1;
  double rep_original_opt_vn_un_ilp_SUM_total = -1;

  double rep_original_opt_nn_con_lp_SUM_first_neighbors = -1;
  double rep_original_opt_nn_con_lp_SUM_rest_neighbors = -1;
  double rep_original_opt_nn_con_lp_SUM_total = -1;

  double rep_original_opt_nn_un_lp_SUM_first_neighbors = -1;
  double rep_original_opt_nn_un_lp_SUM_rest_neighbors = -1;
  double rep_original_opt_nn_un_lp_SUM_total = -1;

  double rep_original_opt_vn_con_lp_SUM_first_neighbors = -1;
  double rep_original_opt_vn_con_lp_SUM_rest_neighbors = -1;
  double rep_original_opt_vn_con_lp_SUM_total = -1;

  double rep_original_opt_vn_un_lp_SUM_first_neighbors = -1;
  double rep_original_opt_vn_un_lp_SUM_rest_neighbors = -1;
  double rep_original_opt_vn_un_lp_SUM_total = -1;


  double rep_original_o_vn_un_ilp_SUM_first_neighbors = -1;
  double rep_original_o_vn_un_ilp_SUM_rest_neighbors = -1;
  double rep_original_o_vn_un_ilp_SUM_total = -1;

  double rep_original_o_nn_un_ilp_SUM_first_neighbors = -1;
  double rep_original_o_nn_un_ilp_SUM_rest_neighbors = -1;
  double rep_original_o_nn_un_ilp_SUM_total = -1;

  double rep_original_o_vn_con_ilp_SUM_first_neighbors = -1;
  double rep_original_o_vn_con_ilp_SUM_rest_neighbors = -1;
  double rep_original_o_vn_con_ilp_SUM_total = -1;

  double rep_original_o_nn_con_ilp_SUM_first_neighbors = -1;
  double rep_original_o_nn_con_ilp_SUM_rest_neighbors = -1;
  double rep_original_o_nn_con_ilp_SUM_total = -1;



  if(do_ilp == "Y") {
    cerr << ">>> Loading (permuting-OPT_DIFF_NN_ILP_CONSTR) from original representation." << endl;
    rep_original_opt_nn_con_ilp = p->permute(rep_bisected_r, rep_original_t, OPTIMAL_DIFF_NN_ILP_CONSTR);
    cerr << "  > Verifying..." << endl;
    verifyTradListGraphR(rep_original_opt_nn_con_ilp);
    getSumOfDifferences(rep_original_opt_nn_con_ilp, &rep_original_opt_nn_con_ilp_SUM_rest_neighbors, &rep_original_opt_nn_con_ilp_SUM_first_neighbors);
    rep_original_opt_nn_con_ilp_SUM_total = rep_original_opt_nn_con_ilp_SUM_first_neighbors + rep_original_opt_nn_con_ilp_SUM_rest_neighbors;

    cerr << ">>> Loading (permuting-OPT_DIFF_NN_ILP_UNCONSTR) from original representation." << endl;
    rep_original_opt_nn_un_ilp = p->permute(rep_bisected_r, rep_original_t, OPTIMAL_DIFF_NN_ILP_UNCONSTR);
    cerr << "  > Verifying..." << endl;
    verifyTradListGraphR(rep_original_opt_nn_un_ilp);
    getSumOfDifferences(rep_original_opt_nn_un_ilp, &rep_original_opt_nn_un_ilp_SUM_rest_neighbors, &rep_original_opt_nn_un_ilp_SUM_first_neighbors);
    rep_original_opt_nn_un_ilp_SUM_total = rep_original_opt_nn_un_ilp_SUM_first_neighbors + rep_original_opt_nn_un_ilp_SUM_rest_neighbors;

    cerr << ">>> Loading (permuting-OPT_DIFF_VN_ILP_CONSTR) from original representation." << endl;
    rep_original_opt_vn_con_ilp = p->permute(rep_bisected_r, rep_original_t, OPTIMAL_DIFF_VN_ILP_CONSTR);
    cerr << "  > Verifying..." << endl;
    verifyTradListGraphR(rep_original_opt_vn_con_ilp);
    getSumOfDifferences(rep_original_opt_vn_con_ilp, &rep_original_opt_vn_con_ilp_SUM_rest_neighbors, &rep_original_opt_vn_con_ilp_SUM_first_neighbors);
    rep_original_opt_vn_con_ilp_SUM_total = rep_original_opt_vn_con_ilp_SUM_first_neighbors + rep_original_opt_vn_con_ilp_SUM_rest_neighbors;

    cerr << ">>> Loading (permuting-OPT_DIFF_VN_ILP_UNCONSTR) from original representation." << endl;
    rep_original_opt_vn_un_ilp = p->permute(rep_bisected_r, rep_original_t, OPTIMAL_DIFF_VN_ILP_UNCONSTR);
    cerr << "  > Verifying..." << endl;
    verifyTradListGraphR(rep_original_opt_vn_un_ilp);
    getSumOfDifferences(rep_original_opt_vn_un_ilp, &rep_original_opt_vn_un_ilp_SUM_rest_neighbors, &rep_original_opt_vn_un_ilp_SUM_first_neighbors);
    rep_original_opt_vn_un_ilp_SUM_total = rep_original_opt_vn_un_ilp_SUM_first_neighbors + rep_original_opt_vn_un_ilp_SUM_rest_neighbors;
    

    rep_original_o_nn_con_ilp = p->permute(rep_bisected_r, rep_original_t, __O_ILP_NN_CON_N);
    getSumOfDifferences(rep_original_o_nn_con_ilp, &rep_original_o_nn_con_ilp_SUM_rest_neighbors, &rep_original_o_nn_con_ilp_SUM_first_neighbors);
    rep_original_o_nn_con_ilp_SUM_total = rep_original_o_nn_con_ilp_SUM_first_neighbors + rep_original_o_nn_con_ilp_SUM_rest_neighbors;

    rep_original_o_vn_con_ilp = p->permute(rep_bisected_r, rep_original_t, __O_ILP_VN_CON_N);
    getSumOfDifferences(rep_original_o_vn_con_ilp, &rep_original_o_vn_con_ilp_SUM_rest_neighbors, &rep_original_o_vn_con_ilp_SUM_first_neighbors);
    rep_original_o_vn_con_ilp_SUM_total = rep_original_o_vn_con_ilp_SUM_first_neighbors + rep_original_o_vn_con_ilp_SUM_rest_neighbors;

    rep_original_o_nn_un_ilp = p->permute(rep_bisected_r, rep_original_t, __O_ILP_NN_UN_N);
    getSumOfDifferences(rep_original_o_nn_un_ilp, &rep_original_o_nn_un_ilp_SUM_rest_neighbors, &rep_original_o_nn_un_ilp_SUM_first_neighbors);
    rep_original_o_nn_un_ilp_SUM_total = rep_original_o_nn_un_ilp_SUM_first_neighbors + rep_original_o_nn_un_ilp_SUM_rest_neighbors;

    rep_original_o_vn_un_ilp = p->permute(rep_bisected_r, rep_original_t, __O_ILP_VN_UN_N);
    getSumOfDifferences(rep_original_o_vn_un_ilp, &rep_original_o_vn_un_ilp_SUM_rest_neighbors, &rep_original_o_vn_un_ilp_SUM_first_neighbors);
    rep_original_o_vn_un_ilp_SUM_total = rep_original_o_vn_un_ilp_SUM_first_neighbors + rep_original_o_vn_un_ilp_SUM_rest_neighbors;
  }

  if(do_lp == "Y") {
    cerr << ">>> Loading (permuting-OPT_DIFF_NN_LP_CONSTR) from original representation." << endl;
    rep_original_opt_nn_con_lp = p->permute(rep_bisected_r, rep_original_t, OPTIMAL_DIFF_NN_LP_CONSTR);
    cerr << "  > Verifying..." << endl;
    verifyTradListGraphR(rep_original_opt_nn_con_lp);
    getSumOfDifferences(rep_original_opt_nn_con_lp, &rep_original_opt_nn_con_lp_SUM_rest_neighbors, &rep_original_opt_nn_con_lp_SUM_first_neighbors);
    rep_original_opt_nn_con_lp_SUM_total = rep_original_opt_nn_con_lp_SUM_first_neighbors + rep_original_opt_nn_con_lp_SUM_rest_neighbors;

    cerr << ">>> Loading (permuting-OPT_DIFF_NN_LP_UNCONSTR) from original representation." << endl;
    rep_original_opt_nn_un_lp = p->permute(rep_bisected_r, rep_original_t, OPTIMAL_DIFF_NN_LP_UNCONSTR);
    cerr << "  > Verifying..." << endl;
    verifyTradListGraphR(rep_original_opt_nn_un_lp);
    getSumOfDifferences(rep_original_opt_nn_un_lp, &rep_original_opt_nn_un_lp_SUM_rest_neighbors, &rep_original_opt_nn_un_lp_SUM_first_neighbors);
    rep_original_opt_nn_un_lp_SUM_total = rep_original_opt_nn_un_lp_SUM_first_neighbors + rep_original_opt_nn_un_lp_SUM_rest_neighbors;

    cerr << ">>> Loading (permuting-OPT_DIFF_VN_LP_CONSTR) from original representation." << endl;
    rep_original_opt_vn_con_lp = p->permute(rep_bisected_r, rep_original_t, OPTIMAL_DIFF_VN_LP_CONSTR);
    cerr << "  > Verifying..." << endl;
    verifyTradListGraphR(rep_original_opt_vn_con_lp);
    getSumOfDifferences(rep_original_opt_vn_con_lp, &rep_original_opt_vn_con_lp_SUM_rest_neighbors, &rep_original_opt_vn_con_lp_SUM_first_neighbors);
    rep_original_opt_vn_con_lp_SUM_total = rep_original_opt_vn_con_lp_SUM_first_neighbors + rep_original_opt_vn_con_lp_SUM_rest_neighbors;

    cerr << ">>> Loading (permuting-OPT_DIFF_VN_LP_UNCONSTR) from original representation." << endl;
    rep_original_opt_vn_un_lp = p->permute(rep_bisected_r, rep_original_t, OPTIMAL_DIFF_VN_LP_UNCONSTR);
    cerr << "  > Verifying..." << endl;
    verifyTradListGraphR(rep_original_opt_vn_un_lp);
    getSumOfDifferences(rep_original_opt_vn_un_lp, &rep_original_opt_vn_un_lp_SUM_rest_neighbors, &rep_original_opt_vn_un_lp_SUM_first_neighbors);
    rep_original_opt_vn_un_lp_SUM_total = rep_original_opt_vn_un_lp_SUM_first_neighbors + rep_original_opt_vn_un_lp_SUM_rest_neighbors;
  }

  cerr << ">>> Loading (permuting-DEGREE) from original representation." << endl;
  rep_original_degree_t = p->permute(rep_bisected_r, rep_original_t, DEGREE_HIGH_TO_LOW);
  cerr << "  > Verifying..." << endl;
  verifyTradListGraphR(rep_original_degree_t);
  double rep_original_degree_t_SUM_first_neighbors = -1;
  double rep_original_degree_t_SUM_rest_neighbors = -1;
  getSumOfDifferences(rep_original_degree_t, &rep_original_degree_t_SUM_rest_neighbors, &rep_original_degree_t_SUM_first_neighbors);
  double rep_original_degree_t_SUM_total = rep_original_degree_t_SUM_first_neighbors + rep_original_degree_t_SUM_rest_neighbors;

  cerr << "Loading (converting) an adjacency list from recursive representation." << endl;
  rep_bisected_t = convertSimpleRecToTradList(rep_bisected_r, rep_original_t);
  cerr << "  > Verifying..." << endl;
  verifyTradListGraphR(rep_bisected_t);
  double rep_bisected_t_SUM_first_neighbors = -1;
  double rep_bisected_t_SUM_rest_neighbors = -1;
  getSumOfDifferences(rep_bisected_t, &rep_bisected_t_SUM_rest_neighbors, &rep_bisected_t_SUM_first_neighbors);
  double rep_bisected_t_SUM_total = rep_bisected_t_SUM_first_neighbors + rep_bisected_t_SUM_rest_neighbors;


  ofstream f_cat_size;
  f_cat_size.open("holistic_differences_adj_bench.cat", ios::app);

  f_cat_size << GRAPH_S << " Trad x x x first " << rep_original_t_SUM_first_neighbors << endl;
  f_cat_size << GRAPH_S << " Trad x x x rest " << rep_original_t_SUM_rest_neighbors << endl;
  f_cat_size << GRAPH_S << " Trad x x x tot " << rep_original_t_SUM_total << endl;

  f_cat_size << GRAPH_S << " BF x x x first " << rep_original_blelloch_inorder_t_SUM_first_neighbors << endl;
  f_cat_size << GRAPH_S << " BF x x x rest " << rep_original_blelloch_inorder_t_SUM_rest_neighbors << endl;
  f_cat_size << GRAPH_S << " BF x x x tot " << rep_original_blelloch_inorder_t_SUM_total << endl;

  f_cat_size << GRAPH_S << " BR x x x first " << rep_bisected_t_SUM_first_neighbors << endl;
  f_cat_size << GRAPH_S << " BR x x x rest " << rep_bisected_t_SUM_rest_neighbors << endl;
  f_cat_size << GRAPH_S << " BR x x x tot " << rep_bisected_t_SUM_total << endl;

  f_cat_size << GRAPH_S << " DM x x x first " << rep_original_degree_t_SUM_first_neighbors << endl;
  f_cat_size << GRAPH_S << " DM x x x rest " << rep_original_degree_t_SUM_rest_neighbors << endl;
  f_cat_size << GRAPH_S << " DM x x x tot " << rep_original_degree_t_SUM_total << endl;

  if(do_ilp == "Y") {
    f_cat_size << GRAPH_S << " OP vn un ilp first " << rep_original_opt_vn_un_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn un ilp rest " << rep_original_opt_vn_un_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn un ilp tot " << rep_original_opt_vn_un_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP vn con ilp first " << rep_original_opt_vn_con_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn con ilp rest " << rep_original_opt_vn_con_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn con ilp tot " << rep_original_opt_vn_con_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP nn un ilp first " << rep_original_opt_nn_un_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn un ilp rest " << rep_original_opt_nn_un_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn un ilp tot " << rep_original_opt_nn_un_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP nn con ilp first " << rep_original_opt_nn_con_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn con ilp rest " << rep_original_opt_nn_con_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn con ilp tot " << rep_original_opt_nn_con_ilp_SUM_total << endl;


    f_cat_size << GRAPH_S << " OPn vn un ilp first " << rep_original_o_vn_un_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn vn un ilp rest " << rep_original_o_vn_un_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn vn un ilp tot " << rep_original_o_vn_un_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OPn vn con ilp first " << rep_original_o_vn_con_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn vn con ilp rest " << rep_original_o_vn_con_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn vn con ilp tot " << rep_original_o_vn_con_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OPn nn un ilp first " << rep_original_o_nn_un_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn nn un ilp rest " << rep_original_o_nn_un_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn nn un ilp tot " << rep_original_o_nn_un_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OPn nn con ilp first " << rep_original_o_nn_con_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn nn con ilp rest " << rep_original_o_nn_con_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn nn con ilp tot " << rep_original_o_nn_con_ilp_SUM_total << endl;

  }

  if(do_lp == "Y") {
    f_cat_size << GRAPH_S << " OP vn un lp first " << rep_original_opt_vn_un_lp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn un lp rest " << rep_original_opt_vn_un_lp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn un lp tot " << rep_original_opt_vn_un_lp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP vn con lp first " << rep_original_opt_vn_con_lp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn con lp rest " << rep_original_opt_vn_con_lp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn con lp tot " << rep_original_opt_vn_con_lp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP nn un lp first " << rep_original_opt_nn_un_lp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn un lp rest " << rep_original_opt_nn_un_lp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn un lp tot " << rep_original_opt_nn_un_lp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP nn con lp first " << rep_original_opt_nn_con_lp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn con lp rest " << rep_original_opt_nn_con_lp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn con lp tot " << rep_original_opt_nn_con_lp_SUM_total << endl;
  }

  f_cat_size.close();


  rep_original_blelloch_inorder_t_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
  rep_original_blelloch_inorder_t_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
  rep_original_blelloch_inorder_t_SUM_total /= rep_original_t_SUM_total; 

  rep_bisected_t_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
  rep_bisected_t_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
  rep_bisected_t_SUM_total /= rep_original_t_SUM_total; 

  rep_original_degree_t_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
  rep_original_degree_t_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
  rep_original_degree_t_SUM_total /= rep_original_t_SUM_total; 

  if(do_ilp == "Y") {
    rep_original_opt_vn_un_ilp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_opt_vn_un_ilp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_opt_vn_un_ilp_SUM_total /= rep_original_t_SUM_total; 

    rep_original_opt_vn_con_ilp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_opt_vn_con_ilp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_opt_vn_con_ilp_SUM_total /= rep_original_t_SUM_total; 

    rep_original_opt_nn_un_ilp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_opt_nn_un_ilp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_opt_nn_un_ilp_SUM_total /= rep_original_t_SUM_total; 

    rep_original_opt_nn_con_ilp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_opt_nn_con_ilp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_opt_nn_con_ilp_SUM_total /= rep_original_t_SUM_total; 
    
    
    rep_original_o_vn_un_ilp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_o_vn_un_ilp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_o_vn_un_ilp_SUM_total /= rep_original_t_SUM_total; 

    rep_original_o_vn_con_ilp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_o_vn_con_ilp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_o_vn_con_ilp_SUM_total /= rep_original_t_SUM_total; 

    rep_original_o_nn_un_ilp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_o_nn_un_ilp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_o_nn_un_ilp_SUM_total /= rep_original_t_SUM_total; 

    rep_original_o_nn_con_ilp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_o_nn_con_ilp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_o_nn_con_ilp_SUM_total /= rep_original_t_SUM_total; 
  }

  if(do_lp == "Y") {
    rep_original_opt_vn_un_lp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_opt_vn_un_lp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_opt_vn_un_lp_SUM_total /= rep_original_t_SUM_total; 

    rep_original_opt_vn_con_lp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_opt_vn_con_lp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_opt_vn_con_lp_SUM_total /= rep_original_t_SUM_total; 

    rep_original_opt_nn_un_lp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_opt_nn_un_lp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_opt_nn_un_lp_SUM_total /= rep_original_t_SUM_total; 

    rep_original_opt_nn_con_lp_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
    rep_original_opt_nn_con_lp_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
    rep_original_opt_nn_con_lp_SUM_total /= rep_original_t_SUM_total; 
  }

  rep_original_t_SUM_first_neighbors /= rep_original_t_SUM_first_neighbors; 
  rep_original_t_SUM_rest_neighbors /= rep_original_t_SUM_rest_neighbors; 
  rep_original_t_SUM_total /= rep_original_t_SUM_total; 



  f_cat_size.open("holistic_differences_adj_bench.cat.norm", ios::app);

  f_cat_size << GRAPH_S << " Trad x x x first " << rep_original_t_SUM_first_neighbors << endl;
  f_cat_size << GRAPH_S << " Trad x x x rest " << rep_original_t_SUM_rest_neighbors << endl;
  f_cat_size << GRAPH_S << " Trad x x x tot " << rep_original_t_SUM_total << endl;

  f_cat_size << GRAPH_S << " BF x x x first " << rep_original_blelloch_inorder_t_SUM_first_neighbors << endl;
  f_cat_size << GRAPH_S << " BF x x x rest " << rep_original_blelloch_inorder_t_SUM_rest_neighbors << endl;
  f_cat_size << GRAPH_S << " BF x x x tot " << rep_original_blelloch_inorder_t_SUM_total << endl;

  f_cat_size << GRAPH_S << " BR x x x first " << rep_bisected_t_SUM_first_neighbors << endl;
  f_cat_size << GRAPH_S << " BR x x x rest " << rep_bisected_t_SUM_rest_neighbors << endl;
  f_cat_size << GRAPH_S << " BR x x x tot " << rep_bisected_t_SUM_total << endl;

  f_cat_size << GRAPH_S << " DM x x x first " << rep_original_degree_t_SUM_first_neighbors << endl;
  f_cat_size << GRAPH_S << " DM x x x rest " << rep_original_degree_t_SUM_rest_neighbors << endl;
  f_cat_size << GRAPH_S << " DM x x x tot " << rep_original_degree_t_SUM_total << endl;

  if(do_ilp == "Y") {
    f_cat_size << GRAPH_S << " OP vn un ilp first " << rep_original_opt_vn_un_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn un ilp rest " << rep_original_opt_vn_un_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn un ilp tot " << rep_original_opt_vn_un_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP vn con ilp first " << rep_original_opt_vn_con_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn con ilp rest " << rep_original_opt_vn_con_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn con ilp tot " << rep_original_opt_vn_con_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP nn un ilp first " << rep_original_opt_nn_un_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn un ilp rest " << rep_original_opt_nn_un_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn un ilp tot " << rep_original_opt_nn_un_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP nn con ilp first " << rep_original_opt_nn_con_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn con ilp rest " << rep_original_opt_nn_con_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn con ilp tot " << rep_original_opt_nn_con_ilp_SUM_total << endl;


    f_cat_size << GRAPH_S << " OPn vn un ilp first " << rep_original_o_vn_un_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn vn un ilp rest " << rep_original_o_vn_un_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn vn un ilp tot " << rep_original_o_vn_un_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OPn vn con ilp first " << rep_original_o_vn_con_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn vn con ilp rest " << rep_original_o_vn_con_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn vn con ilp tot " << rep_original_o_vn_con_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OPn nn un ilp first " << rep_original_o_nn_un_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn nn un ilp rest " << rep_original_o_nn_un_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn nn un ilp tot " << rep_original_o_nn_un_ilp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OPn nn con ilp first " << rep_original_o_nn_con_ilp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn nn con ilp rest " << rep_original_o_nn_con_ilp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OPn nn con ilp tot " << rep_original_o_nn_con_ilp_SUM_total << endl;
  }

  if(do_lp == "Y") {
    f_cat_size << GRAPH_S << " OP vn un lp first " << rep_original_opt_vn_un_lp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn un lp rest " << rep_original_opt_vn_un_lp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn un lp tot " << rep_original_opt_vn_un_lp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP vn con lp first " << rep_original_opt_vn_con_lp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn con lp rest " << rep_original_opt_vn_con_lp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP vn con lp tot " << rep_original_opt_vn_con_lp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP nn un lp first " << rep_original_opt_nn_un_lp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn un lp rest " << rep_original_opt_nn_un_lp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn un lp tot " << rep_original_opt_nn_un_lp_SUM_total << endl;

    f_cat_size << GRAPH_S << " OP nn con lp first " << rep_original_opt_nn_con_lp_SUM_first_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn con lp rest " << rep_original_opt_nn_con_lp_SUM_rest_neighbors << endl;
    f_cat_size << GRAPH_S << " OP nn con lp tot " << rep_original_opt_nn_con_lp_SUM_total << endl;
  }

  f_cat_size.close();


  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  delete rep_bisected_r;
  delete rep_original_t;
  delete rep_original_m;

  delete rep_original_opt_nn_un_ilp;
  delete rep_original_opt_nn_un_lp;
  delete rep_original_opt_nn_con_ilp;
  delete rep_original_opt_nn_con_lp;
  delete rep_original_opt_vn_un_ilp;
  delete rep_original_opt_vn_un_lp;
  delete rep_original_opt_vn_con_ilp;
  delete rep_original_opt_vn_con_lp;

  delete p;

  return EXIT_SUCCESS;
}
