#include <cinttypes>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <pthread.h>
#include <cassert>
#include <chrono>
#include <iostream>

#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "utils/diffAnalysis.h"

#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "representations/diffGraphR.h"

#include "partitioners/recPart.h"

#include "coders/myVarintByteBasedCoder.h"
#include "coders/myVarintByteBasedRecCoder.h"
#include "coders/myVarintByteBasedHybridCoder.h"
#include "coders/myVarintByteBasedHybridOpt1Coder.h"
#include "coders/myVarintByteBasedHybridReducedCoder.h"
#include "coders/myVarintByteBasedHybridOpt1ReducedCoder.h"
#include "coders/myVarintByteBasedRecOpt1Coder.h"
#include "coders/myVarintByteBasedNoDiffCoder.h"
#include "coders/myVarintWordBasedCoder.h"
#include "coders/myVarintWordBasedRecCoder.h"
#include "coders/myVarintWordBasedNoDiffCoder.h"

#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBV_IL.h"
#include "offsetStructures/offsetsBV_SD.h"
#include "offsetStructures/offsetsBV_RRR.h"

using namespace std;

std::string GRAPH_S;
std::string GRAPH_NAME;
std::string GRAPH_FILE_T;
std::string GRAPH_FILE_R;

////////////////////////////////////////////////////////////

TradListGraphR* rep_original_t = NULL;
TradListGraphR* rep_original_blelloch_inorder_t = NULL;
TradListGraphR* rep_original_degree_t = NULL;
TradListGraphR* rep_bisected_t = NULL;

MetisR* rep_original_m = NULL;
SimpleRecGraphR* rep_bisected_r = NULL;

DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedRecCoder>* dif_B_rec;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedRecCoder>* dif_B_rec_bl;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedRecOpt1Coder>* dif_B_rec_opt1;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedRecOpt1Coder>* dif_B_rec_opt1_bl;

DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridCoder>* dif_B_H;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridCoder>* dif_B_H_bl;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridOpt1Coder>* dif_B_HO1;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridOpt1Coder>* dif_B_HO1_bl;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridReducedCoder>* dif_B_HR;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridReducedCoder>* dif_B_HR_bl;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridOpt1ReducedCoder>* dif_B_HO1R;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridOpt1ReducedCoder>* dif_B_HO1R_bl;

DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedNoDiffCoder>* dif_B_nodif;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_nodif_diff;

DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_nn_un_ilp;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_nn_un_lp;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_nn_con_ilp;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_nn_con_lp;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_vn_un_ilp;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_vn_un_lp;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_vn_con_ilp;
DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_vn_con_lp;

DiffGraphR<OffsetsBV_RRR, MyVarintWordBasedCoder>* dif_W;
DiffGraphR<OffsetsBV_RRR, MyVarintWordBasedRecCoder>* dif_W_rec;
DiffGraphR<OffsetsBV_RRR, MyVarintWordBasedNoDiffCoder>* dif_W_nodif;

bool hack = true;



int main (int argc, char *argv[]) {
  GRAPH_S = argv[1];
  GRAPH_NAME = argv[2];
  GRAPH_FILE_T = argv[3];
  GRAPH_FILE_R = argv[4];
  string do_ilp = argv[5];
  string do_lp = argv[6];

  string dir = argv[7];
  string file = argv[8];

  assert(argc == 9);

  if(GRAPH_FILE_T == "" || GRAPH_FILE_R == "") {
    return EXIT_FAILURE;
  }

  cerr << ">>> Loading original adjacency list from file." << endl;
  GraphIO::loadGraph(GRAPH_FILE_T.c_str(), &rep_original_t, &rep_original_m);
  cerr << "Done" << endl;

  cerr << ">>> Loading bisected representation from file." << endl;
  rep_bisected_r = GraphIO::readRecursivePartitioningFromFile(GRAPH_FILE_R);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B" << endl;
  dif_B = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  cerr << "Done" << endl;


  if(do_ilp == "Y") {
    cerr << "Constructing dif_B_cplex_nn_un_ilp" << endl;
    dif_B_nn_un_ilp = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(OPTIMAL_DIFF_NN_ILP_UNCONSTR, rep_bisected_r, rep_original_t);
    cerr << "Done" << endl;

    cerr << "Constructing dif_B_cplex_nn_con_ilp" << endl;
    dif_B_nn_con_ilp = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(OPTIMAL_DIFF_NN_ILP_CONSTR, rep_bisected_r, rep_original_t);
    cerr << "Done" << endl;

    cerr << "Constructing dif_B_cplex_vn_un_ilp" << endl;
    dif_B_vn_un_ilp = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(OPTIMAL_DIFF_VN_ILP_UNCONSTR, rep_bisected_r, rep_original_t);
    cerr << "Done" << endl;

    cerr << "Constructing dif_B_cplex_vn_con_ilp" << endl;
    dif_B_vn_con_ilp = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(OPTIMAL_DIFF_VN_ILP_CONSTR, rep_bisected_r, rep_original_t);
    cerr << "Done" << endl;
  }

  if(do_lp == "Y") {
    cerr << "Constructing dif_B_cplex_nn_un_lp" << endl;
    dif_B_nn_un_lp = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(OPTIMAL_DIFF_NN_LP_UNCONSTR, rep_bisected_r, rep_original_t);
    cerr << "Done" << endl;

    cerr << "Constructing dif_B_cplex_nn_con_lp" << endl;
    dif_B_nn_con_lp = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(OPTIMAL_DIFF_NN_LP_CONSTR, rep_bisected_r, rep_original_t);
    cerr << "Done" << endl;

    cerr << "Constructing dif_B_cplex_vn_un_lp" << endl;
    dif_B_vn_un_lp = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(OPTIMAL_DIFF_VN_LP_UNCONSTR, rep_bisected_r, rep_original_t);
    cerr << "Done" << endl;

    cerr << "Constructing dif_B_cplex_vn_con_lp" << endl;
    dif_B_vn_con_lp = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(OPTIMAL_DIFF_VN_LP_CONSTR, rep_bisected_r, rep_original_t);
    cerr << "Done" << endl;
  }

  cerr << "Constructing dif_B_rec" << endl;
  dif_B_rec = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedRecCoder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_rec_bl" << endl;
  dif_B_rec_bl = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedRecCoder>(INORDER, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  ////////

  cerr << "Constructing dif_B_H" << endl;
  dif_B_H = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridCoder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_H_bl" << endl;
  dif_B_H_bl = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridCoder>(INORDER, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_HR" << endl;
  dif_B_HR = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridReducedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_HR_bl" << endl;
  dif_B_HR_bl = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridReducedCoder>(INORDER, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_HO1" << endl;
  dif_B_HO1 = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridOpt1Coder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_HO1_bl" << endl;
  dif_B_HO1_bl = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridOpt1Coder>(INORDER, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_HO1R" << endl;
  dif_B_HO1R = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridOpt1ReducedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_HO1R_bl" << endl;
  dif_B_HO1R_bl = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedHybridOpt1ReducedCoder>(INORDER, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;


  /////////

  cerr << "Constructing dif_B_rec_opt1" << endl;
  dif_B_rec_opt1 = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedRecOpt1Coder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_rec_opt1_bl" << endl;
  dif_B_rec_opt1_bl = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedRecOpt1Coder>(INORDER, rep_bisected_r, rep_original_t, hack);
  cerr << "Done" << endl;

  ////////////

  cerr << "Constructing dif_B_nodif" << endl;
  dif_B_nodif = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);
  cerr << "Done" << endl;

  cerr << "Constructing dif_B_nodif_diff" << endl;
  dif_B_nodif_diff = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);
  cerr << "Done" << endl;

  /* cerr << "Constructing dif_W" << endl;
     dif_W = new DiffGraphR<OffsetsBV_RRR, MyVarintWordBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
     cerr << "Done" << endl;

     cerr << "Constructing dif_W_rec" << endl;
     dif_W_rec = new DiffGraphR<OffsetsBV_RRR, MyVarintWordBasedRecCoder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
     cerr << "Done" << endl;

     cerr << "Constructing dif_W_nodif" << endl;
     dif_W_nodif = new DiffGraphR<OffsetsBV_RRR, MyVarintWordBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, rep_bisected_r, rep_original_t);
     cerr << "Done" << endl;
   */

  double rep_original_t_ADJ_SIZE = rep_original_t->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double rep_original_t_OFFSETS_SIZE = rep_original_t->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double rep_original_t_TOTAL_SIZE = rep_original_t_ADJ_SIZE + rep_original_t_OFFSETS_SIZE;

  double rep_original_m_ADJ_SIZE = rep_original_m->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double rep_original_m_OFFSETS_SIZE = rep_original_m->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double rep_original_m_TOTAL_SIZE = rep_original_m_ADJ_SIZE + rep_original_m_OFFSETS_SIZE;

  double dif_B_ADJ_SIZE = dif_B->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_OFFSETS_SIZE = dif_B->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_TOTAL_SIZE = dif_B_ADJ_SIZE + dif_B_OFFSETS_SIZE; 

  double dif_B_nn_un_ilp_ADJ_SIZE = -1;
  double dif_B_nn_un_ilp_OFFSETS_SIZE = -1; 
  double dif_B_nn_un_ilp_TOTAL_SIZE = -1;

  double dif_B_nn_con_ilp_ADJ_SIZE = -1;
  double dif_B_nn_con_ilp_OFFSETS_SIZE = -1;
  double dif_B_nn_con_ilp_TOTAL_SIZE = -1;

  double dif_B_vn_un_ilp_ADJ_SIZE = -1;
  double dif_B_vn_un_ilp_OFFSETS_SIZE = -1;
  double dif_B_vn_un_ilp_TOTAL_SIZE = -1;

  double dif_B_vn_con_ilp_ADJ_SIZE = -1;
  double dif_B_vn_con_ilp_OFFSETS_SIZE = -1;
  double dif_B_vn_con_ilp_TOTAL_SIZE = -1;

  double dif_B_nn_un_lp_ADJ_SIZE = -1;
  double dif_B_nn_un_lp_OFFSETS_SIZE = -1; 
  double dif_B_nn_un_lp_TOTAL_SIZE = -1;

  double dif_B_nn_con_lp_ADJ_SIZE = -1;
  double dif_B_nn_con_lp_OFFSETS_SIZE = -1;
  double dif_B_nn_con_lp_TOTAL_SIZE = -1;

  double dif_B_vn_un_lp_ADJ_SIZE = -1;
  double dif_B_vn_un_lp_OFFSETS_SIZE = -1;
  double dif_B_vn_un_lp_TOTAL_SIZE = -1;

  double dif_B_vn_con_lp_ADJ_SIZE = -1;
  double dif_B_vn_con_lp_OFFSETS_SIZE = -1;
  double dif_B_vn_con_lp_TOTAL_SIZE = -1;


  if(do_ilp == "Y") {
    dif_B_nn_un_ilp_ADJ_SIZE = dif_B_nn_un_ilp->adj_data_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_nn_un_ilp_OFFSETS_SIZE = dif_B_nn_un_ilp->offsets_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_nn_un_ilp_TOTAL_SIZE = dif_B_nn_un_ilp_ADJ_SIZE + dif_B_nn_un_ilp_OFFSETS_SIZE; 

    dif_B_nn_con_ilp_ADJ_SIZE = dif_B_nn_con_ilp->adj_data_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_nn_con_ilp_OFFSETS_SIZE = dif_B_nn_con_ilp->offsets_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_nn_con_ilp_TOTAL_SIZE = dif_B_nn_con_ilp_ADJ_SIZE + dif_B_nn_con_ilp_OFFSETS_SIZE; 

    dif_B_vn_un_ilp_ADJ_SIZE = dif_B_vn_un_ilp->adj_data_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_vn_un_ilp_OFFSETS_SIZE = dif_B_vn_un_ilp->offsets_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_vn_un_ilp_TOTAL_SIZE = dif_B_vn_un_ilp_ADJ_SIZE + dif_B_vn_un_ilp_OFFSETS_SIZE; 

    dif_B_vn_con_ilp_ADJ_SIZE = dif_B_vn_con_ilp->adj_data_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_vn_con_ilp_OFFSETS_SIZE = dif_B_vn_con_ilp->offsets_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_vn_con_ilp_TOTAL_SIZE = dif_B_vn_con_ilp_ADJ_SIZE + dif_B_vn_con_ilp_OFFSETS_SIZE; 
  }

  if(do_lp == "Y") {
    dif_B_nn_un_lp_ADJ_SIZE = dif_B_nn_un_lp->adj_data_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_nn_un_lp_OFFSETS_SIZE = dif_B_nn_un_lp->offsets_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_nn_un_lp_TOTAL_SIZE = dif_B_nn_un_lp_ADJ_SIZE + dif_B_nn_un_lp_OFFSETS_SIZE; 

    dif_B_nn_con_lp_ADJ_SIZE = dif_B_nn_con_lp->adj_data_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_nn_con_lp_OFFSETS_SIZE = dif_B_nn_con_lp->offsets_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_nn_con_lp_TOTAL_SIZE = dif_B_nn_con_lp_ADJ_SIZE + dif_B_nn_con_lp_OFFSETS_SIZE; 

    dif_B_vn_un_lp_ADJ_SIZE = dif_B_vn_un_lp->adj_data_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_vn_un_lp_OFFSETS_SIZE = dif_B_vn_un_lp->offsets_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_vn_un_lp_TOTAL_SIZE = dif_B_vn_un_lp_ADJ_SIZE + dif_B_vn_un_lp_OFFSETS_SIZE; 

    dif_B_vn_con_lp_ADJ_SIZE = dif_B_vn_con_lp->adj_data_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_vn_con_lp_OFFSETS_SIZE = dif_B_vn_con_lp->offsets_total_size_in_bytes()/(1.0*1024*1024);
    dif_B_vn_con_lp_TOTAL_SIZE = dif_B_vn_con_lp_ADJ_SIZE + dif_B_vn_con_lp_OFFSETS_SIZE; 
  }

  double dif_B_rec_ADJ_SIZE = dif_B_rec->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_rec_OFFSETS_SIZE = dif_B_rec->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_rec_TOTAL_SIZE = dif_B_rec_ADJ_SIZE + dif_B_rec_OFFSETS_SIZE; 

  double dif_B_rec_bl_ADJ_SIZE = dif_B_rec_bl->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_rec_bl_OFFSETS_SIZE = dif_B_rec_bl->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_rec_bl_TOTAL_SIZE = dif_B_rec_bl_ADJ_SIZE + dif_B_rec_bl_OFFSETS_SIZE; 


  double dif_B_H_ADJ_SIZE = dif_B_H->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_H_OFFSETS_SIZE = dif_B_H->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_H_TOTAL_SIZE = dif_B_H_ADJ_SIZE + dif_B_H_OFFSETS_SIZE; 

  double dif_B_H_bl_ADJ_SIZE = dif_B_H_bl->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_H_bl_OFFSETS_SIZE = dif_B_H_bl->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_H_bl_TOTAL_SIZE = dif_B_H_bl_ADJ_SIZE + dif_B_H_bl_OFFSETS_SIZE; 

  double dif_B_HR_ADJ_SIZE = dif_B_HR->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HR_OFFSETS_SIZE = dif_B_HR->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HR_TOTAL_SIZE = dif_B_HR_ADJ_SIZE + dif_B_HR_OFFSETS_SIZE; 

  double dif_B_HR_bl_ADJ_SIZE = dif_B_HR_bl->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HR_bl_OFFSETS_SIZE = dif_B_HR_bl->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HR_bl_TOTAL_SIZE = dif_B_HR_bl_ADJ_SIZE + dif_B_HR_bl_OFFSETS_SIZE; 

  double dif_B_HO1_ADJ_SIZE = dif_B_HO1->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HO1_OFFSETS_SIZE = dif_B_HO1->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HO1_TOTAL_SIZE = dif_B_HO1_ADJ_SIZE + dif_B_HO1_OFFSETS_SIZE; 

  double dif_B_HO1_bl_ADJ_SIZE = dif_B_HO1_bl->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HO1_bl_OFFSETS_SIZE = dif_B_HO1_bl->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HO1_bl_TOTAL_SIZE = dif_B_HO1_bl_ADJ_SIZE + dif_B_HO1_bl_OFFSETS_SIZE; 

  double dif_B_HO1R_ADJ_SIZE = dif_B_HO1R->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HO1R_OFFSETS_SIZE = dif_B_HO1R->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HO1R_TOTAL_SIZE = dif_B_HO1R_ADJ_SIZE + dif_B_HO1R_OFFSETS_SIZE; 

  double dif_B_HO1R_bl_ADJ_SIZE = dif_B_HO1R_bl->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HO1R_bl_OFFSETS_SIZE = dif_B_HO1R_bl->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_HO1R_bl_TOTAL_SIZE = dif_B_HO1R_bl_ADJ_SIZE + dif_B_HO1R_bl_OFFSETS_SIZE; 


  double dif_B_rec_opt1_ADJ_SIZE = dif_B_rec_opt1->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_rec_opt1_OFFSETS_SIZE = dif_B_rec_opt1->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_rec_opt1_TOTAL_SIZE = dif_B_rec_opt1_ADJ_SIZE + dif_B_rec_opt1_OFFSETS_SIZE; 

  double dif_B_rec_opt1_bl_ADJ_SIZE = dif_B_rec_opt1_bl->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_rec_opt1_bl_OFFSETS_SIZE = dif_B_rec_opt1_bl->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_rec_opt1_bl_TOTAL_SIZE = dif_B_rec_opt1_bl_ADJ_SIZE + dif_B_rec_opt1_bl_OFFSETS_SIZE; 

  double dif_B_nodif_ADJ_SIZE = dif_B_nodif->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_nodif_OFFSETS_SIZE = dif_B_nodif->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_nodif_TOTAL_SIZE = dif_B_nodif_ADJ_SIZE + dif_B_nodif_OFFSETS_SIZE; 

  double dif_B_nodif_diff_ADJ_SIZE = dif_B_nodif_diff->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_nodif_diff_OFFSETS_SIZE = dif_B_nodif_diff->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_nodif_diff_TOTAL_SIZE = dif_B_nodif_diff_ADJ_SIZE + dif_B_nodif_diff_OFFSETS_SIZE; 

  /*  double dif_W_ADJ_SIZE = dif_W->adj_data_total_size_in_bytes()/(1.0*1024*1024);
      double dif_W_OFFSETS_SIZE = dif_W->offsets_total_size_in_bytes()/(1.0*1024*1024);
      double dif_W_TOTAL_SIZE = dif_W_ADJ_SIZE + dif_W_OFFSETS_SIZE; 

      double dif_W_rec_ADJ_SIZE = dif_W_rec->adj_data_total_size_in_bytes()/(1.0*1024*1024);
      double dif_W_rec_OFFSETS_SIZE = dif_W_rec->offsets_total_size_in_bytes()/(1.0*1024*1024);
      double dif_W_rec_TOTAL_SIZE = dif_W_rec_ADJ_SIZE + dif_W_rec_OFFSETS_SIZE; 

      double dif_W_nodif_ADJ_SIZE = dif_W_nodif->adj_data_total_size_in_bytes()/(1.0*1024*1024);
      double dif_W_nodif_OFFSETS_SIZE = dif_W_nodif->offsets_total_size_in_bytes()/(1.0*1024*1024);
      double dif_W_nodif_TOTAL_SIZE = dif_W_nodif_ADJ_SIZE + dif_W_nodif_OFFSETS_SIZE; 
   */


  /*

     ofstream f_all_size;
     f_all_size.open("holistic_storage_bench.size.all", ios::app);

     f_all_size << GRAPH_S << " "
     << rep_original_t_ADJ_SIZE << " " << rep_original_t_OFFSETS_SIZE << " " << rep_original_t_TOTAL_SIZE  << " "
     << rep_original_m_ADJ_SIZE << " " << rep_original_m_OFFSETS_SIZE << " " << rep_original_m_TOTAL_SIZE << " "
     << dif_B_ADJ_SIZE          << " " << dif_B_OFFSETS_SIZE          << " " << dif_B_TOTAL_SIZE << " "
     << dif_B_rec_ADJ_SIZE      << " " << dif_B_rec_OFFSETS_SIZE      << " " << dif_B_rec_TOTAL_SIZE << " "
     << dif_B_rec_bl_ADJ_SIZE      << " " << dif_B_rec_bl_OFFSETS_SIZE      << " " << dif_B_rec_bl_TOTAL_SIZE << " "
     << dif_B_rec_opt1_ADJ_SIZE << " " << dif_B_rec_opt1_OFFSETS_SIZE << " " << dif_B_rec_opt1_TOTAL_SIZE << " "
     << dif_B_rec_opt1_bl_ADJ_SIZE << " " << dif_B_rec_opt1_bl_OFFSETS_SIZE << " " << dif_B_rec_opt1_bl_TOTAL_SIZE << " "
     << dif_B_nodif_ADJ_SIZE    << " " << dif_B_nodif_OFFSETS_SIZE    << " " << dif_B_nodif_TOTAL_SIZE << " "
     << dif_B_nn_con_ilp_ADJ_SIZE          << " " << dif_B_nn_con_ilp_OFFSETS_SIZE          << " " << dif_B_nn_con_ilp_TOTAL_SIZE << " "
     << dif_B_nn_con_lp_ADJ_SIZE          << " " << dif_B_nn_con_lp_OFFSETS_SIZE          << " " << dif_B_nn_con_lp_TOTAL_SIZE << " "
     << dif_B_nn_un_ilp_ADJ_SIZE          << " " << dif_B_nn_un_ilp_OFFSETS_SIZE          << " " << dif_B_nn_un_ilp_TOTAL_SIZE << " "
     << dif_B_nn_un_lp_ADJ_SIZE          << " " << dif_B_nn_un_lp_OFFSETS_SIZE          << " " << dif_B_nn_un_lp_TOTAL_SIZE << " "
     << dif_B_vn_con_ilp_ADJ_SIZE          << " " << dif_B_vn_con_ilp_OFFSETS_SIZE          << " " << dif_B_vn_con_ilp_TOTAL_SIZE << " "
     << dif_B_vn_con_lp_ADJ_SIZE          << " " << dif_B_vn_con_lp_OFFSETS_SIZE          << " " << dif_B_vn_con_lp_TOTAL_SIZE << " "
     << dif_B_vn_un_ilp_ADJ_SIZE          << " " << dif_B_vn_un_ilp_OFFSETS_SIZE          << " " << dif_B_vn_un_ilp_TOTAL_SIZE << " "
     << dif_B_vn_un_lp_ADJ_SIZE          << " " << dif_B_vn_un_lp_OFFSETS_SIZE          << " " << dif_B_vn_un_lp_TOTAL_SIZE << " "
  //           << dif_W_ADJ_SIZE          << " " << dif_W_OFFSETS_SIZE          << " " << dif_W_TOTAL_SIZE << " "
  //           << dif_W_rec_ADJ_SIZE      << " " << dif_W_rec_OFFSETS_SIZE      << " " << dif_W_rec_TOTAL_SIZE << " "
  //           << dif_W_nodif_ADJ_SIZE    << " " << dif_W_nodif_OFFSETS_SIZE    << " " << dif_W_nodif_TOTAL_SIZE << " "

  << endl;

  f_all_size.close();

   */

  ofstream f_cat_size;
  f_cat_size.open(dir + "/" + file, ios::app);

  f_cat_size << GRAPH_S << " byte Trad x x x adj " << rep_original_t_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte Trad x x x off " << rep_original_t_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte Trad x x x tot " << rep_original_t_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte CSR x x x adj " << rep_original_m_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte CSR x x x off " << rep_original_m_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte CSR x x x tot " << rep_original_m_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BF x x x adj " << dif_B_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BF x x x off " << dif_B_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BF x x x tot " << dif_B_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BRaI x x x adj " << dif_B_rec_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRaI x x x off " << dif_B_rec_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRaI x x x tot " << dif_B_rec_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BRaN x x x adj " << dif_B_rec_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRaN x x x off " << dif_B_rec_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRaN x x x tot " << dif_B_rec_TOTAL_SIZE << endl;


  f_cat_size << GRAPH_S << " byte BBHI x x x adj " << dif_B_H_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHI x x x off " << dif_B_H_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHI x x x tot " << dif_B_H_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHN x x x adj " << dif_B_H_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHN x x x off " << dif_B_H_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHN x x x tot " << dif_B_H_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHRI x x x adj " << dif_B_HR_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHRI x x x off " << dif_B_HR_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHRI x x x tot " << dif_B_HR_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHRN x x x adj " << dif_B_HR_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHRN x x x off " << dif_B_HR_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHRN x x x tot " << dif_B_HR_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHO1I x x x adj " << dif_B_HO1_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1I x x x off " << dif_B_HO1_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1I x x x tot " << dif_B_HO1_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHO1N x x x adj " << dif_B_HO1_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1N x x x off " << dif_B_HO1_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1N x x x tot " << dif_B_HO1_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHO1RI x x x adj " << dif_B_HO1R_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1RI x x x off " << dif_B_HO1R_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1RI x x x tot " << dif_B_HO1R_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHO1RN x x x adj " << dif_B_HO1R_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1RN x x x off " << dif_B_HO1R_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1RN x x x tot " << dif_B_HO1R_TOTAL_SIZE << endl;


  f_cat_size << GRAPH_S << " byte BRbI x x x adj " << dif_B_rec_opt1_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRbI x x x off " << dif_B_rec_opt1_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRbI x x x tot " << dif_B_rec_opt1_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BRbN x x x adj " << dif_B_rec_opt1_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRbN x x x off " << dif_B_rec_opt1_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRbN x x x tot " << dif_B_rec_opt1_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte DM x x x adj " << dif_B_nodif_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte DM x x x off " << dif_B_nodif_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte DM x x x tot " << dif_B_nodif_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte DMd x x x adj " << dif_B_nodif_diff_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte DMd x x x off " << dif_B_nodif_diff_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte DMd x x x tot " << dif_B_nodif_diff_TOTAL_SIZE << endl;

  if(do_ilp == "Y") {
    f_cat_size << GRAPH_S << " byte OP vn un ilp adj " << dif_B_vn_un_ilp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn un ilp off " << dif_B_vn_un_ilp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn un ilp tot " << dif_B_vn_un_ilp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP vn con ilp adj " << dif_B_vn_con_ilp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn con ilp off " << dif_B_vn_con_ilp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn con ilp tot " << dif_B_vn_con_ilp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP nn un ilp adj " << dif_B_nn_un_ilp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn un ilp off " << dif_B_nn_un_ilp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn un ilp tot " << dif_B_nn_un_ilp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP nn con ilp adj " << dif_B_nn_con_ilp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn con ilp off " << dif_B_nn_con_ilp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn con ilp tot " << dif_B_nn_con_ilp_TOTAL_SIZE << endl;

  }

  if(do_lp == "Y") {
    f_cat_size << GRAPH_S << " byte OP vn un lp adj " << dif_B_vn_un_lp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn un lp off " << dif_B_vn_un_lp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn un lp tot " << dif_B_vn_un_lp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP vn con lp adj " << dif_B_vn_con_lp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn con lp off " << dif_B_vn_con_lp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn con lp tot " << dif_B_vn_con_lp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP nn un lp adj " << dif_B_nn_un_lp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn un lp off " << dif_B_nn_un_lp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn un lp tot " << dif_B_nn_un_lp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP nn con lp adj " << dif_B_nn_con_lp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn con lp off " << dif_B_nn_con_lp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn con lp tot " << dif_B_nn_con_lp_TOTAL_SIZE << endl;
  }

  /*
     f_cat_size << GRAPH_ << " word BF x x x adj " << rep_original_B_ADJ_SIZE << endl;
     f_cat_size << GRAPH_ << " word BF x x x off " << rep_original_B_OFFSETS_SIZE << endl;
     f_cat_size << GRAPH_ << " word BF x x x tot " << rep_original_B_TOTAL_SIZE << endl;

     f_cat_size << GRAPH_ << " word BR1 I x x adj " << rep_original_rec_bl_ADJ_SIZE << endl;
     f_cat_size << GRAPH_ << " word BR1 I x x off " << rep_original_rec_bl_OFFSETS_SIZE << endl;
     f_cat_size << GRAPH_ << " word BR1 I x x tot " << rep_original_rec_bl_TOTAL_SIZE << endl;

     f_cat_size << GRAPH_ << " word DM x x x adj " << rep_original_nodif_ADJ_SIZE << endl;
     f_cat_size << GRAPH_ << " word DM x x x off " << rep_original_nodif_OFFSETS_SIZE << endl;
     f_cat_size << GRAPH_ << " word DM x x x tot " << rep_original_nodif_TOTAL_SIZE << endl;
   */


  f_cat_size.close();


  rep_original_m_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  rep_original_m_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  rep_original_m_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_rec_bl_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_rec_bl_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_rec_bl_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_rec_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_rec_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_rec_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;


  dif_B_H_bl_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_H_bl_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_H_bl_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_H_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_H_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_H_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_HR_bl_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_HR_bl_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_HR_bl_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_HR_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_HR_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_HR_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_HO1_bl_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_HO1_bl_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_HO1_bl_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_HO1_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_HO1_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_HO1_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_HO1R_bl_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_HO1R_bl_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_HO1R_bl_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_HO1R_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_HO1R_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_HO1R_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;


  dif_B_rec_opt1_bl_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_rec_opt1_bl_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_rec_opt1_bl_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_rec_opt1_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_rec_opt1_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_rec_opt1_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_nodif_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_nodif_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_nodif_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  dif_B_nodif_diff_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
  dif_B_nodif_diff_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  dif_B_nodif_diff_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

  if(do_ilp == "Y") {
    dif_B_vn_un_ilp_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
    dif_B_vn_un_ilp_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
    dif_B_vn_un_ilp_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

    dif_B_vn_con_ilp_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
    dif_B_vn_con_ilp_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
    dif_B_vn_con_ilp_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

    dif_B_nn_un_ilp_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
    dif_B_nn_un_ilp_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
    dif_B_nn_un_ilp_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

    dif_B_nn_con_ilp_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
    dif_B_nn_con_ilp_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
    dif_B_nn_con_ilp_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;
  }


  if(do_lp == "Y") {
    dif_B_vn_un_lp_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
    dif_B_vn_un_lp_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
    dif_B_vn_un_lp_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

    dif_B_vn_con_lp_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
    dif_B_vn_con_lp_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
    dif_B_vn_con_lp_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

    dif_B_nn_un_lp_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
    dif_B_nn_un_lp_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
    dif_B_nn_un_lp_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;

    dif_B_nn_con_lp_ADJ_SIZE /= rep_original_t_ADJ_SIZE;
    dif_B_nn_con_lp_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
    dif_B_nn_con_lp_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;
  }

  rep_original_t_ADJ_SIZE /= rep_original_t_ADJ_SIZE ;
  rep_original_t_OFFSETS_SIZE /= rep_original_t_OFFSETS_SIZE;
  rep_original_t_TOTAL_SIZE /= rep_original_t_TOTAL_SIZE;



  f_cat_size.open(dir + "/" + file + ".norm", ios::app);

  f_cat_size << GRAPH_S << " byte Trad x x x adj " << rep_original_t_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte Trad x x x off " << rep_original_t_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte Trad x x x tot " << rep_original_t_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte CSR x x x adj " << rep_original_m_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte CSR x x x off " << rep_original_m_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte CSR x x x tot " << rep_original_m_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BF x x x adj " << dif_B_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BF x x x off " << dif_B_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BF x x x tot " << dif_B_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BRaI x x x adj " << dif_B_rec_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRaI x x x off " << dif_B_rec_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRaI x x x tot " << dif_B_rec_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BRaN x x x adj " << dif_B_rec_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRaN x x x off " << dif_B_rec_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRaN x x x tot " << dif_B_rec_TOTAL_SIZE << endl;


  f_cat_size << GRAPH_S << " byte BBHI x x x adj " << dif_B_H_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHI x x x off " << dif_B_H_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHI x x x tot " << dif_B_H_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHN x x x adj " << dif_B_H_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHN x x x off " << dif_B_H_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHN x x x tot " << dif_B_H_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHRI x x x adj " << dif_B_HR_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHRI x x x off " << dif_B_HR_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHRI x x x tot " << dif_B_HR_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHRN x x x adj " << dif_B_HR_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHRN x x x off " << dif_B_HR_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHRN x x x tot " << dif_B_HR_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHO1I x x x adj " << dif_B_HO1_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1I x x x off " << dif_B_HO1_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1I x x x tot " << dif_B_HO1_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHO1N x x x adj " << dif_B_HO1_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1N x x x off " << dif_B_HO1_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1N x x x tot " << dif_B_HO1_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHO1RI x x x adj " << dif_B_HO1R_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1RI x x x off " << dif_B_HO1R_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1RI x x x tot " << dif_B_HO1R_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BBHO1RN x x x adj " << dif_B_HO1R_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1RN x x x off " << dif_B_HO1R_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BBHO1RN x x x tot " << dif_B_HO1R_TOTAL_SIZE << endl;


  f_cat_size << GRAPH_S << " byte BRbI x x x adj " << dif_B_rec_opt1_bl_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRbI x x x off " << dif_B_rec_opt1_bl_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRbI x x x tot " << dif_B_rec_opt1_bl_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte BRbN x x x adj " << dif_B_rec_opt1_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRbN x x x off " << dif_B_rec_opt1_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte BRbN x x x tot " << dif_B_rec_opt1_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte DM x x x adj " << dif_B_nodif_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte DM x x x off " << dif_B_nodif_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte DM x x x tot " << dif_B_nodif_TOTAL_SIZE << endl;

  f_cat_size << GRAPH_S << " byte DMd x x x adj " << dif_B_nodif_diff_ADJ_SIZE << endl;
  f_cat_size << GRAPH_S << " byte DMd x x x off " << dif_B_nodif_diff_OFFSETS_SIZE << endl;
  f_cat_size << GRAPH_S << " byte DMd x x x tot " << dif_B_nodif_diff_TOTAL_SIZE << endl;

  if(do_ilp == "Y") {
    f_cat_size << GRAPH_S << " byte OP vn un ilp adj " << dif_B_vn_un_ilp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn un ilp off " << dif_B_vn_un_ilp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn un ilp tot " << dif_B_vn_un_ilp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP vn con ilp adj " << dif_B_vn_con_ilp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn con ilp off " << dif_B_vn_con_ilp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn con ilp tot " << dif_B_vn_con_ilp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP nn un ilp adj " << dif_B_nn_un_ilp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn un ilp off " << dif_B_nn_un_ilp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn un ilp tot " << dif_B_nn_un_ilp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP nn con ilp adj " << dif_B_nn_con_ilp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn con ilp off " << dif_B_nn_con_ilp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn con ilp tot " << dif_B_nn_con_ilp_TOTAL_SIZE << endl;

  }

  if(do_lp == "Y") {
    f_cat_size << GRAPH_S << " byte OP vn un lp adj " << dif_B_vn_un_lp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn un lp off " << dif_B_vn_un_lp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn un lp tot " << dif_B_vn_un_lp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP vn con lp adj " << dif_B_vn_con_lp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn con lp off " << dif_B_vn_con_lp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP vn con lp tot " << dif_B_vn_con_lp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP nn un lp adj " << dif_B_nn_un_lp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn un lp off " << dif_B_nn_un_lp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn un lp tot " << dif_B_nn_un_lp_TOTAL_SIZE << endl;

    f_cat_size << GRAPH_S << " byte OP nn con lp adj " << dif_B_nn_con_lp_ADJ_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn con lp off " << dif_B_nn_con_lp_OFFSETS_SIZE << endl;
    f_cat_size << GRAPH_S << " byte OP nn con lp tot " << dif_B_nn_con_lp_TOTAL_SIZE << endl;
  }



  f_cat_size.close();

  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  delete rep_bisected_r;
  delete rep_original_t;
  delete rep_original_m;

  delete dif_B;
  delete dif_B_rec;
  delete dif_B_rec_bl;

  delete dif_B_H;
  delete dif_B_H_bl;
  delete dif_B_HR;
  delete dif_B_HR_bl;
  delete dif_B_HO1;
  delete dif_B_HO1_bl;
  delete dif_B_HO1R;
  delete dif_B_HO1R_bl;
  
  delete dif_B_rec_opt1;
  delete dif_B_rec_opt1_bl;
  delete dif_B_nodif;
  delete dif_B_nodif_diff;

  if(do_ilp == "Y") {
    delete dif_B_vn_con_ilp;
    delete dif_B_vn_un_ilp;
    delete dif_B_nn_con_ilp;
    delete dif_B_nn_un_ilp;
  }

  if(do_lp == "Y") {
    delete dif_B_vn_con_lp;
    delete dif_B_nn_con_lp;
    delete dif_B_nn_un_lp;
    delete dif_B_vn_un_lp;
  }

  delete dif_W;
  delete dif_W_rec;
  delete dif_W_nodif;

  return EXIT_SUCCESS;
}
