#include <cinttypes>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <pthread.h>
#include <cassert>
#include <chrono>
#include <iostream>

#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "utils/diffAnalysis.h"

#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "representations/diffGraphR.h"

#include "partitioners/recPart.h"

#include "coders/myVarintByteBasedCoder.h"
#include "coders/myVarintWordBasedCoder.h"

#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsPtrsLogn.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBV_IL.h"
#include "offsetStructures/offsetsBV_SD.h"
#include "offsetStructures/offsetsBV_RRR.h"

using namespace std;

std::string GRAPH_S;
std::string GRAPH_NAME;
std::string GRAPH_FILE_T;
std::string GRAPH_FILE_R;

////////////////////////////////////////////////////////////

TradListGraphR* rep_original_t = NULL;
MetisR* rep_original_m = NULL;
SimpleRecGraphR* rep_bisected_r = NULL;

DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_bvRRR;
DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>* dif_B_bvSD;
DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>* dif_B_bvIL;
DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>* dif_B_bv;
DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_B_ptr64;
DiffGraphR<OffsetsPtrsLogn, MyVarintByteBasedCoder>* dif_B_ptrLogn;

DiffGraphR<OffsetsBV_RRR, MyVarintWordBasedCoder>* dif_W_bvRRR;
DiffGraphR<OffsetsBV_SD, MyVarintWordBasedCoder>* dif_W_bvSD;
DiffGraphR<OffsetsBV_IL, MyVarintWordBasedCoder>* dif_W_bvIL;
DiffGraphR<OffsetsBV, MyVarintWordBasedCoder>* dif_W_bv;
DiffGraphR<OffsetsPtrs, MyVarintWordBasedCoder>* dif_W_ptr64;
DiffGraphR<OffsetsPtrsLogn, MyVarintWordBasedCoder>* dif_W_ptrLogn;

bool hack = true;

int main (int argc, char *argv[]) {
  GRAPH_S = argv[1];
  GRAPH_NAME = argv[2];
  GRAPH_FILE_T = argv[3];
  GRAPH_FILE_R = argv[4];

  assert(argc == 5);

  if(GRAPH_FILE_T == "" || GRAPH_FILE_R == "") {
    return EXIT_FAILURE;
  }

  //cerr << ">>> Loading original adjacency list from file." << endl;
  GraphIO::loadGraph(GRAPH_FILE_T.c_str(), &rep_original_t, &rep_original_m);
  //cerr << " ...Done" << endl;

  //cerr << ">>> Loading bisected representation from file." << endl;
  rep_bisected_r = GraphIO::readRecursivePartitioningFromFile(GRAPH_FILE_R);
  //cerr << " ...Done" << endl;

  dif_B_bvRRR   = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_bvSD    = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_bvIL    = new DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_bv    = new DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_ptr64   = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_ptrLogn = new DiffGraphR<OffsetsPtrsLogn, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);

  dif_W_bvRRR   = new DiffGraphR<OffsetsBV_RRR, MyVarintWordBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_W_bvSD    = new DiffGraphR<OffsetsBV_SD, MyVarintWordBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_W_bvIL    = new DiffGraphR<OffsetsBV_IL, MyVarintWordBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_W_bv    = new DiffGraphR<OffsetsBV, MyVarintWordBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_W_ptr64   = new DiffGraphR<OffsetsPtrs, MyVarintWordBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_W_ptrLogn = new DiffGraphR<OffsetsPtrsLogn, MyVarintWordBasedCoder>(INORDER, rep_bisected_r, rep_original_t);

  double dif_B_bvRRR_ADJ_SIZE = dif_B_bvRRR->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvRRR_OFFSETS_SIZE = dif_B_bvRRR->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvRRR_TOTAL_SIZE = dif_B_bvRRR_ADJ_SIZE + dif_B_bvRRR_OFFSETS_SIZE;

  double dif_B_bvSD_ADJ_SIZE = dif_B_bvSD->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvSD_OFFSETS_SIZE = dif_B_bvSD->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvSD_TOTAL_SIZE = dif_B_bvSD_ADJ_SIZE + dif_B_bvSD_OFFSETS_SIZE;

  double dif_B_bvIL_ADJ_SIZE = dif_B_bvIL->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvIL_OFFSETS_SIZE = dif_B_bvIL->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvIL_TOTAL_SIZE = dif_B_bvIL_ADJ_SIZE + dif_B_bvIL_OFFSETS_SIZE;

  double dif_B_bv_ADJ_SIZE = dif_B_bv->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bv_OFFSETS_SIZE = dif_B_bv->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bv_TOTAL_SIZE = dif_B_bv_ADJ_SIZE + dif_B_bv_OFFSETS_SIZE;

  double dif_B_ptr64_ADJ_SIZE = dif_B_ptr64->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptr64_OFFSETS_SIZE = dif_B_ptr64->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptr64_TOTAL_SIZE = dif_B_ptr64_ADJ_SIZE + dif_B_ptr64_OFFSETS_SIZE;

  double dif_B_ptrLogn_ADJ_SIZE = dif_B_ptrLogn->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptrLogn_OFFSETS_SIZE = dif_B_ptrLogn->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptrLogn_TOTAL_SIZE = dif_B_ptrLogn_ADJ_SIZE + dif_B_ptrLogn_OFFSETS_SIZE;


  double dif_W_bvRRR_ADJ_SIZE = dif_W_bvRRR->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_bvRRR_OFFSETS_SIZE = dif_W_bvRRR->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_bvRRR_TOTAL_SIZE = dif_W_bvRRR_ADJ_SIZE + dif_W_bvRRR_OFFSETS_SIZE;

  double dif_W_bvSD_ADJ_SIZE = dif_W_bvSD->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_bvSD_OFFSETS_SIZE = dif_W_bvSD->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_bvSD_TOTAL_SIZE = dif_W_bvSD_ADJ_SIZE + dif_W_bvSD_OFFSETS_SIZE;

  double dif_W_bvIL_ADJ_SIZE = dif_W_bvIL->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_bvIL_OFFSETS_SIZE = dif_W_bvIL->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_bvIL_TOTAL_SIZE = dif_W_bvIL_ADJ_SIZE + dif_W_bvIL_OFFSETS_SIZE;

  double dif_W_bv_ADJ_SIZE = dif_W_bv->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_bv_OFFSETS_SIZE = dif_W_bv->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_bv_TOTAL_SIZE = dif_W_bv_ADJ_SIZE + dif_W_bv_OFFSETS_SIZE;

  double dif_W_ptr64_ADJ_SIZE = dif_W_ptr64->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_ptr64_OFFSETS_SIZE = dif_W_ptr64->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_ptr64_TOTAL_SIZE = dif_W_ptr64_ADJ_SIZE + dif_W_ptr64_OFFSETS_SIZE;

  double dif_W_ptrLogn_ADJ_SIZE = dif_W_ptrLogn->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_ptrLogn_OFFSETS_SIZE = dif_W_ptrLogn->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_W_ptrLogn_TOTAL_SIZE = dif_W_ptrLogn_ADJ_SIZE + dif_W_ptrLogn_OFFSETS_SIZE;

  ofstream f_all;
  f_all.open("offsets_blocks_bench_res.inorder.all", ios::app);

  f_all << GRAPH_S << " "
       << dif_B_ptr64_ADJ_SIZE << " " << dif_B_ptr64_OFFSETS_SIZE << " " << dif_B_ptr64_TOTAL_SIZE << " "
       << dif_B_ptrLogn_ADJ_SIZE << " " << dif_B_ptrLogn_OFFSETS_SIZE << " " << dif_B_ptrLogn_TOTAL_SIZE << " "
       << dif_B_bv_ADJ_SIZE << " " << dif_B_bv_OFFSETS_SIZE << " " << dif_B_bv_TOTAL_SIZE << " "
       << dif_B_bvIL_ADJ_SIZE << " " << dif_B_bvIL_OFFSETS_SIZE << " " << dif_B_bvIL_TOTAL_SIZE << " "
       << dif_B_bvRRR_ADJ_SIZE << " " << dif_B_bvRRR_OFFSETS_SIZE << " " << dif_B_bvRRR_TOTAL_SIZE << " "
       << dif_B_bvSD_ADJ_SIZE << " " << dif_B_bvSD_OFFSETS_SIZE << " " << dif_B_bvSD_TOTAL_SIZE << " "
       << dif_W_ptr64_ADJ_SIZE << " " << dif_W_ptr64_OFFSETS_SIZE << " " << dif_W_ptr64_TOTAL_SIZE << " "
       << dif_W_ptrLogn_ADJ_SIZE << " " << dif_W_ptrLogn_OFFSETS_SIZE << " " << dif_W_ptrLogn_TOTAL_SIZE << " "
       << dif_W_bv_ADJ_SIZE << " " << dif_W_bv_OFFSETS_SIZE << " " << dif_W_bv_TOTAL_SIZE << " "
       << dif_W_bvIL_ADJ_SIZE << " " << dif_W_bvIL_OFFSETS_SIZE << " " << dif_W_bvIL_TOTAL_SIZE << " "
       << dif_W_bvRRR_ADJ_SIZE << " " << dif_W_bvRRR_OFFSETS_SIZE << " " << dif_W_bvRRR_TOTAL_SIZE << " "
       << dif_W_bvSD_ADJ_SIZE << " " << dif_W_bvSD_OFFSETS_SIZE << " " << dif_W_bvSD_TOTAL_SIZE 
       << endl;

   f_all.close();

  ofstream f_cat;
  f_cat.open("offsets_blocks_bench_res.inorder.cat", ios::app);

  f_cat << GRAPH_S << " byte ptr64 adj " << dif_B_ptr64_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte ptr64 off " << dif_B_ptr64_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte ptr64 tot " << dif_B_ptr64_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte ptrLogn adj " << dif_B_ptrLogn_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte ptrLogn off " << dif_B_ptrLogn_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte ptrLogn tot " << dif_B_ptrLogn_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvUN adj " << dif_B_bv_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvUN off " << dif_B_bv_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvUN tot " << dif_B_bv_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvIL adj " << dif_B_bvIL_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvIL off " << dif_B_bvIL_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvIL tot " << dif_B_bvIL_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvRRR adj " << dif_B_bvRRR_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvRRR off " << dif_B_bvRRR_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvRRR tot " << dif_B_bvRRR_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvSD adj " << dif_B_bvSD_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvSD off " << dif_B_bvSD_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvSD tot " << dif_B_bvSD_TOTAL_SIZE << endl;

  f_cat << GRAPH_S << " word ptr64 adj " << dif_W_ptr64_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word ptr64 off " << dif_W_ptr64_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word ptr64 tot " << dif_W_ptr64_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word ptrLogn adj " << dif_W_ptrLogn_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word ptrLogn off " << dif_W_ptrLogn_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word ptrLogn tot " << dif_W_ptrLogn_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word bvUN adj " << dif_W_bv_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word bvUN off " << dif_W_bv_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word bvUN tot " << dif_W_bv_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word bvIL adj " << dif_W_bvIL_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word bvIL off " << dif_W_bvIL_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word bvIL tot " << dif_W_bvIL_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word bvRRR adj " << dif_W_bvRRR_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word bvRRR off " << dif_W_bvRRR_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word bvRRR tot " << dif_W_bvRRR_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word bvSD adj " << dif_W_bvSD_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word bvSD off " << dif_W_bvSD_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word bvSD tot " << dif_W_bvSD_TOTAL_SIZE << endl;

   f_cat.close();


   dif_B_bvRRR_ADJ_SIZE /= dif_B_ptr64_ADJ_SIZE;
   dif_B_bvRRR_OFFSETS_SIZE /= dif_B_ptr64_OFFSETS_SIZE;
   dif_B_bvRRR_TOTAL_SIZE /= dif_B_ptr64_TOTAL_SIZE;

   dif_B_bvSD_ADJ_SIZE /= dif_B_ptr64_ADJ_SIZE;
   dif_B_bvSD_OFFSETS_SIZE /= dif_B_ptr64_OFFSETS_SIZE;
   dif_B_bvSD_TOTAL_SIZE /= dif_B_ptr64_TOTAL_SIZE;

   dif_B_bvIL_ADJ_SIZE /= dif_B_ptr64_ADJ_SIZE;
   dif_B_bvIL_OFFSETS_SIZE /= dif_B_ptr64_OFFSETS_SIZE;
   dif_B_bvIL_TOTAL_SIZE /= dif_B_ptr64_TOTAL_SIZE;

   dif_B_bv_ADJ_SIZE /= dif_B_ptr64_ADJ_SIZE;
   dif_B_bv_OFFSETS_SIZE /= dif_B_ptr64_OFFSETS_SIZE;
   dif_B_bv_TOTAL_SIZE /= dif_B_ptr64_TOTAL_SIZE;

   dif_B_ptrLogn_ADJ_SIZE /= dif_B_ptr64_ADJ_SIZE;
   dif_B_ptrLogn_OFFSETS_SIZE /= dif_B_ptr64_OFFSETS_SIZE;
   dif_B_ptrLogn_TOTAL_SIZE /= dif_B_ptr64_TOTAL_SIZE;

   dif_B_ptr64_ADJ_SIZE /= dif_B_ptr64_ADJ_SIZE;
   dif_B_ptr64_OFFSETS_SIZE /= dif_B_ptr64_OFFSETS_SIZE;
   dif_B_ptr64_TOTAL_SIZE /= dif_B_ptr64_TOTAL_SIZE;


   dif_W_bvRRR_ADJ_SIZE /= dif_W_ptr64_ADJ_SIZE;
   dif_W_bvRRR_OFFSETS_SIZE /= dif_W_ptr64_OFFSETS_SIZE;
   dif_W_bvRRR_TOTAL_SIZE /= dif_W_ptr64_TOTAL_SIZE;

   dif_W_bvSD_ADJ_SIZE /= dif_W_ptr64_ADJ_SIZE;
   dif_W_bvSD_OFFSETS_SIZE /= dif_W_ptr64_OFFSETS_SIZE;
   dif_W_bvSD_TOTAL_SIZE /= dif_W_ptr64_TOTAL_SIZE;

   dif_W_bvIL_ADJ_SIZE /= dif_W_ptr64_ADJ_SIZE;
   dif_W_bvIL_OFFSETS_SIZE /= dif_W_ptr64_OFFSETS_SIZE;
   dif_W_bvIL_TOTAL_SIZE /= dif_W_ptr64_TOTAL_SIZE;

   dif_W_bv_ADJ_SIZE /= dif_W_ptr64_ADJ_SIZE;
   dif_W_bv_OFFSETS_SIZE /= dif_W_ptr64_OFFSETS_SIZE;
   dif_W_bv_TOTAL_SIZE /= dif_W_ptr64_TOTAL_SIZE;

   dif_W_ptrLogn_ADJ_SIZE /= dif_W_ptr64_ADJ_SIZE;
   dif_W_ptrLogn_OFFSETS_SIZE /= dif_W_ptr64_OFFSETS_SIZE;
   dif_W_ptrLogn_TOTAL_SIZE /= dif_W_ptr64_TOTAL_SIZE;

   dif_W_ptr64_ADJ_SIZE /= dif_W_ptr64_ADJ_SIZE;
   dif_W_ptr64_OFFSETS_SIZE /= dif_W_ptr64_OFFSETS_SIZE;
   dif_W_ptr64_TOTAL_SIZE /= dif_W_ptr64_TOTAL_SIZE;



 // ofstream f_all;
  f_all.open("offsets_blocks_bench_res.inorder.all.norm", ios::app);

  f_all << GRAPH_S << " "
       << dif_B_ptr64_ADJ_SIZE << " " << dif_B_ptr64_OFFSETS_SIZE << " " << dif_B_ptr64_TOTAL_SIZE << " "
       << dif_B_ptrLogn_ADJ_SIZE << " " << dif_B_ptrLogn_OFFSETS_SIZE << " " << dif_B_ptrLogn_TOTAL_SIZE << " "
       << dif_B_bv_ADJ_SIZE << " " << dif_B_bv_OFFSETS_SIZE << " " << dif_B_bv_TOTAL_SIZE << " "
       << dif_B_bvIL_ADJ_SIZE << " " << dif_B_bvIL_OFFSETS_SIZE << " " << dif_B_bvIL_TOTAL_SIZE << " "
       << dif_B_bvRRR_ADJ_SIZE << " " << dif_B_bvRRR_OFFSETS_SIZE << " " << dif_B_bvRRR_TOTAL_SIZE << " "
       << dif_B_bvSD_ADJ_SIZE << " " << dif_B_bvSD_OFFSETS_SIZE << " " << dif_B_bvSD_TOTAL_SIZE << " "
       << dif_W_ptr64_ADJ_SIZE << " " << dif_W_ptr64_OFFSETS_SIZE << " " << dif_W_ptr64_TOTAL_SIZE << " "
       << dif_W_ptrLogn_ADJ_SIZE << " " << dif_W_ptrLogn_OFFSETS_SIZE << " " << dif_W_ptrLogn_TOTAL_SIZE << " "
       << dif_W_bv_ADJ_SIZE << " " << dif_W_bv_OFFSETS_SIZE << " " << dif_W_bv_TOTAL_SIZE << " "
       << dif_W_bvIL_ADJ_SIZE << " " << dif_W_bvIL_OFFSETS_SIZE << " " << dif_W_bvIL_TOTAL_SIZE << " "
       << dif_W_bvRRR_ADJ_SIZE << " " << dif_W_bvRRR_OFFSETS_SIZE << " " << dif_W_bvRRR_TOTAL_SIZE << " "
       << dif_W_bvSD_ADJ_SIZE << " " << dif_W_bvSD_OFFSETS_SIZE << " " << dif_W_bvSD_TOTAL_SIZE 
       << endl;

   f_all.close();

 // ofstream f_cat;
  f_cat.open("offsets_blocks_bench_res.inorder.cat.norm", ios::app);

  f_cat << GRAPH_S << " byte ptr64 adj " << dif_B_ptr64_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte ptr64 off " << dif_B_ptr64_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte ptr64 tot " << dif_B_ptr64_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte ptrLogn adj " << dif_B_ptrLogn_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte ptrLogn off " << dif_B_ptrLogn_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte ptrLogn tot " << dif_B_ptrLogn_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvUN adj " << dif_B_bv_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvUN off " << dif_B_bv_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvUN tot " << dif_B_bv_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvIL adj " << dif_B_bvIL_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvIL off " << dif_B_bvIL_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvIL tot " << dif_B_bvIL_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvRRR adj " << dif_B_bvRRR_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvRRR off " << dif_B_bvRRR_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvRRR tot " << dif_B_bvRRR_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvSD adj " << dif_B_bvSD_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvSD off " << dif_B_bvSD_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvSD tot " << dif_B_bvSD_TOTAL_SIZE << endl;

  f_cat << GRAPH_S << " word ptr64 adj " << dif_W_ptr64_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word ptr64 off " << dif_W_ptr64_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word ptr64 tot " << dif_W_ptr64_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word ptrLogn adj " << dif_W_ptrLogn_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word ptrLogn off " << dif_W_ptrLogn_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word ptrLogn tot " << dif_W_ptrLogn_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word bvUN adj " << dif_W_bv_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word bvUN off " << dif_W_bv_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word bvUN tot " << dif_W_bv_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word bvIL adj " << dif_W_bvIL_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word bvIL off " << dif_W_bvIL_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word bvIL tot " << dif_W_bvIL_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word bvRRR adj " << dif_W_bvRRR_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word bvRRR off " << dif_W_bvRRR_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word bvRRR tot " << dif_W_bvRRR_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " word bvSD adj " << dif_W_bvSD_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " word bvSD off " << dif_W_bvSD_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " word bvSD tot " << dif_W_bvSD_TOTAL_SIZE << endl;

   f_cat.close();




/*  cerr << GRAPH_S << " "
       << dif_B_ptr64_ADJ_SIZE << " " << dif_B_ptr64_OFFSETS_SIZE << " " << dif_B_ptr64_TOTAL_SIZE << " "
       << dif_B_ptrLogn_ADJ_SIZE << " " << dif_B_ptrLogn_OFFSETS_SIZE << " " << dif_B_ptrLogn_TOTAL_SIZE << " "
       << dif_B_bv_ADJ_SIZE << " " << dif_B_bv_OFFSETS_SIZE << " " << dif_B_bv_TOTAL_SIZE << " "
       << dif_B_bvIL_ADJ_SIZE << " " << dif_B_bvIL_OFFSETS_SIZE << " " << dif_B_bvIL_TOTAL_SIZE << " "
       << dif_B_bvRRR_ADJ_SIZE << " " << dif_B_bvRRR_OFFSETS_SIZE << " " << dif_B_bvRRR_TOTAL_SIZE << " "
       << dif_B_bvSD_ADJ_SIZE << " " << dif_B_bvSD_OFFSETS_SIZE << " " << dif_B_bvSD_TOTAL_SIZE << " "
       << dif_W_ptr64_ADJ_SIZE << " " << dif_W_ptr64_OFFSETS_SIZE << " " << dif_W_ptr64_TOTAL_SIZE << " "
       << dif_W_ptrLogn_ADJ_SIZE << " " << dif_W_ptrLogn_OFFSETS_SIZE << " " << dif_W_ptrLogn_TOTAL_SIZE << " "
       << dif_W_bv_ADJ_SIZE << " " << dif_W_bv_OFFSETS_SIZE << " " << dif_W_bv_TOTAL_SIZE << " "
       << dif_W_bvIL_ADJ_SIZE << " " << dif_W_bvIL_OFFSETS_SIZE << " " << dif_W_bvIL_TOTAL_SIZE << " "
       << dif_W_bvRRR_ADJ_SIZE << " " << dif_W_bvRRR_OFFSETS_SIZE << " " << dif_W_bvRRR_TOTAL_SIZE << " "
       << dif_W_bvSD_ADJ_SIZE << " " << dif_W_bvSD_OFFSETS_SIZE << " " << dif_W_bvSD_TOTAL_SIZE 
       << endl;
*/


  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  delete rep_bisected_r;
  delete rep_original_t;
  delete rep_original_m;
  
  delete dif_B_bvRRR;
  delete dif_B_bvSD;
  delete dif_B_bvIL;
  delete dif_B_bv;
  delete dif_B_ptr64;
  delete dif_B_ptrLogn;

  delete dif_W_bvRRR;
  delete dif_W_bvSD;
  delete dif_W_bvIL;
  delete dif_W_bv;
  delete dif_W_ptr64;
  delete dif_W_ptrLogn;

  return EXIT_SUCCESS;
}
