#include "globals.h"

#include "utils/graphIO.h"
#include "utils/debug.h"
#include "utils/diffAnalysis.h"

#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "representations/diffGraphR.h"

#include "coders/myVarintByteBasedCoder.h"

#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsPtrsCompressed.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBVCompressed.h"

#include "offsetStructures/offsetsPtrsLogn.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBV_IL.h"
#include "offsetStructures/offsetsBV_SD.h"
#include "offsetStructures/offsetsBV_RRR.h"

using namespace std;

DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_B_bvRRR;
DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>* dif_B_bvSD;
DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>* dif_B_bvIL;
DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>* dif_B_bv;
DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_B_ptr64;
DiffGraphR<OffsetsPtrsLogn, MyVarintByteBasedCoder>* dif_B_ptrLogn;

std::string GRAPH_S;
std::string GRAPH_NAME;
std::string GRAPH_FILE_T;
std::string GRAPH_FILE_R;

TradListGraphR* rep_original_t = NULL;
MetisR* rep_original_m = NULL;
SimpleRecGraphR* rep_bisected_r = NULL;

int main(int argc, char** argv) {
  GRAPH_S = argv[1];
  GRAPH_NAME = argv[2];
  GRAPH_FILE_T = argv[3];
  GRAPH_FILE_R = argv[4];

  string dir = argv[5];
  string file = argv[6];

  assert(argc == 7);

  if(GRAPH_FILE_T == "" || GRAPH_FILE_R == "") {
    return EXIT_FAILURE;
  }

  GraphIO::loadGraph(GRAPH_FILE_T.c_str(), &rep_original_t, &rep_original_m);
  rep_bisected_r = GraphIO::readRecursivePartitioningFromFile(GRAPH_FILE_R);

  DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_B;
  DiffGraphR<OffsetsPtrsCompressed, MyVarintByteBasedCoder>* dif_B_com;
  DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>* dif_B_bv;
  DiffGraphR<OffsetsBVCompressed, MyVarintByteBasedCoder>* dif_B_bv_com;

  cout << "Constructing dif_B" << endl;
  dif_B = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;

  cout << "Constructing dif_B_com" << endl;
  dif_B_com = new DiffGraphR<OffsetsPtrsCompressed, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;

  cout << "Constructing dif_B_bv" << endl;
  dif_B_bv = new DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;

  cout << "Constructing dif_B_bv_com" << endl;
  dif_B_bv_com = new DiffGraphR<OffsetsBVCompressed, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;

  dif_B_bvRRR   = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_bvSD    = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_bvIL    = new DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_bv    = new DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_ptr64   = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_B_ptrLogn = new DiffGraphR<OffsetsPtrsLogn, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);

  double dif_B_bvRRR_ADJ_SIZE = dif_B_bvRRR->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvRRR_OFFSETS_SIZE = dif_B_bvRRR->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvRRR_TOTAL_SIZE = dif_B_bvRRR_ADJ_SIZE + dif_B_bvRRR_OFFSETS_SIZE;

  double dif_B_bvSD_ADJ_SIZE = dif_B_bvSD->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvSD_OFFSETS_SIZE = dif_B_bvSD->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvSD_TOTAL_SIZE = dif_B_bvSD_ADJ_SIZE + dif_B_bvSD_OFFSETS_SIZE;

  double dif_B_bvIL_ADJ_SIZE = dif_B_bvIL->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvIL_OFFSETS_SIZE = dif_B_bvIL->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvIL_TOTAL_SIZE = dif_B_bvIL_ADJ_SIZE + dif_B_bvIL_OFFSETS_SIZE;

  double dif_B_bv_ADJ_SIZE = dif_B_bv->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bv_OFFSETS_SIZE = dif_B_bv->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bv_TOTAL_SIZE = dif_B_bv_ADJ_SIZE + dif_B_bv_OFFSETS_SIZE;

  double dif_B_bvC_ADJ_SIZE = dif_B_bv_com->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvC_OFFSETS_SIZE = dif_B_bv_com->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_bvC_TOTAL_SIZE = dif_B_bvC_ADJ_SIZE + dif_B_bvC_OFFSETS_SIZE;

  double dif_B_ptr64_ADJ_SIZE = dif_B_ptr64->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptr64_OFFSETS_SIZE = dif_B_ptr64->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptr64_TOTAL_SIZE = dif_B_ptr64_ADJ_SIZE + dif_B_ptr64_OFFSETS_SIZE;

  double dif_B_ptr64C_ADJ_SIZE = dif_B_com->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptr64C_OFFSETS_SIZE = dif_B_com->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptr64C_TOTAL_SIZE = dif_B_ptr64C_ADJ_SIZE + dif_B_ptr64C_OFFSETS_SIZE;

  double dif_B_ptrLogn_ADJ_SIZE = dif_B_ptrLogn->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptrLogn_OFFSETS_SIZE = dif_B_ptrLogn->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_B_ptrLogn_TOTAL_SIZE = dif_B_ptrLogn_ADJ_SIZE + dif_B_ptrLogn_OFFSETS_SIZE;



  ofstream f_cat;
  f_cat.open(dir + "/" + file, ios::app);

  f_cat << GRAPH_S << " byte ptr64 adj " << dif_B_ptr64_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte ptr64 off " << dif_B_ptr64_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte ptr64 tot " << dif_B_ptr64_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte ptr64C adj " << dif_B_ptr64C_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte ptr64C off " << dif_B_ptr64C_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte ptr64C tot " << dif_B_ptr64C_TOTAL_SIZE << endl;
//  f_cat << GRAPH_S << " byte ptrLogn adj " << dif_B_ptrLogn_ADJ_SIZE << endl;
//  f_cat << GRAPH_S << " byte ptrLogn off " << dif_B_ptrLogn_OFFSETS_SIZE << endl;
//  f_cat << GRAPH_S << " byte ptrLogn tot " << dif_B_ptrLogn_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvUN adj " << dif_B_bv_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvUN off " << dif_B_bv_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvUN tot " << dif_B_bv_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvC adj " << dif_B_bvC_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvC off " << dif_B_bvC_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvC tot " << dif_B_bvC_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvIL adj " << dif_B_bvIL_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvIL off " << dif_B_bvIL_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvIL tot " << dif_B_bvIL_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvRRR adj " << dif_B_bvRRR_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvRRR off " << dif_B_bvRRR_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvRRR tot " << dif_B_bvRRR_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " byte bvSD adj " << dif_B_bvSD_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " byte bvSD off " << dif_B_bvSD_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " byte bvSD tot " << dif_B_bvSD_TOTAL_SIZE << endl;

  f_cat.close();

  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  delete rep_original_t;
  delete rep_original_m;

  delete dif_B;
  delete dif_B_com;
  delete dif_B_bv;
  delete dif_B_bv_com;

  printf("OK\n");

  return 0;
}
