#include <cinttypes>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <pthread.h>
#include <cassert>
#include <chrono>
#include <iostream>

#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "utils/diffAnalysis.h"

#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "representations/diffGraphR.h"

#include "partitioners/recPart.h"

#include "coders/myVarintByteBasedCoder.h"

#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsPtrsLogn.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBV_IL.h"
#include "offsetStructures/offsetsBV_SD.h"
#include "offsetStructures/offsetsBV_RRR.h"

using namespace std;

std::string GRAPH_S;
std::string GRAPH_NAME;
std::string GRAPH_FILE_T;
std::string GRAPH_FILE_R;

////////////////////////////////////////////////////////////

TradListGraphR* rep_original_t = NULL;
MetisR* rep_original_m = NULL;
SimpleRecGraphR* rep_bisected_r = NULL;

DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_N_bvRRR;
DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>* dif_N_bvSD;
DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>* dif_N_bvIL;
DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>* dif_N_bv;
DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_N_ptr64;
DiffGraphR<OffsetsPtrsLogn, MyVarintByteBasedCoder>* dif_N_ptrLogn;

DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_I_bvRRR;
DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>* dif_I_bvSD;
DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>* dif_I_bvIL;
DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>* dif_I_bv;
DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_I_ptr64;
DiffGraphR<OffsetsPtrsLogn, MyVarintByteBasedCoder>* dif_I_ptrLogn;

bool hack = true;

int main (int argc, char *argv[]) {
  GRAPH_S = argv[1];
  GRAPH_NAME = argv[2];
  GRAPH_FILE_T = argv[3];
  GRAPH_FILE_R = argv[4];

    string dir = argv[5];
      string file = argv[6];

  assert(argc == 7);

  if(GRAPH_FILE_T == "" || GRAPH_FILE_R == "") {
    return EXIT_FAILURE;
  }

  GraphIO::loadGraph(GRAPH_FILE_T.c_str(), &rep_original_t, &rep_original_m);
  rep_bisected_r = GraphIO::readRecursivePartitioningFromFile(GRAPH_FILE_R);

  dif_N_bvRRR   = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  dif_N_bvSD    = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  dif_N_bvIL    = new DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  dif_N_bv    = new DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  dif_N_ptr64   = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  dif_N_ptrLogn = new DiffGraphR<OffsetsPtrsLogn, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);

  dif_I_bvRRR   = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_I_bvSD    = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_I_bvIL    = new DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_I_bv    = new DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_I_ptr64   = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);
  dif_I_ptrLogn = new DiffGraphR<OffsetsPtrsLogn, MyVarintByteBasedCoder>(INORDER, rep_bisected_r, rep_original_t);

  double dif_N_bvRRR_ADJ_SIZE = dif_N_bvRRR->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_bvRRR_OFFSETS_SIZE = dif_N_bvRRR->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_bvRRR_TOTAL_SIZE = dif_N_bvRRR_ADJ_SIZE + dif_N_bvRRR_OFFSETS_SIZE;

  double dif_N_bvSD_ADJ_SIZE = dif_N_bvSD->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_bvSD_OFFSETS_SIZE = dif_N_bvSD->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_bvSD_TOTAL_SIZE = dif_N_bvSD_ADJ_SIZE + dif_N_bvSD_OFFSETS_SIZE;

  double dif_N_bvIL_ADJ_SIZE = dif_N_bvIL->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_bvIL_OFFSETS_SIZE = dif_N_bvIL->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_bvIL_TOTAL_SIZE = dif_N_bvIL_ADJ_SIZE + dif_N_bvIL_OFFSETS_SIZE;

  double dif_N_bv_ADJ_SIZE = dif_N_bv->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_bv_OFFSETS_SIZE = dif_N_bv->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_bv_TOTAL_SIZE = dif_N_bv_ADJ_SIZE + dif_N_bv_OFFSETS_SIZE;

  double dif_N_ptr64_ADJ_SIZE = dif_N_ptr64->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_ptr64_OFFSETS_SIZE = dif_N_ptr64->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_ptr64_TOTAL_SIZE = dif_N_ptr64_ADJ_SIZE + dif_N_ptr64_OFFSETS_SIZE;

  double dif_N_ptrLogn_ADJ_SIZE = dif_N_ptrLogn->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_ptrLogn_OFFSETS_SIZE = dif_N_ptrLogn->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_N_ptrLogn_TOTAL_SIZE = dif_N_ptrLogn_ADJ_SIZE + dif_N_ptrLogn_OFFSETS_SIZE;


  double dif_I_bvRRR_ADJ_SIZE = dif_I_bvRRR->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_bvRRR_OFFSETS_SIZE = dif_I_bvRRR->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_bvRRR_TOTAL_SIZE = dif_I_bvRRR_ADJ_SIZE + dif_I_bvRRR_OFFSETS_SIZE;

  double dif_I_bvSD_ADJ_SIZE = dif_I_bvSD->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_bvSD_OFFSETS_SIZE = dif_I_bvSD->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_bvSD_TOTAL_SIZE = dif_I_bvSD_ADJ_SIZE + dif_I_bvSD_OFFSETS_SIZE;

  double dif_I_bvIL_ADJ_SIZE = dif_I_bvIL->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_bvIL_OFFSETS_SIZE = dif_I_bvIL->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_bvIL_TOTAL_SIZE = dif_I_bvIL_ADJ_SIZE + dif_I_bvIL_OFFSETS_SIZE;

  double dif_I_bv_ADJ_SIZE = dif_I_bv->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_bv_OFFSETS_SIZE = dif_I_bv->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_bv_TOTAL_SIZE = dif_I_bv_ADJ_SIZE + dif_I_bv_OFFSETS_SIZE;

  double dif_I_ptr64_ADJ_SIZE = dif_I_ptr64->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_ptr64_OFFSETS_SIZE = dif_I_ptr64->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_ptr64_TOTAL_SIZE = dif_I_ptr64_ADJ_SIZE + dif_I_ptr64_OFFSETS_SIZE;

  double dif_I_ptrLogn_ADJ_SIZE = dif_I_ptrLogn->adj_data_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_ptrLogn_OFFSETS_SIZE = dif_I_ptrLogn->offsets_total_size_in_bytes()/(1.0*1024*1024);
  double dif_I_ptrLogn_TOTAL_SIZE = dif_I_ptrLogn_ADJ_SIZE + dif_I_ptrLogn_OFFSETS_SIZE;

  ofstream f_cat;
  f_cat.open(dir + "/" + file, ios::app);

  f_cat << GRAPH_S << " trad ptr64 adj " << dif_N_ptr64_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad ptr64 off " << dif_N_ptr64_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad ptr64 tot " << dif_N_ptr64_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad ptrLogn adj " << dif_N_ptrLogn_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad ptrLogn off " << dif_N_ptrLogn_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad ptrLogn tot " << dif_N_ptrLogn_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad bvUN adj " << dif_N_bv_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad bvUN off " << dif_N_bv_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad bvUN tot " << dif_N_bv_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad bvIL adj " << dif_N_bvIL_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad bvIL off " << dif_N_bvIL_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad bvIL tot " << dif_N_bvIL_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad bvRRR adj " << dif_N_bvRRR_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad bvRRR off " << dif_N_bvRRR_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad bvRRR tot " << dif_N_bvRRR_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad bvSD adj " << dif_N_bvSD_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad bvSD off " << dif_N_bvSD_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad bvSD tot " << dif_N_bvSD_TOTAL_SIZE << endl;

  f_cat << GRAPH_S << " inorder ptr64 adj " << dif_I_ptr64_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptr64 off " << dif_I_ptr64_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptr64 tot " << dif_I_ptr64_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptrLogn adj " << dif_I_ptrLogn_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptrLogn off " << dif_I_ptrLogn_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptrLogn tot " << dif_I_ptrLogn_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvUN adj " << dif_I_bv_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvUN off " << dif_I_bv_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvUN tot " << dif_I_bv_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvIL adj " << dif_I_bvIL_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvIL off " << dif_I_bvIL_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvIL tot " << dif_I_bvIL_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvRRR adj " << dif_I_bvRRR_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvRRR off " << dif_I_bvRRR_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvRRR tot " << dif_I_bvRRR_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvSD adj " << dif_I_bvSD_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvSD off " << dif_I_bvSD_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvSD tot " << dif_I_bvSD_TOTAL_SIZE << endl;

   f_cat.close();


   dif_N_bvRRR_ADJ_SIZE /= dif_N_ptr64_ADJ_SIZE;
   dif_N_bvRRR_OFFSETS_SIZE /= dif_N_ptr64_OFFSETS_SIZE;
   dif_N_bvRRR_TOTAL_SIZE /= dif_N_ptr64_TOTAL_SIZE;

   dif_N_bvSD_ADJ_SIZE /= dif_N_ptr64_ADJ_SIZE;
   dif_N_bvSD_OFFSETS_SIZE /= dif_N_ptr64_OFFSETS_SIZE;
   dif_N_bvSD_TOTAL_SIZE /= dif_N_ptr64_TOTAL_SIZE;

   dif_N_bvIL_ADJ_SIZE /= dif_N_ptr64_ADJ_SIZE;
   dif_N_bvIL_OFFSETS_SIZE /= dif_N_ptr64_OFFSETS_SIZE;
   dif_N_bvIL_TOTAL_SIZE /= dif_N_ptr64_TOTAL_SIZE;

   dif_N_bv_ADJ_SIZE /= dif_N_ptr64_ADJ_SIZE;
   dif_N_bv_OFFSETS_SIZE /= dif_N_ptr64_OFFSETS_SIZE;
   dif_N_bv_TOTAL_SIZE /= dif_N_ptr64_TOTAL_SIZE;

   dif_N_ptrLogn_ADJ_SIZE /= dif_N_ptr64_ADJ_SIZE;
   dif_N_ptrLogn_OFFSETS_SIZE /= dif_N_ptr64_OFFSETS_SIZE;
   dif_N_ptrLogn_TOTAL_SIZE /= dif_N_ptr64_TOTAL_SIZE;

   dif_N_ptr64_ADJ_SIZE /= dif_N_ptr64_ADJ_SIZE;
   dif_N_ptr64_OFFSETS_SIZE /= dif_N_ptr64_OFFSETS_SIZE;
   dif_N_ptr64_TOTAL_SIZE /= dif_N_ptr64_TOTAL_SIZE;


   dif_I_bvRRR_ADJ_SIZE /= dif_I_ptr64_ADJ_SIZE;
   dif_I_bvRRR_OFFSETS_SIZE /= dif_I_ptr64_OFFSETS_SIZE;
   dif_I_bvRRR_TOTAL_SIZE /= dif_I_ptr64_TOTAL_SIZE;

   dif_I_bvSD_ADJ_SIZE /= dif_I_ptr64_ADJ_SIZE;
   dif_I_bvSD_OFFSETS_SIZE /= dif_I_ptr64_OFFSETS_SIZE;
   dif_I_bvSD_TOTAL_SIZE /= dif_I_ptr64_TOTAL_SIZE;

   dif_I_bvIL_ADJ_SIZE /= dif_I_ptr64_ADJ_SIZE;
   dif_I_bvIL_OFFSETS_SIZE /= dif_I_ptr64_OFFSETS_SIZE;
   dif_I_bvIL_TOTAL_SIZE /= dif_I_ptr64_TOTAL_SIZE;

   dif_I_bv_ADJ_SIZE /= dif_I_ptr64_ADJ_SIZE;
   dif_I_bv_OFFSETS_SIZE /= dif_I_ptr64_OFFSETS_SIZE;
   dif_I_bv_TOTAL_SIZE /= dif_I_ptr64_TOTAL_SIZE;

   dif_I_ptrLogn_ADJ_SIZE /= dif_I_ptr64_ADJ_SIZE;
   dif_I_ptrLogn_OFFSETS_SIZE /= dif_I_ptr64_OFFSETS_SIZE;
   dif_I_ptrLogn_TOTAL_SIZE /= dif_I_ptr64_TOTAL_SIZE;

   dif_I_ptr64_ADJ_SIZE /= dif_I_ptr64_ADJ_SIZE;
   dif_I_ptr64_OFFSETS_SIZE /= dif_I_ptr64_OFFSETS_SIZE;
   dif_I_ptr64_TOTAL_SIZE /= dif_I_ptr64_TOTAL_SIZE;



 // ofstream f_cat;
  f_cat.open(dir + "/" + file + ".norm", ios::app);

  f_cat << GRAPH_S << " trad ptr64 adj " << dif_N_ptr64_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad ptr64 off " << dif_N_ptr64_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad ptr64 tot " << dif_N_ptr64_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad ptrLogn adj " << dif_N_ptrLogn_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad ptrLogn off " << dif_N_ptrLogn_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad ptrLogn tot " << dif_N_ptrLogn_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad bvUN adj " << dif_N_bv_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad bvUN off " << dif_N_bv_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad bvUN tot " << dif_N_bv_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad bvIL adj " << dif_N_bvIL_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad bvIL off " << dif_N_bvIL_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad bvIL tot " << dif_N_bvIL_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad bvRRR adj " << dif_N_bvRRR_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad bvRRR off " << dif_N_bvRRR_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad bvRRR tot " << dif_N_bvRRR_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " trad bvSD adj " << dif_N_bvSD_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " trad bvSD off " << dif_N_bvSD_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " trad bvSD tot " << dif_N_bvSD_TOTAL_SIZE << endl;

  f_cat << GRAPH_S << " inorder ptr64 adj " << dif_I_ptr64_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptr64 off " << dif_I_ptr64_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptr64 tot " << dif_I_ptr64_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptrLogn adj " << dif_I_ptrLogn_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptrLogn off " << dif_I_ptrLogn_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder ptrLogn tot " << dif_I_ptrLogn_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvUN adj " << dif_I_bv_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvUN off " << dif_I_bv_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvUN tot " << dif_I_bv_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvIL adj " << dif_I_bvIL_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvIL off " << dif_I_bvIL_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvIL tot " << dif_I_bvIL_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvRRR adj " << dif_I_bvRRR_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvRRR off " << dif_I_bvRRR_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvRRR tot " << dif_I_bvRRR_TOTAL_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvSD adj " << dif_I_bvSD_ADJ_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvSD off " << dif_I_bvSD_OFFSETS_SIZE << endl;
  f_cat << GRAPH_S << " inorder bvSD tot " << dif_I_bvSD_TOTAL_SIZE << endl;

   f_cat.close();


  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  delete rep_bisected_r;
  delete rep_original_t;
  delete rep_original_m;
  
  delete dif_N_bvRRR;
  delete dif_N_bvSD;
  delete dif_N_bvIL;
  delete dif_N_bv;
  delete dif_N_ptr64;
  delete dif_N_ptrLogn;

  delete dif_I_bvRRR;
  delete dif_I_bvSD;
  delete dif_I_bvIL;
  delete dif_I_bv;
  delete dif_I_ptr64;
  delete dif_I_ptrLogn;

  return EXIT_SUCCESS;
}
