#include <cinttypes>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <pthread.h>
//#include <mpi.h>
#include <cassert>
#include <chrono>
#include <iostream>

#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "partitioners/recPart.h"
#include "representations/diffGraphR.h"

std::string GRAPH_S;
std::string GRAPH_NAME;

////////////////////////////////////////////////////////////

TradListGraphR* loaded_g_t = NULL;
MetisR* loaded_g_m = NULL;

int main (int argc, char *argv[]) {
  assert(argc == 8);

  GRAPH_S = argv[1];
  GRAPH_NAME = argv[2];

  int balance = atoi(argv[3]);
  int full = atoi(argv[4]);
  int lvls = atoi(argv[5]);
  char* file_name = argv[6];
  std::string out_f = argv[7];

  std::cout << "Panie, prosze, pomoz (1)" << std::endl;

  GraphIO::loadGraph(file_name, &loaded_g_t, &loaded_g_m);

  std::cout << "Panie, prosze, pomoz (2)" << std::endl;
  RecPart part;
  SimpleRecGraphR* r = NULL;
  CutResults* res = NULL;

  std::cout << "Panie, prosze, pomoz (3)" << std::endl;
  part.recEdgePartition(METIS_PARTITIONING_MULTITHREADED, loaded_g_m, balance, full, lvls, &r, &res);
  std::cout << "Panie, prosze, pomoz (4)" << std::endl;

  GraphIO::writeRecursivePartitioningToFile(r, out_f);

  for(auto& item: *r) {
    string* result = item.second;
    delete result;
  }

  for(auto& item: *res) {
    delete item.second;
  }

  delete r;
  delete res;

  delete loaded_g_t;
  delete loaded_g_m;

  //MPI_Finalize();
  return EXIT_SUCCESS;
}
