#include <cinttypes>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <pthread.h>
//#include <mpi.h>
#include <cassert>
#include <chrono>
#include <iostream>

#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "utils/diffAnalysis.h"
#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "partitioners/recPart.h"
#include "representations/diffGraphR.h"

using namespace std;

std::string GRAPH_S;
std::string GRAPH_NAME;
std::string GRAPH_FILE_T;
std::string GRAPH_FILE_R;

////////////////////////////////////////////////////////////

TradListGraphR* rep_original_t = NULL;
TradListGraphR* rep_original_blelloch_inorder_t = NULL;
TradListGraphR* rep_original_degree_t = NULL;
TradListGraphR* rep_bisected_t = NULL;

MetisR* rep_original_m = NULL;

SimpleRecGraphR* rep_bisected_r = NULL;

int main (int argc, char *argv[]) {
  GRAPH_S = argv[1];
  GRAPH_NAME = argv[2];
  GRAPH_FILE_T = argv[3];
  GRAPH_FILE_R = argv[4];

  //cout << argc << endl;
  //cout << GRAPH_S << endl;
  //cout << GRAPH_NAME << endl;
  //cout << GRAPH_FILE_T << endl;
  //cout << GRAPH_FILE_R << endl;
  assert(argc == 5);

  if(GRAPH_FILE_T == "" || GRAPH_FILE_R == "") {
    return EXIT_FAILURE;
  }

  RecPermuter* p = new RecPermuter();

  cerr << ">>> Loading original adjacency list from file." << endl;
  GraphIO::loadGraph(GRAPH_FILE_T.c_str(), &rep_original_t, &rep_original_m);

  cerr << ">>> Loading bisected representation from file." << endl;
  rep_bisected_r = GraphIO::readRecursivePartitioningFromFile(GRAPH_FILE_R);
  cerr << "  > Verifying..." << endl;
  verifySimpleRecGraphR(rep_bisected_r);

  cerr << ">>> Loading (permuting-INORDER) from original representation." << endl;
  rep_original_blelloch_inorder_t = p->permute(rep_bisected_r, rep_original_t, INORDER);
  cerr << "  > Verifying..." << endl;
  verifyTradListGraphR(rep_original_blelloch_inorder_t);
  
  cerr << ">>> Loading (permuting-DEGREE) from original representation." << endl;
  rep_original_degree_t = p->permute(rep_bisected_r, rep_original_t, DEGREE_HIGH_TO_LOW);
  cerr << "  > Verifying..." << endl;
  verifyTradListGraphR(rep_original_degree_t);

  cerr << "Loading (converting) an adjacency list from recursive representation." << endl;
  rep_bisected_t = convertSimpleRecToTradList(rep_bisected_r, rep_original_t);
  cerr << "  > Verifying..." << endl;
  verifyTradListGraphR(rep_bisected_t);

  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  delete rep_bisected_r;

  delete rep_original_t;
  delete rep_original_blelloch_inorder_t;
  delete rep_original_degree_t;
  delete rep_bisected_t;

  delete rep_original_m;
  
  return EXIT_SUCCESS;
}
