#include "myVarintByteBasedHybridOpt1ReducedCoder.h"

MyVarintByteBasedHybridOpt1ReducedCoder::MyVarintByteBasedHybridOpt1ReducedCoder() {}

MyVarintByteBasedHybridOpt1ReducedCoder::~MyVarintByteBasedHybridOpt1ReducedCoder() {
  delete [] adj_data_;
  delete adj_data_size_info_;
}

void MyVarintByteBasedHybridOpt1ReducedCoder::encode(const TradListGraphR* t, SimpleRecGraphR* r, int64_t** offsets_out) {
  TradAdj<v_id>* n_adj = t->adj_;
  n_ = t->n_;
  m_ = t->m_;
  prefix_len_ = (*r)[0]->length();

  //cout << "Encoding..." << endl;

  uint64_t itr = 0;
  uint64_t unused_bits = 0;
  uint64_t unused_bits_neighbors = 0;
  uint64_t unused_bits_signs = 0;
  uint64_t unused_bits_edges = 0;
  int64_t* offsets = new int64_t[n_]();
  uint64_t new_adj_data_size_in_bytes = m_*4*sizeof(uint64_t); //TODO: check for a better size
  unsigned char* new_adj_data = new unsigned char[new_adj_data_size_in_bytes]();

  for(const auto& item : *n_adj) {
    v_id v = item.first;
    string* v_rec = (*r)[v];
    v_id v_deg = item.second.size();
    offsets[v] = itr;

    //cout << ">>>>>>>>>>>>>>>> v: " << v << ", rec rep: " << *v_rec << ", deg: " << v_deg << ", offset: " << itr << endl;


    //cout << "Deg encoded, itr: " << itr << endl;

    // TODO: make vectors pointers? Just in case of a stack overflow.
    map<v_id, vector<v_id> >* prefixes_lengths = new map<v_id, vector<v_id> >();

    for(int i = 0; i <= prefix_len_; ++i) {
            (*prefixes_lengths)[i] = vector<v_id>();
                  assert((*prefixes_lengths)[i].size() == 0);
                      }

    vector<v_id> sorted_long_neighbors;
    int __N_L = 4;


    for(const auto& n: item.second) {
      string* n_rec = (*r)[n];
      string prefix = commonPrefix(v_rec, n_rec);
      int  prefix_len = prefix.size();
      ////cout << "prefix_len: " << prefix_len << endl;
      (*prefixes_lengths)[prefix_len].push_back(n);
      //cout << ">>> neighbor: " << n << ", rec rep: " << *n_rec << ", common prefix len: " << prefix_len << endl;


      int neighbor_len = prefix_len_ - prefix_len;
      if(neighbor_len > __N_L) {
        sorted_long_neighbors.push_back(n);
      }
    }

   sort(sorted_long_neighbors.begin(), sorted_long_neighbors.end()); 

    int l_n_nr = sorted_long_neighbors.size();
    //cout << "Prefixes analyzed, proceeding to actual ending..." << endl;


    // first, encode the number of neighbors
    itr += toVarint(l_n_nr, &new_adj_data[itr], &unused_bits);
    unused_bits_neighbors += unused_bits;


        v_id v1 = v;
        //uint64_t v1_deg = v_deg;

        //cerr << ">>>>>>>>>>>>>>>> v: " << v1 << ", deg: " << v1_deg << ", OFFSET: " << itr << endl;

        // first, encode the number of neighbors
        //cerr << ">>>>>>>>> Encoding the degree." << endl;
        //int next = toVarint(v1_deg, &new_adj_data[itr], &unused_bits);
        //itr += next;
        //cerr << ">>> Increasing itr by " << next << " bytes (encoded value " << v1_deg << "), OFFSET: " << itr << endl;

        //unused_bits_neighbors += unused_bits;

        //cerr << ">>>>>>>>> Encoding neighbors." << endl;

        uint64_t prev_v = v1;
        bool first_neigh = true;
        for(const auto& v2: sorted_long_neighbors) {
          uint64_t diff;
          if(first_neigh) { //TODO: remove some casting
            if((uint64_t)v2 < prev_v) {
              new_adj_data[itr] = NEXT_VAL_SMALLER;
              diff = prev_v-v2;
            }
            else {
              new_adj_data[itr] = NEXT_VAL_GREATER;
              diff = v2-prev_v;
            }
            unused_bits_signs += 7;
            ++itr;
            //cerr << ">>> Sign encoded, OFFSET: " << itr << endl;

            int next = toVarint(diff, &new_adj_data[itr], &unused_bits);
            unused_bits_edges += unused_bits;

            itr += next;
            //cerr << ">>> A neighbor encoded, bytes: " << next << ", OFFSET: " << itr << endl;

            first_neigh = false;
            prev_v = v2;
            continue;
          }

          diff = v2 - prev_v;

          if(diff <= 0) {
            //cerr << "v: " << v1 << ", neigh: " << v2 << ", prev neigh: " << prev_v << endl;
          }

          assert(diff > 0);

          int next = toVarint(diff, &new_adj_data[itr], &unused_bits);
          unused_bits_edges += unused_bits;

          itr += next;

          //cerr << ">>> A neighbor encoded, bytes: " << next << ", OFFSET: " << itr << endl;

          prev_v = v2;
        }








        int bit_nr = 7;
    v_id __neighbors = 0;
    for(const auto& item: *prefixes_lengths) {
      int prefix_len = item.first;
      int neighbor_len = prefix_len_ - prefix_len;
      //int64_t bits_added = 0;   // for HACK
      /*if(neighbor_len > 0) {
        v_id v1 = v;
        uint64_t v1_deg = v_deg;

        //cerr << ">>>>>>>>>>>>>>>> v: " << v1 << ", deg: " << v1_deg << ", OFFSET: " << itr << endl;

        // first, encode the number of neighbors
        //cerr << ">>>>>>>>> Encoding the degree." << endl;
        //int next = toVarint(v1_deg, &new_adj_data[itr], &unused_bits);
        //itr += next;
        //cerr << ">>> Increasing itr by " << next << " bytes (encoded value " << v1_deg << "), OFFSET: " << itr << endl;

        //unused_bits_neighbors += unused_bits;

        //cerr << ">>>>>>>>> Encoding neighbors." << endl;

        uint64_t prev_v = v1;
        bool first_neigh = true;
        for(const auto& v2: item.second) {
          uint64_t diff;
          if(first_neigh) { //TODO: remove some casting
            if((uint64_t)v2 < prev_v) {
              new_adj_data[itr] = NEXT_VAL_SMALLER;
              diff = prev_v-v2;
            }
            else {
              new_adj_data[itr] = NEXT_VAL_GREATER;
              diff = v2-prev_v;
            }
            unused_bits_signs += 7;
            ++itr;
            //cerr << ">>> Sign encoded, OFFSET: " << itr << endl;

            int next = toVarint(diff, &new_adj_data[itr], &unused_bits);
            unused_bits_edges += unused_bits;

            itr += next;
            //cerr << ">>> A neighbor encoded, bytes: " << next << ", OFFSET: " << itr << endl;

            first_neigh = false;
            prev_v = v2;
            continue;
          }

          diff = v2 - prev_v;

          if(diff <= 0) {
            //cerr << "v: " << v1 << ", neigh: " << v2 << ", prev neigh: " << prev_v << endl;
          }

          assert(diff > 0);

          int next = toVarint(diff, &new_adj_data[itr], &unused_bits);
          unused_bits_edges += unused_bits;

          itr += next;

          //cerr << ">>> A neighbor encoded, bytes: " << next << ", OFFSET: " << itr << endl;

          prev_v = v2;
        }
      }
      else if(neighbor_len <= 0) { */
      if(neighbor_len <= __N_L) {

        //int prefix_len = item.first;
        vector<v_id> neighbors = item.second;
        //assert(neighbors.size() > 0);

        if(neighbors.size() == 0) {
          int bit_val = 0; 
          if(bit_val == 0) {
            new_adj_data[itr] &= ~(1 << bit_nr);
          }
          else if(bit_val == 1) {
            new_adj_data[itr] |= 1 << bit_nr;
          }
          else {
            assert(false);
          }
          // *itr ^= (-bit_val ^ *itr) & (1 << bit_nr);
          --bit_nr;
          if(bit_nr == -1) {
            //if(bit_nr == BITS_IN_BYTE) 
            ++itr;
            bit_nr = 7;
          }
       
        

          continue;
        }





        string prefix = (*r)[neighbors[0]]->substr(0, prefix_len);

        // Encode the length of the prefix [bits]
        assert(prefix_len <= MAX_RECURSIVE_PREFIX_LEN);

        /////new_adj_data[itr++] = (unsigned char)(prefix_len);
        
        
        
        // TODO: verify log
        int prefix_len_bits = (int)( ceil(log2(prefix_len)) );
        if(prefix_len == 0) {
          prefix_len_bits = 0;
        }
        else if(prefix_len == 1) {
          prefix_len_bits = 1;
        }
        //cout << ">>> prefix: " << prefix << ", prefix len: " << prefix_len << ", prefix len bits: " << prefix_len_bits << endl;
        //bits_added += prefix_len_bits;
       //cout << "Prefix: " << prefix << ", bits: " << prefix_len << endl; 
        string __pr_len = decToBin(prefix_len, prefix_len);
        string __n_nr = decToBin(neighbors.size(), neighbor_len);

        int add_bits = BITS_IN_BYTE - prefix_len_bits;
        unused_bits_edges += add_bits;
        assert(add_bits >= 0 && add_bits <= BITS_IN_BYTE);

        // Encode the number of neighbors with this prefix

        //bits_added += neighbor_len;
        if(neighbor_len == 1) {
          assert(neighbors.size() <= 1);
        }
        else if(neighbor_len == 2) {
          assert(neighbors.size() <= 4);
        }

        //itr += toVarint(neighbors.size(), &new_adj_data[itr], &unused_bits);
        //unused_bits_edges += unused_bits;

        //cout << ">>> Nr of neighbors with this prefix [len]: " << neighbors.size() << endl;


        //uint64_t* curr_addr = (uint64_t*)(&new_adj_data[itr]);
        /*for(char bit : __pr_len) {
          int bit_val = bit - '0';
          if(bit_val == 0) {
            new_adj_data[itr] &= ~(1 << bit_nr);
          }
          else if(bit_val == 1) {
            new_adj_data[itr] |= 1 << bit_nr;
          }
          else {
            assert(false);
          }
          // *itr ^= (-bit_val ^ *itr) & (1 << bit_nr);
          --bit_nr;
          if(bit_nr == -1) {
            //if(bit_nr == BITS_IN_BYTE) 
            ++itr;
            bit_nr = 7;
          }
        }*/


        for(char bit : __n_nr) {
          int bit_val = bit - '0';
          if(bit_val == 0) {
            new_adj_data[itr] &= ~(1 << bit_nr);
          }
          else if(bit_val == 1) {
            new_adj_data[itr] |= 1 << bit_nr;
          }
          else {
            assert(false);
          }
          // *itr ^= (-bit_val ^ *itr) & (1 << bit_nr);
          --bit_nr;
          if(bit_nr == -1) {
            //if(bit_nr == BITS_IN_BYTE) 
            ++itr;
            bit_nr = 7;
          }
        }




        // Encode the prefix
        //int bit_nr = 7;
        //uint64_t* curr_addr = (uint64_t*)(&new_adj_data[itr]);
        for(char bit : prefix) {
          int bit_val = bit - '0';
          if(bit_val == 0) {
            new_adj_data[itr] &= ~(1 << bit_nr);
          }
          else if(bit_val == 1) {
            new_adj_data[itr] |= 1 << bit_nr;
          }
          else {
            assert(false);
          }
          // *itr ^= (-bit_val ^ *itr) & (1 << bit_nr);
          --bit_nr;
          if(bit_nr == -1) {
            //if(bit_nr == BITS_IN_BYTE) 
            ++itr;
            bit_nr = 7;
          }
        }

        // Encode the neighbors
        for(const auto& n: neighbors) {
          string n_rec = *((*r)[n]);
          //cout << "+++ Encoding neighbor " << n << " (" << n_rec;
          n_rec.erase(0, prefix.size());
          //cout << "), without prefix: " << n_rec << endl;


          //cout << "Encoding (L: " << neighbor_len << ") " << n_rec << endl;

          for(char bit : n_rec) {
            int bit_val = bit - '0';
            if(bit_val == 0) {
              new_adj_data[itr] &= ~(1 << bit_nr);
            }
            else if(bit_val == 1) {
              new_adj_data[itr] |= 1 << bit_nr;
            }
            else {
              assert(false);
            }
            //*itr ^= (-bit_val ^ *itr) & (1 << bit_nr);
            --bit_nr;
            if(bit_nr == -1) {
              ++itr;
              bit_nr = 7;
            }
          }
          __neighbors++;
        }


        // HACK !!!!!!!!!!!

        //itr += (double)bits_added / 8.0;

        // end of HACK !!!!!!!!!!


        /*if(bit_nr != 7) {
          ++itr;
          //unused_bits_edges += (BITS_IN_BYTE - bit_nr); 
          unused_bits_edges += bit_nr; 
        }*/
      }
    }

    delete prefixes_lengths;
  }

  // TODO: make it always work. Now it may actually fail, if
  // we don't use enough space a priori
  assert(new_adj_data_size_in_bytes > itr);

  adj_data_size_info_ = new AdjDataSizeInfo();
  adj_data_size_info_->adj_data_total_size_in_bytes_ = itr;
  adj_data_size_info_->adj_data_total_redundancy_in_bytes_ = ceil((unused_bits_edges + unused_bits_signs + unused_bits_neighbors) / 8.0);
  adj_data_size_info_->adj_data_edges_redundancy_in_bytes_ = ceil(unused_bits_edges / 8.0);
  adj_data_size_info_->adj_data_signs_redundancy_in_bytes_ = ceil(unused_bits_signs / 8.0);
  adj_data_size_info_->adj_data_neighbors_redundancy_in_bytes_ = ceil(unused_bits_neighbors / 8.0);

  adj_data_ = new unsigned char[itr]();
  memcpy(&adj_data_[0], &new_adj_data[0], itr);
  delete [] new_adj_data;
  *offsets_out = offsets;

  /*cout << ";;;;; START outputting " << endl;

    v_id u = 0;
    for(const auto& item : *n_adj) {
    v_id v = item.first;
    string* v_rec = (*r)[v];
    v_id v_deg = item.second.size();

    cout << "********** v: " << v << ", rec rep: " << *v_rec << ", deg: " << v_deg << ", offset: " << offsets[v] << endl;
    cout << "Neighbors: ";

    for(const auto& neigh: item.second) {
    cout << *(*r)[neigh] << " ";
    }
    cout << endl;

    if(u < (n_adj->size()-1)) {
    int byte_len = offsets[v+1] - offsets[v];

    for(int i = 0; i < byte_len; ++i) {
    bitset<8> x(adj_data_[offsets[v]+i]);
    cout << x << "|";
    }
    cout << endl;
    }
    ++u;
    }*/
}

/* TODO
   void MyVarintByteBasedHybridOpt1ReducedCoder::encode(const MetisR* n_adj, int64_t** offsets_out) {
   n_ = n_adj->n_;
   m_ = n_adj->m_;
   idx_t* n_xadj = n_adj->xadj_;
   idx_t* n_adjncy = n_adj->adjncy_;
   int64_t itr = 0;
   uint64_t unused_bits = 0;
   uint64_t unused_bits_neighbors = 0;
   uint64_t unused_bits_signs = 0;
   uint64_t unused_bits_edges = 0;
   int64_t* offsets = new int64_t[n_]();
   uint64_t new_adj_data_size_in_bytes = m_*4*sizeof(uint64_t); //TODO: check for a better size
   uint64_t* new_adj_data = new uint64_t[new_adj_data_size_in_bytes]();

   for(idx_t v1 = 0; v1 < n_adj->n_; ++v1) {
   offsets[v1] = itr;
   uint64_t nS = n_xadj[v1+1] - n_xadj[v1];
   assert(nS < TWO_POW_42);  // TODO: make it more generic

// first, encode the number of neighbors
int next = toVarint(nS, &(((unsigned char*)(new_adj_data))[itr]), &unused_bits);
itr += next;
unused_bits_neighbors += unused_bits;

uint64_t prev_v = v1;
bool first_neigh = true;
for(idx_t k = n_xadj[v1]; k < n_xadj[v1+1]; ++k) {
idx_t v2 = n_adjncy[k];
uint64_t diff;
if(first_neigh) { //TODO: remove some casting
if((uint64_t)v2 < prev_v) {
new_adj_data[itr] = NEXT_VAL_SMALLER;
diff = prev_v-v2;
}
else {
new_adj_data[itr] = NEXT_VAL_GREATER;
diff = v2-prev_v;
}
unused_bits_signs += 7;
++itr;

next = toVarint(diff, &(((unsigned char*)(new_adj_data))[itr]), &unused_bits);
itr += next;
unused_bits_edges += unused_bits;

first_neigh = false;
prev_v = v2;
continue;
}

diff = v2 - prev_v;
assert(diff > 0);

next = toVarint(diff, &(((unsigned char*)(new_adj_data))[itr]), &unused_bits);
itr += next;
unused_bits_edges += unused_bits;

prev_v = v2;
}
}

// TODO: make it always work. Now it may actually fail, if
// we don't use enough space a priori
assert(new_adj_data_size_in_bytes > itr);

adj_data_size_info_ = new AdjDataSizeInfo();
adj_data_size_info_->adj_data_total_size_in_bytes_ = itr;
adj_data_size_info_->adj_data_total_redundancy_in_bytes_ = ceil((unused_bits_edges + unused_bits_signs + unused_bits_neighbors) / 8.0);
adj_data_size_info_->adj_data_edges_redundancy_in_bytes_ = ceil(unused_bits_edges / 8.0);
adj_data_size_info_->adj_data_signs_redundancy_in_bytes_ = ceil(unused_bits_signs / 8.0);
adj_data_size_info_->adj_data_neighbors_redundancy_in_bytes_ = ceil(unused_bits_neighbors / 8.0);

adj_data_ = new unsigned char[itr]();
memcpy(&adj_data_[0], &new_adj_data[0], itr);
*offsets_out = offsets;
}

*/

/*
// TODO
void MyVarintByteBasedHybridOpt1ReducedCoder::verifyEncodingConsistency(const TradAdj<v_id>* t, const int64_t* offsets) {
unsigned char* pos = &(((unsigned char*)(adj_data_))[0]);
int64_t itr = 0;
int next = 0;

uint64_t nr_neighs = 0;
uint64_t diff = 0;
uint64_t neigh = 0;
unsigned char sign = 0;
v_id prev_v = -1;
v_id prev_neigh = -1;
bool first_neigh = true;

for(auto& item: *t) {
v_id v = item.first;
assert(prev_v + 1 == v);
vector<v_id> neighs = item.second;

assert(offsets[v] == (int64_t)itr);

next = fromVarint(pos, &nr_neighs);
//cout << "nS: ";
//for(int ii = 0; ii < next; ii++) cout << (unsigned int)(*(pos+ii)) << " ";
pos += next;
itr += next;
assert(nr_neighs <= (uint64_t)t->size()); //TODO: double check size()
assert(nr_neighs == neighs.size());

if(nr_neighs == 0) {
prev_v = v;
continue;
}

//cout << "S: " << (unsigned int)(*pos) << " ";
sign = *pos;
++pos;
++itr;
assert(sign == NEXT_VAL_SMALLER || sign == NEXT_VAL_GREATER);
first_neigh = true;

for(uint64_t i = 0; i < nr_neighs; ++i) {
next = fromVarint(pos, &diff);
//cout << "Dn: ";
//for(int ii = 0; ii < next; ii++) cout << (unsigned int)(*(pos+ii)) << " ";
pos += next;
itr += next;
if(first_neigh) {
if(sign == NEXT_VAL_SMALLER) {
neigh = v - diff;
}
else {
neigh = v + diff;
}
assert(neigh < (uint64_t)t->size());
assert(neigh == (uint64_t)neighs[i]);

first_neigh = false;
prev_neigh = neigh;
continue;
}

neigh = prev_neigh + diff;
assert(neigh < (uint64_t)t->size());
assert(neigh == (uint64_t)neighs[i]);
prev_neigh = neigh;
}

prev_v = v;
}
}

*/

string* MyVarintByteBasedHybridOpt1ReducedCoder::decodeVertexNeighborsStr(v_id v, int64_t offset) {
  __UNUSED(v);
  v_id nr_neighs = 0;
  unsigned char* pos = &adj_data_[offset];
  pos += fromVarint(pos, &nr_neighs);
  //cout << "---------------------- Decoding Neighbors Str" << endl;
  //cout << "v: " << v << ", nr_neighs decoded: " << nr_neighs << endl;
  string* neighbors = new string[nr_neighs];
  v_id analyzed_neighbors = 0;

  bool done = false;
  while(!done) {
    // Decode prefix length.
    unsigned char prefix_len = *pos;
    ++pos;

    // Decode the number of neighbors with this prefix.
    // TODO: make it also a bit string?
    v_id neighbors_prefix_nr = 0;
    pos += fromVarint(pos, &neighbors_prefix_nr);
    //cout << ">>>>>>>>>>>>>>>> Next prefix... " << endl;
    //cout << "Number of neighbors with this prefix [len]: " << neighbors_prefix_nr << endl;

    // Decode the prefix.
    string prefix;

    int bit_nr = 7;
    for(int i = 0; i < prefix_len; ++i) {
      int bit_val = (*pos >> bit_nr) & 1;
      char bit_val_char = intbitToChar(bit_val);
      assert(bit_val_char == '0' || bit_val_char == '1');
      prefix += bit_val_char;
      --bit_nr;
      if(bit_nr == -1) {
        ++pos;
        bit_nr = 7;
      }
    }
    //cout << "Decoded prefix: " << prefix << endl;

    int neighbor_suffix_len = prefix_len_ - prefix_len;
    for(int n = 0; n < neighbors_prefix_nr; ++n) {
      string neighbor_suffix;

      //int bit_nr = 0;
      for(int i = 0; i < neighbor_suffix_len; ++i) {
        int bit_val = (*pos >> bit_nr) & 1;
        char bit_val_char = intbitToChar(bit_val);
        assert(bit_val_char == '0' || bit_val_char == '1');
        neighbor_suffix += bit_val_char;
        --bit_nr;
        if(bit_nr == -1) {
          ++pos;
          bit_nr = 7;
        }
      }

      string neighbor = prefix + neighbor_suffix;
      neighbors[analyzed_neighbors++] = neighbor;
      //cout << "Neighbor nr " << analyzed_neighbors << ": " << neighbor <<  endl;
      if(analyzed_neighbors == nr_neighs) {
        done = true;
      }
    }
    if(bit_nr != 7) {
      ++pos;
    }
  }

  return neighbors;
}

v_id* MyVarintByteBasedHybridOpt1ReducedCoder::decodeVertexNeighbors(v_id v, int64_t offset) {
  string* neighbors_str = decodeVertexNeighborsStr(v, offset);
  v_id v_deg = decodeVertexDegree(v, offset);
  v_id* neighbors = new v_id[v_deg];
  for(v_id i = 0; i < v_deg; ++i) {
    neighbors[i] = binToDec(&(neighbors_str[i]));
  }
  return neighbors;
}

/*

//string* MyVarintByteBasedHybridOpt1ReducedCoder::decodeVertexNeighbors(v_id v, int64_t offset) {
v_id* MyVarintByteBasedHybridOpt1ReducedCoder::decodeVertexNeighbors(v_id v, int64_t offset) {
v_id nr_neighs = 0;
unsigned char* pos = &adj_data_[offset];
pos += fromVarint(pos, &nr_neighs);
v_id* neighbors = new v_id[nr_neighs];
//string* neighbors = new string[nr_neighs];
v_id analyzed_neighbors = 0;

bool done = false;
while(!done) {
// Decode prefix length.
unsigned char prefix_len = *pos;
++pos;

// Decode the number of neighbors with this prefix.
v_id neighbors_prefix_nr = 0;
pos += fromVarint(pos, &neighbors_prefix_nr);

// Decode the prefix.
string prefix;

int bit_nr = 0;
for(int i = 0; i < prefix_len; ++i) {
int bit_val = (*pos >> bit_nr) & 1;
char bit_val_char = intbitToChar(bit_val);
assert(bit_val_char == '0' || bit_val_char == '1');
prefix += bit_val_char;
++bit_nr;
if(bit_nr == BITS_IN_BYTE) {
++pos;
bit_nr = 0;
}
}

int neighbor_suffix_len = prefix_len_ - prefix_len;
for(int n = 0; n < neighbors_prefix_nr; ++n) {
string neighbor_suffix;

int bit_nr = 0;
for(int i = 0; i < neighbor_suffix_len; ++i) {
int bit_val = (*pos >> bit_nr) & 1;
char bit_val_char = intbitToChar(bit_val);
assert(bit_val_char == '0' || bit_val_char == '1');
neighbor_suffix += bit_val_char;
++bit_nr;
if(bit_nr == BITS_IN_BYTE) {
++pos;
bit_nr = 0;
}
}

string neighbor = prefix + neighbor_suffix;
neighbors[analyzed_neighbors++] = binToDec(&neighbor);
//neighbors[analyzed_neighbors++] = neighbor;
if(analyzed_neighbors == nr_neighs) {
done = true;
}
}
}

return neighbors;
}

 */
