#include "myVarintByteBasedNoDiffCoder.h"

MyVarintByteBasedNoDiffCoder::MyVarintByteBasedNoDiffCoder() {}

MyVarintByteBasedNoDiffCoder::~MyVarintByteBasedNoDiffCoder() {
  delete [] adj_data_;
  delete adj_data_size_info_;
}

void MyVarintByteBasedNoDiffCoder::encode(const TradListGraphR* t, int64_t** offsets_out) {
  TradAdj<v_id>* n_adj = t->adj_;
  n_ = t->n_;
  m_ = t->m_;
  uint64_t itr = 0;
  uint64_t unused_bits = 0;
  uint64_t unused_bits_neighbors = 0;
  uint64_t unused_bits_signs = 0;
  uint64_t unused_bits_edges = 0;
  int64_t* offsets = new int64_t[n_]();
  uint64_t new_adj_data_size_in_bytes = m_*4*sizeof(uint64_t); //TODO: check for a better size
  unsigned char* new_adj_data = new unsigned char[new_adj_data_size_in_bytes]();

  for(const auto& item : *n_adj) {
    v_id v1 = item.first;
    offsets[v1] = itr;
    uint64_t nS = item.second.size();

    itr += toVarint(nS, &new_adj_data[itr], &unused_bits);
    unused_bits_neighbors += unused_bits;

    for(const auto& v2: item.second) {
        itr += toVarint(v2, &new_adj_data[itr], &unused_bits);
        unused_bits_edges += unused_bits;
    }
  }

  // TODO: make it always work. Now it may actually fail, if
  // we don't use enough space a priori
  assert(new_adj_data_size_in_bytes > itr);

  adj_data_size_info_ = new AdjDataSizeInfo();
  adj_data_size_info_->adj_data_total_size_in_bytes_ = itr;
  adj_data_size_info_->adj_data_total_redundancy_in_bytes_ = ceil((unused_bits_edges + unused_bits_signs + unused_bits_neighbors) / 8.0);
  adj_data_size_info_->adj_data_edges_redundancy_in_bytes_ = ceil(unused_bits_edges / 8.0);
  adj_data_size_info_->adj_data_signs_redundancy_in_bytes_ = ceil(unused_bits_signs / 8.0);
  adj_data_size_info_->adj_data_neighbors_redundancy_in_bytes_ = ceil(unused_bits_neighbors / 8.0);

  adj_data_ = new unsigned char[itr]();
  memcpy(&adj_data_[0], &new_adj_data[0], itr);
  delete [] new_adj_data;
  *offsets_out = offsets;
}

v_id* MyVarintByteBasedNoDiffCoder::decodeVertexNeighbors(v_id v, int64_t offset) {
  __UNUSED(v);
  uint64_t nr_neighs = 0;
  unsigned char* pos = &adj_data_[offset];
  pos += fromVarint(pos, &nr_neighs);
  v_id* neighbors = new v_id[nr_neighs];

  uint64_t neigh = 0;
  for(uint64_t i = 0; i < nr_neighs; ++i) {
    pos += fromVarint(pos, &neigh);
    neighbors[i] = (v_id)neigh;
  }
  return neighbors;
}

v_id* MyVarintByteBasedNoDiffCoder::decodeVertexNeighborsAndDegree(v_id v, int64_t offset, v_id* v_deg_out) {
  __UNUSED(v);
  uint64_t nr_neighs = 0;
  unsigned char* pos = &adj_data_[offset];
  pos += fromVarint(pos, &nr_neighs);
  v_id* neighbors = new v_id[nr_neighs];
  *v_deg_out = (v_id)nr_neighs;

  uint64_t neigh = 0;
  for(uint64_t i = 0; i < nr_neighs; ++i) {
    pos += fromVarint(pos, &neigh);
    neighbors[i] = (v_id)neigh;
  }
  return neighbors;
}

