#if !defined(__MYVARINTBYTEBASEDRECOPT1CODER_H__)
#define      __MYVARINTBYTEBASEDRECOPT1CODER_H__

#include <cmath>

#include "sdsl/bit_vectors.hpp"
#include "sdsl/io.hpp"
using namespace sdsl;

#include "globals.h"
#include "utils/debug.h"
#include "utils/myVarint.h"
#include "utils/convert.h"
#include "representations/misc.h"
#include "representations/metisR.h"
#include "representations/tradListGraphR.h"
#include "coders/common.h"

class MyVarintByteBasedRecOpt1Coder {
  public:
    MyVarintByteBasedRecOpt1Coder();
    ~MyVarintByteBasedRecOpt1Coder();

    // TODO: make r const.
    void encode(const TradListGraphR* t, SimpleRecGraphR* r, int64_t** offsets_out);
    //void encode(const MetisR* m, int64_t** offsets_out);  // TODO

    inline v_id decodeVertexDegree(v_id v, int64_t offset) __attribute__((always_inline));
    inline bool decodeVertexConnectionUseV1Neighbors(v_id v1, v_id v2, int64_t v1_offset) __attribute__((always_inline));
    inline bool decodeVertexConnectionUseV2Neighbors(v_id v1, v_id v2, int64_t v2_offset) __attribute__((always_inline));
    inline bool decodeVertexConnectionUseMinNeighbors(v_id v1, v_id v2, int64_t v1_offset, int64_t v2_offset) __attribute__((always_inline));
    v_id* decodeVertexNeighbors(v_id v, int64_t offset);
    string* decodeVertexNeighborsStr(v_id v, int64_t offset);

    inline uint64_t adj_data_total_size_in_bytes();
    inline uint64_t adj_data_total_redundancy_in_bytes();
    inline uint64_t adj_data_edges_redundancy_in_bytes();
    inline uint64_t adj_data_signs_redundancy_in_bytes();
    inline uint64_t adj_data_neighbors_redundancy_in_bytes();

  private:
    unsigned char* adj_data_ = NULL;
    AdjDataSizeInfo* adj_data_size_info_ = NULL;
    v_id n_ = 0;
    v_id m_ = 0;
    int prefix_len_ = 0;

    //void verifyEncodingConsistency(const TradAdj<v_id>* t, const int64_t* offsets); // TODO
};

__attribute__((always_inline)) inline v_id MyVarintByteBasedRecOpt1Coder::decodeVertexDegree(v_id v, int64_t offset) {
  __UNUSED(v);
  v_id nr_neighs = 0;
  v_id nr_neighs_at_level = 0;
  uint64_t curr_offset = offset;
  //TODO: check if making adj_data_ a char* would be better for performnce???
  for(int i = 0; i <= prefix_len_; ++i) {
    curr_offset += fromVarint( &adj_data_[curr_offset], &nr_neighs_at_level);
    nr_neighs += nr_neighs_at_level;
  } 

  return nr_neighs;
}

// TODO: faster! no stupid allocation etc
__attribute__((always_inline)) inline bool MyVarintByteBasedRecOpt1Coder::decodeVertexConnectionUseV1Neighbors(v_id v1, v_id v2, int64_t v1_offset) {
  v_id neighS_v1_nr = decodeVertexDegree(v1, v1_offset);
  v_id* neighS_v1 = decodeVertexNeighbors(v1, v1_offset);

  for(v_id i = 0; i < neighS_v1_nr; ++i) {
    if(neighS_v1[i] == v2) {
      delete [] neighS_v1;
      return true;
    }
  }
  delete [] neighS_v1;
  return false;
}

// TODO: faster! no stupid allocation etc
__attribute__((always_inline)) inline bool MyVarintByteBasedRecOpt1Coder::decodeVertexConnectionUseV2Neighbors(v_id v1, v_id v2, int64_t v2_offset) {
  v_id neighS_v2_nr = decodeVertexDegree(v2, v2_offset);
  v_id* neighS_v2 = decodeVertexNeighbors(v2, v2_offset);

  for(v_id i = 0; i < neighS_v2_nr; ++i) {
    if(neighS_v2[i] == v1) {
      delete [] neighS_v2; 
      return true;
    }
  }
  delete [] neighS_v2;
  return false;
}

// TODO: faster! no stupid allocation etc
__attribute__((always_inline)) inline bool MyVarintByteBasedRecOpt1Coder::decodeVertexConnectionUseMinNeighbors(v_id v1, v_id v2, int64_t v1_offset, int64_t v2_offset) {
  v_id neighS_v1_nr = decodeVertexDegree(v1, v1_offset);
  v_id neighS_v2_nr = decodeVertexDegree(v2, v2_offset);

  if(neighS_v1_nr > neighS_v2_nr) {
    return decodeVertexConnectionUseV2Neighbors(v1, v2, v2_offset);
  }
  else {
    return decodeVertexConnectionUseV1Neighbors(v1, v2, v1_offset);
  }

/*
  v_id v_min = (neighS_v1_nr > neighS_v2_nr) ? v2 : v1;
  v_id v_offset_min = (neighS_v1_nr > neighS_v2_nr) ? v2_offset : v1_offset;
  v_id v_min_neighbors_nr = (neighS_v1_nr > neighS_v2_nr) ? neighS_v2_nr : neighS_v1_nr;

  v_id* neighbors = decodeVertexNeighbors(v_min, v_offset_min);

  for(v_id i = 0; i < v_min_neighbors_nr; ++i) {
    if(neighbors[i] == v_min) {
      delete [] neighbors;
      return true;
    }
  }
  delete [] neighbors;
  return false;*/
}

inline uint64_t MyVarintByteBasedRecOpt1Coder::adj_data_total_size_in_bytes() {
  return adj_data_size_info_->adj_data_total_size_in_bytes_;
}

inline uint64_t MyVarintByteBasedRecOpt1Coder::adj_data_total_redundancy_in_bytes() {
  return adj_data_size_info_->adj_data_total_redundancy_in_bytes_;
}

inline uint64_t MyVarintByteBasedRecOpt1Coder::adj_data_edges_redundancy_in_bytes() {
  return adj_data_size_info_->adj_data_edges_redundancy_in_bytes_;
}

inline uint64_t MyVarintByteBasedRecOpt1Coder::adj_data_signs_redundancy_in_bytes() {
  return adj_data_size_info_->adj_data_signs_redundancy_in_bytes_;
}

inline uint64_t MyVarintByteBasedRecOpt1Coder::adj_data_neighbors_redundancy_in_bytes() {
  return adj_data_size_info_->adj_data_neighbors_redundancy_in_bytes_;
}

#endif
