#include "myVarintWordBasedCoder.h"

MyVarintWordBasedCoder::MyVarintWordBasedCoder() {}

MyVarintWordBasedCoder::~MyVarintWordBasedCoder() {
  delete [] adj_data_;
  delete adj_data_size_info_;
}

void MyVarintWordBasedCoder::encode(const TradListGraphR* t, int64_t** offsets_out) {
  TradAdj<v_id>* n_adj = t->adj_;
  n_ = t->n_;
  m_ = t->m_;
  uint64_t itr = 0;
  uint64_t unused_bits = 0;
  uint64_t unused_bits_neighbors = 0;
  uint64_t unused_bits_signs = 0;
  uint64_t unused_bits_edges = 0;
  int64_t* offsets = new int64_t[n_]();
  uint64_t new_adj_data_size_in_bytes = m_ * 16; //TODO: check for a better size
  unsigned char* new_adj_data = new unsigned char[new_adj_data_size_in_bytes]();

  for(const auto& item : *n_adj) {
    v_id v1 = item.first;
    assert(itr % BYTES_IN_64BIT_WORD == 0);
    offsets[v1] = itr >> 3; // Offsets in 64-bit / 8-byte words
    uint64_t v1_deg = item.second.size();

    // first, encode the number of neighbors
    itr += toVarint(v1_deg, &new_adj_data[itr], &unused_bits);
    unused_bits_neighbors += unused_bits;

    uint64_t prev_v = v1;
    bool first_neigh = true;
    for(const auto& v2: item.second) {
      uint64_t diff;
      if(first_neigh) { //TODO: remove some casting
        if((uint64_t)v2 < prev_v) {
          new_adj_data[itr] = NEXT_VAL_SMALLER;
          diff = prev_v-v2;
        }
        else {
          new_adj_data[itr] = NEXT_VAL_GREATER;
          diff = v2-prev_v;
        }
        unused_bits_signs += 7;
        ++itr;

        itr += toVarint(diff, &new_adj_data[itr], &unused_bits);
        unused_bits_edges += unused_bits;

        first_neigh = false;
        prev_v = v2;
        continue;
      }

      diff = v2 - prev_v;
      assert(diff > 0);

      itr += toVarint(diff, &new_adj_data[itr], &unused_bits);
      unused_bits_edges += unused_bits;

      prev_v = v2;
    }

    // Now, make sure the offset is a multiple of a 64-bit word
    if(itr % BYTES_IN_64BIT_WORD != 0) {
      int add_bytes = ( BYTES_IN_64BIT_WORD - (itr % BYTES_IN_64BIT_WORD));
      itr += add_bytes;
      unused_bits_edges += add_bytes * BITS_IN_BYTE;
    }
    assert(itr % BYTES_IN_64BIT_WORD == 0);
  }

  // TODO: make it always work. Now it may actually fail, if we don't use enough space a priori
  assert(new_adj_data_size_in_bytes > itr);

  adj_data_size_info_ = new AdjDataSizeInfo();
  adj_data_size_info_->adj_data_total_size_in_bytes_ = itr;
  adj_data_size_info_->adj_data_total_redundancy_in_bytes_ = ceil((unused_bits_edges + unused_bits_signs + unused_bits_neighbors) / 8.0);
  adj_data_size_info_->adj_data_edges_redundancy_in_bytes_ = ceil(unused_bits_edges / 8.0);
  adj_data_size_info_->adj_data_signs_redundancy_in_bytes_ = ceil(unused_bits_signs / 8.0);
  adj_data_size_info_->adj_data_neighbors_redundancy_in_bytes_ = ceil(unused_bits_neighbors / 8.0);

  adj_data_ = new unsigned char[itr]();
  memcpy(&adj_data_[0], &new_adj_data[0], itr);
  delete [] new_adj_data;
  *offsets_out = offsets;
}

void MyVarintWordBasedCoder::verifyEncodingConsistency(const TradAdj<v_id>* t, const int64_t* offsets) {
  unsigned char* pos = &adj_data_[0];
  int64_t itr = 0;
  int next = 0;

  uint64_t nr_neighs = 0;
  uint64_t diff = 0;
  uint64_t neigh = 0;
  unsigned char sign = 0;
  v_id prev_v = -1;
  v_id prev_neigh = -1;
  bool first_neigh = true;

  for(auto& item: *t) {
    v_id v = item.first;
    assert(prev_v + 1 == v);
    vector<v_id> neighs = item.second;

    assert(offsets[v] == (int64_t)itr);

    next = fromVarint(pos, &nr_neighs);
    //cout << "nS: ";
    //for(int ii = 0; ii < next; ii++) cout << (unsigned int)(*(pos+ii)) << " ";
    pos += next;
    itr += next;
    assert(nr_neighs <= (uint64_t)t->size()); //TODO: double check size()
    assert(nr_neighs == neighs.size());

    if(nr_neighs == 0) {
      prev_v = v;
      continue;
    }

    //cout << "S: " << (unsigned int)(*pos) << " ";
    sign = *pos;
    ++pos;
    ++itr;
    assert(sign == NEXT_VAL_SMALLER || sign == NEXT_VAL_GREATER);
    first_neigh = true;

    for(uint64_t i = 0; i < nr_neighs; ++i) {
      next = fromVarint(pos, &diff);
      //cout << "Dn: ";
      //for(int ii = 0; ii < next; ii++) cout << (unsigned int)(*(pos+ii)) << " ";
      pos += next;
      itr += next;
      if(first_neigh) {
        if(sign == NEXT_VAL_SMALLER) {
          neigh = v - diff;
        }
        else {
          neigh = v + diff;
        }
        assert(neigh < (uint64_t)t->size());
        assert(neigh == (uint64_t)neighs[i]);

        first_neigh = false;
        prev_neigh = neigh;
        continue;
      }

      neigh = prev_neigh + diff;
      assert(neigh < (uint64_t)t->size());
      assert(neigh == (uint64_t)neighs[i]);
      prev_neigh = neigh;
    }

    prev_v = v;
  }
}

v_id* MyVarintWordBasedCoder::decodeVertexNeighbors(v_id v, int64_t offset) {
  v_id nr_neighs = 0;
  unsigned char* pos = &adj_data_[offset << 3];
  pos += fromVarint(pos, &nr_neighs);
  assert(nr_neighs <= n_);
  v_id* neighbors = new v_id[nr_neighs];

  unsigned char sign = *pos;
  ++pos;

  assert(sign == NEXT_VAL_SMALLER || sign == NEXT_VAL_GREATER);
  bool first_neigh = true;
  uint64_t diff = 0;
  uint64_t neigh = 0;
  uint64_t prev_neigh = 0;

  for(v_id i = 0; i < nr_neighs; ++i) {
    pos += fromVarint(pos, &diff);
    if(first_neigh) {
      if(sign == NEXT_VAL_SMALLER) {
        neigh = v - diff;
      }
      else {
        neigh = v + diff;
      }
      neighbors[i] = neigh;

      first_neigh = false;
      prev_neigh = neigh;
      continue;
    }

    neigh = prev_neigh + diff;
    neighbors[i] = neigh;
    prev_neigh = neigh;
  }
  return neighbors;
}

v_id* MyVarintWordBasedCoder::decodeVertexNeighborsAndDegree(v_id v, int64_t offset, v_id* nr_neighs_out) {
  v_id nr_neighs = 0;
  unsigned char* pos = &adj_data_[offset << 3];
  pos += fromVarint(pos, &nr_neighs);
  assert(nr_neighs <= n_);
  *nr_neighs_out = nr_neighs;
  v_id* neighbors = new v_id[nr_neighs];

  unsigned char sign = *pos;
  ++pos;

  assert(sign == NEXT_VAL_SMALLER || sign == NEXT_VAL_GREATER);
  bool first_neigh = true;
  uint64_t diff = 0;
  uint64_t neigh = 0;
  uint64_t prev_neigh = 0;

  for(v_id i = 0; i < nr_neighs; ++i) {
    pos += fromVarint(pos, &diff);
    if(first_neigh) {
      if(sign == NEXT_VAL_SMALLER) {
        neigh = v - diff;
      }
      else {
        neigh = v + diff;
      }
      neighbors[i] = neigh;

      first_neigh = false;
      prev_neigh = neigh;
      continue;
    }

    neigh = prev_neigh + diff;
    neighbors[i] = neigh;
    prev_neigh = neigh;
  }
  return neighbors;
}
