#if !defined(__MYVARINTWORDBASEDNODIFFCODER_H__)
#define      __MYVARINTWORDBASEDNODIFFCODER_H__

#include <cmath>

#include "sdsl/bit_vectors.hpp"
#include "sdsl/io.hpp"
using namespace sdsl;

#include "globals.h"
#include "utils/debug.h"
#include "utils/myVarint.h"
#include "representations/misc.h"
#include "representations/metisR.h"
#include "representations/tradListGraphR.h"
#include "coders/common.h"

class MyVarintWordBasedNoDiffCoder {
  public:
    MyVarintWordBasedNoDiffCoder();
    ~MyVarintWordBasedNoDiffCoder();

    void encode(const TradListGraphR* t, int64_t** offsets_out);
    //void encode(const MetisR* m, int64_t** offsets_out);

    inline v_id decodeVertexDegree(v_id v, int64_t offset) __attribute__((always_inline));
    inline bool decodeVertexConnectionUseV1Neighbors(v_id v1, v_id v2, int64_t v1_offset) __attribute__((always_inline));
    inline bool decodeVertexConnectionUseV2Neighbors(v_id v1, v_id v2, int64_t v2_offset) __attribute__((always_inline));
    inline bool decodeVertexConnectionUseMinNeighbors(v_id v1, v_id v2, int64_t v1_offset, int64_t v2_offset) __attribute__((always_inline));
    v_id* decodeVertexNeighbors(v_id v, int64_t offset);
    v_id* decodeVertexNeighborsAndDegree(v_id v, int64_t offset, v_id* v_deg_out);

    inline uint64_t adj_data_total_size_in_bytes();
    inline uint64_t adj_data_total_redundancy_in_bytes();
    inline uint64_t adj_data_edges_redundancy_in_bytes();
    inline uint64_t adj_data_signs_redundancy_in_bytes();
    inline uint64_t adj_data_neighbors_redundancy_in_bytes();

  private:
    unsigned char* adj_data_ = NULL;
    AdjDataSizeInfo* adj_data_size_info_ = NULL;
    v_id n_ = 0;
    v_id m_ = 0;
};

__attribute__((always_inline)) inline v_id MyVarintWordBasedNoDiffCoder::decodeVertexDegree(v_id v, int64_t offset) {
  __UNUSED(v);  // Get rid of a warning.
  uint64_t nr_neighs = 0;
  fromVarint( &adj_data_[offset << 3], &nr_neighs);
  return nr_neighs;
}

// TODO: faster! no stupid allocation etc
__attribute__((always_inline)) inline bool MyVarintWordBasedNoDiffCoder::decodeVertexConnectionUseV1Neighbors(v_id v1, v_id v2, int64_t v1_offset) {
  v_id neighS_v1_nr = decodeVertexDegree(v1, v1_offset);
  v_id* neighS_v1 = decodeVertexNeighbors(v1, v1_offset);

  for(v_id i = 0; i < neighS_v1_nr; ++i) {
    if(neighS_v1[i] == v2) {
      delete [] neighS_v1;
      return true;
    }
  }
  delete [] neighS_v1;
  return false;
}

// TODO: faster! no stupid allocation etc
__attribute__((always_inline)) inline bool MyVarintWordBasedNoDiffCoder::decodeVertexConnectionUseV2Neighbors(v_id v1, v_id v2, int64_t v2_offset) {
  v_id neighS_v2_nr = decodeVertexDegree(v2, v2_offset);
  v_id* neighS_v2 = decodeVertexNeighbors(v2, v2_offset);

  for(v_id i = 0; i < neighS_v2_nr; ++i) {
    if(neighS_v2[i] == v1) {
      delete [] neighS_v2; 
      return true;
    }
  }
  delete [] neighS_v2;
  return false;
}

// TODO: faster! no stupid allocation etc
__attribute__((always_inline)) inline bool MyVarintWordBasedNoDiffCoder::decodeVertexConnectionUseMinNeighbors(v_id v1, v_id v2, int64_t v1_offset, int64_t v2_offset) {
  v_id neighS_v1_nr = decodeVertexDegree(v1, v1_offset);
  v_id neighS_v2_nr = decodeVertexDegree(v2, v2_offset);

  if(neighS_v1_nr > neighS_v2_nr) {
    return decodeVertexConnectionUseV2Neighbors(v1, v2, v2_offset);
  }
  else {
    return decodeVertexConnectionUseV1Neighbors(v1, v2, v1_offset);
  }
}

inline uint64_t MyVarintWordBasedNoDiffCoder::adj_data_total_size_in_bytes() {
  return adj_data_size_info_->adj_data_total_size_in_bytes_;
}

inline uint64_t MyVarintWordBasedNoDiffCoder::adj_data_total_redundancy_in_bytes() {
  return adj_data_size_info_->adj_data_total_redundancy_in_bytes_;
}

inline uint64_t MyVarintWordBasedNoDiffCoder::adj_data_edges_redundancy_in_bytes() {
  return adj_data_size_info_->adj_data_edges_redundancy_in_bytes_;
}

inline uint64_t MyVarintWordBasedNoDiffCoder::adj_data_signs_redundancy_in_bytes() {
  return adj_data_size_info_->adj_data_signs_redundancy_in_bytes_;
}

inline uint64_t MyVarintWordBasedNoDiffCoder::adj_data_neighbors_redundancy_in_bytes() {
  return adj_data_size_info_->adj_data_neighbors_redundancy_in_bytes_;
}

#endif
