#if !defined(__COMMON_H__)
#define      __COMMON_H__

#ifdef USE_MPI
#include <mpi.h>
#endif

#include <omp.h>

#include <cstdio>
#include <cstdlib>
#include <cerrno>
#include <cstring>
#include <cmath>
#include <cassert>
#include <cstdint>

#include <vector>
#include <map>
#include <set>
#include <bitset>
#include <list>
#include <stack>

#include <chrono>
#include <atomic>

#include <iterator>
#include <algorithm>

#include <iostream>
#include <fstream>
#include <sstream>
#include <string>

#include <zlib.h>

typedef int64_t v_id;
typedef int64_t e_w;
extern bool verbose;

#define __CACHE_LINE_SIZE__ 64

#define __XGRAPH_LSB_FLUSH_FREQUENCY 5

#define TWO_POW_7 128
#define TWO_POW_14 16384
#define TWO_POW_20 1048576
#define TWO_POW_21 2097152
#define TWO_POW_28 268435456
#define TWO_POW_35 34359738368
#define TWO_POW_42 4398046511104
#define TWO_POW_49 562949953421312
#define TWO_POW_56 72057594037927936
#define TWO_POW_63 9223372036854775808

#define BIT_8_SET 0x80
#define BIT_8_CLEAR 0x7F

#define BITS_IN_BYTE 8
#define BYTES_IN_64BIT_WORD 8
#define BITS_IN_64BIT_WORD 64

#define NEXT_VAL_SMALLER 0x01
#define NEXT_VAL_GREATER 0x00

// TODO: more flexible?
#define MAX_RECURSIVE_PREFIX_LEN 255

#define __UNUSED(arg) ((void)arg)

#endif
