#include "offsetsBV.h"

// TODO: a variant where each adjacency list is aligned
OffsetsBV::OffsetsBV(v_id n, v_id m, const int64_t* offsets) { 
  n_ = n;
  m_ = m;
  int64_t max_offset = offsets[n-1];
  assert(offsets[n-2] <= offsets[n-1]);

  for(int i = 0; i < n; ++i) {
    if(i > 0) {
      assert(offsets[i] >= offsets[i-1]);
    }
    //cout << offsets[i] << endl;
  }

  // TODO: here I assume that offsets are always positive.
  // maybe use some negative as well? Investigate
  bv_ = new bit_vector(max_offset+1,0);

  for(int i = 0; i < n; ++i) {
    if(i > 0) {
      assert(offsets[i] >= offsets[i-1]);
    }
    assert(offsets[i] < (int64_t)bv_->size());
    (*bv_)[offsets[i]] = 1;
  }
  bv_sel_ = new bit_vector::select_1_type(bv_);
  size_in_bytes_ub_ = size_in_bytes(*bv_) + ceil((0.2 * n) / 8.0);
  assert(bv_sel_ != NULL);
}

OffsetsBV::OffsetsBV(const TradListGraphR* t, const int64_t* offsets) : OffsetsBV(t->n_, t->m_, offsets) { 
  
}

OffsetsBV::~OffsetsBV() {
  delete bv_sel_;
  delete bv_;
}

/*
   int64_t OffsetsBV::getVertexOffset(v_id v) {
   return (*bv_sel_)(v+1);
   }

   void OffsetsBV::setVertexOffset(int64_t offset) {
   (*bv_)[offset] = 1;
// TODO: does the size change here?
}
 */
