#if !defined(__OFFSETS_BV_H__)
#define      __OFFSETS_BV_H__

#include "sdsl/bit_vectors.hpp"                                                                                                                                                                                           
#include "sdsl/io.hpp"                                                                                                                                                                                                    
using namespace sdsl;

#include "globals.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"

class OffsetsBV {
  public:
    OffsetsBV(v_id n, v_id m, const int64_t* offsets);
    OffsetsBV(const TradListGraphR* t, const int64_t* offsets);
    ~OffsetsBV();

    inline int64_t getVertexOffset(v_id v) __attribute__((always_inline));
    inline void setVertexOffset(int64_t offset) __attribute__((always_inline));
    inline uint64_t total_size_in_bytes() {return size_in_bytes_ub_;}

  public:
    // TODO: make sure that new allocates aligned data
    bit_vector* bv_ = NULL;

    // TODO: try also select_support_scan
    bit_vector::select_1_type* bv_sel_ = NULL;
    int64_t size_in_bytes_ub_ = 0;
    v_id n_;
    v_id m_;
};

__attribute__((always_inline))
inline int64_t OffsetsBV::getVertexOffset(v_id v) {
    return (*bv_sel_)(v+1);
}

__attribute__((always_inline))
inline void OffsetsBV::setVertexOffset(int64_t offset) {
    (*bv_)[offset] = 1;
      // TODO: does the size change here?
}

#endif
