#include "offsetsBVCompressed.h"

// TODO: a variant where each adjacency list is aligned
OffsetsBVCompressed::OffsetsBVCompressed(v_id n, v_id m, const int64_t* offsets) { 
  n_ = n;
  m_ = m;
  int64_t max_offset = offsets[n-1];
  assert(offsets[n-2] <= offsets[n-1]);

  for(int i = 0; i < n; ++i) {
    if(i > 0) {
      assert(offsets[i] >= offsets[i-1]);
    }
    //cout << offsets[i] << endl;
  }

  // TODO: here I assume that offsets are always positive.
  // maybe use some negative as well? Investigate
  bv_ = new bit_vector(max_offset+1,0);

  for(int i = 0; i < n; ++i) {
    if(i > 0) {
      assert(offsets[i] >= offsets[i-1]);
    }
    assert(offsets[i] < (int64_t)bv_->size());
    (*bv_)[offsets[i]] = 1;
  }
  bv_sel_ = new bit_vector::select_1_type(bv_);
  //unsigned long int size_in_bytes_ub = size_in_bytes(*bv_) + ceil((0.2 * n) / 8.0);
  unsigned long int size_in_bytes_var = size_in_bytes(*bv_);
  assert(bv_sel_ != NULL);

  uint64_t* data = bv_->data();
  //unsigned long int size_in_bytes = bv_->size() * bv_->width() + 1;

  unsigned long int compressed_size = compressBound(size_in_bytes_var);
  unsigned char* zlib_buf = (unsigned char*)malloc(compressed_size);
  int res = compress(zlib_buf, &compressed_size, (unsigned char*)data, size_in_bytes_var);

  if(res == Z_BUF_ERROR){
    printf("Buffer was too small!\n");
    exit(EXIT_FAILURE);
  }
  if(res ==  Z_MEM_ERROR){
    printf("Not enough memory for compression!\n");
    exit(EXIT_FAILURE);
  }
  assert(res == Z_OK);

  data_compressed_ = zlib_buf;
  size_in_bytes_compressed_ub_ = compressed_size + ceil((0.2 * n) / 8.0);
  size_in_bytes_compressed_ = compressed_size;
}

OffsetsBVCompressed::OffsetsBVCompressed(const TradListGraphR* t, const int64_t* offsets) : OffsetsBVCompressed(t->n_, t->m_, offsets) { 
}

OffsetsBVCompressed::~OffsetsBVCompressed() {
  delete bv_sel_;
  delete bv_;
  free(data_compressed_);
}

/*
   int64_t OffsetsBVCompressed::getVertexOffset(v_id v) {
   return (*bv_sel_)(v+1);
   }

   void OffsetsBVCompressed::setVertexOffset(int64_t offset) {
   (*bv_)[offset] = 1;
// TODO: does the size change here?
}
 */
