#if !defined(__OFFSETS_BV_COMPRESSED_H__)
#define      __OFFSETS_BV_COMPRESSED_H__

#include "sdsl/bit_vectors.hpp"                                                                                                                                                                                           
#include "sdsl/io.hpp"                                                                                                                                                                                                    
using namespace sdsl;

#include "globals.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"

class OffsetsBVCompressed {
  public:
    OffsetsBVCompressed(v_id n, v_id m, const int64_t* offsets);
    OffsetsBVCompressed(const TradListGraphR* t, const int64_t* offsets);
    ~OffsetsBVCompressed();

    inline int64_t getVertexOffset(v_id v) __attribute__((always_inline));
    inline void setVertexOffset(int64_t offset) __attribute__((always_inline));
    inline uint64_t total_size_in_bytes() {return size_in_bytes_compressed_ub_;}

  public:
    // TODO: make sure that new allocates aligned data
    bit_vector* bv_ = NULL;
    unsigned char* data_compressed_ = NULL;

    // TODO: try also select_support_scan
    bit_vector::select_1_type* bv_sel_ = NULL;
    int64_t size_in_bytes_ub_ = 0;
    int64_t size_in_bytes_compressed_ub_ = 0;
    int64_t size_in_bytes_compressed_ = 0;
    v_id n_;
    v_id m_;
};

__attribute__((always_inline))
  inline int64_t OffsetsBVCompressed::getVertexOffset(v_id v) {
    int64_t* offsets = new int64_t[n_]();
    //int64_t offset = -1;
    unsigned long int original_data_len_in_bytes = sizeof(int64_t)*n_;
    int res = uncompress((unsigned char*)offsets, &original_data_len_in_bytes, data_compressed_, size_in_bytes_compressed_);
    if(res == Z_BUF_ERROR){
      printf("De: Buffer was too small!\n");
      exit(EXIT_FAILURE);
    }
    if(res ==  Z_MEM_ERROR){
      printf("De: Not enough memory for compression!\n");
      exit(EXIT_FAILURE);
    }
    if(res ==  Z_DATA_ERROR){
      printf("De: Data error!\n");
      exit(EXIT_FAILURE);
    }

    //printf("De: Error code: %i\n", res);
    assert(res == Z_OK);

    

    //offset = offsets[v];
    delete [] offsets;
    //return offset;
    return (*bv_sel_)(v+1);
  }

__attribute__((always_inline))
  inline void OffsetsBVCompressed::setVertexOffset(int64_t offset) {
    (*bv_)[offset] = 1;
    // TODO: does the size change here?
  }

#endif
