#if !defined(__OFFSETS_BV_IL_H__)
#define      __OFFSETS_BV_IL_H__

#include "sdsl/bit_vectors.hpp"                                                                                                                                                                                           
#include "sdsl/io.hpp"                                                                                                                                                                                                    
using namespace sdsl;

#include "globals.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"

class OffsetsBV_IL {
  public:
    OffsetsBV_IL(v_id n, v_id m, const int64_t* offsets);
    OffsetsBV_IL(const TradListGraphR* t, const int64_t* offsets);
    ~OffsetsBV_IL();

    // TODO: add an inline? 
    inline int64_t getVertexOffset(v_id v) __attribute__((always_inline));
    inline uint64_t total_size_in_bytes() {return size_in_bytes_;}

  public:
    // TODO: make sure that new allocates aligned data
    bit_vector_il<>* bv_ = NULL;

    // TODO: try also select_support_scan
    bit_vector_il<>::select_1_type* bv_sel_ = NULL;
    int64_t size_in_bytes_ = 0;
    v_id n_;
    v_id m_;
};

__attribute__((always_inline))
inline int64_t OffsetsBV_IL::getVertexOffset(v_id v) {
    return (*bv_sel_)(v+1);
}

#endif
