#include "offsetsBV_SD.h"

// TODO: a variant where each adjacency list is aligned
OffsetsBV_SD::OffsetsBV_SD(v_id n, v_id m, const int64_t* offsets) { 
  n_ = n;
  m_ = m;
  int64_t max_offset = offsets[n-1];
  assert(offsets[n-2] <= offsets[n-1]);

  // TODO: here I assume that offsets are always positive.
  // maybe use some negative as well? Investigate
  bit_vector* bv_temp = new bit_vector(max_offset+1,0);
  for(int i = 0; i < n; ++i) {
    (*bv_temp)[offsets[i]] = 1;
  }
  bv_ = new sd_vector<>(*bv_temp);
  delete bv_temp;
  bv_sel_ = new sd_vector<>::select_1_type(bv_);
  size_in_bytes_ = size_in_bytes(*bv_) + 8;
}

OffsetsBV_SD::OffsetsBV_SD(const TradListGraphR* t, const int64_t* offsets) : OffsetsBV_SD(t->n_, t->m_, offsets) {
}

OffsetsBV_SD::~OffsetsBV_SD() {
  delete bv_sel_;
  delete bv_;
}

/*
int64_t OffsetsBV_SD::getVertexOffset(v_id v) {
  return (*bv_sel_)(v+1);
}
*/

