#include "offsetsPtrs.h"

OffsetsPtrs::OffsetsPtrs(v_id n, v_id m, const int64_t* offsets) { 
  n_ = n;
  m_ = m;
  offsets_ = new int64_t[n]();
  size_in_bytes_ = sizeof(int64_t)*n;
  for(int i = 0; i < n; ++i) {
    offsets_[i] = offsets[i];
  }
}

OffsetsPtrs::OffsetsPtrs(const TradListGraphR* t, const int64_t* offsets) { 
  n_ = t->n_;
  m_ = t->m_;
  offsets_ = new int64_t[n_]();
  size_in_bytes_ = sizeof(int64_t)*n_;
  for(int i = 0; i < n_; ++i) {
    offsets_[i] = offsets[i];
  }
}

OffsetsPtrs::~OffsetsPtrs() {
  delete [] offsets_;
}

/*
int64_t OffsetsPtrs::getVertexOffset(v_id v) {
  return offsets_[v];
}

void OffsetsPtrs::setVertexOffset(v_id v, int64_t val) {
  offsets_[v] = val;
}
*/
