#include "offsetsPtrsCompressed.h"

OffsetsPtrsCompressed::OffsetsPtrsCompressed(v_id n, v_id m, const int64_t* offsets) { 
  n_ = n;
  m_ = m;
  int64_t size_in_bytes = sizeof(int64_t)*n;
  /*int64_t* offsets_local = new int64_t[n]();
  for(int i = 0; i < n; ++i) {
    offsets_local[i] = offsets[i];
  }*/
  compress_data(offsets, size_in_bytes);
  //delete [] offsets;
}

OffsetsPtrsCompressed::OffsetsPtrsCompressed(const TradListGraphR* t, const int64_t* offsets) { 
  n_ = t->n_;
  m_ = t->m_;
  int64_t size_in_bytes = sizeof(int64_t)*n_;
  /*offsets = new int64_t[n_]();
  for(int i = 0; i < n_; ++i) {
    offsets[i] = offsets[i];
  }*/
  compress_data(offsets, size_in_bytes);
  //delete [] offsets;
}

OffsetsPtrsCompressed::~OffsetsPtrsCompressed() {
  free(data_);
}

void OffsetsPtrsCompressed::compress_data(const int64_t* offsets, unsigned long int size_in_bytes) {
  unsigned long int compressed_size = compressBound(size_in_bytes);
  unsigned char* zlib_buf = (unsigned char*)malloc(compressed_size);
  int res = compress(zlib_buf, &compressed_size, (unsigned char*)offsets, size_in_bytes); 
  
  if(res == Z_BUF_ERROR){
    printf("Buffer was too small!\n");
    exit(EXIT_FAILURE);
  }
  if(res ==  Z_MEM_ERROR){
    printf("Not enough memory for compression!\n");
    exit(EXIT_FAILURE);
  }
  assert(res == Z_OK);

  data_ = zlib_buf;
  size_in_bytes_ = compressed_size; // TODO: make sure these are bytes.
}

/*
   int64_t OffsetsPtrsCompressed::getVertexOffset(v_id v) {
   return offsets_[v];
   }

   void OffsetsPtrsCompressed::setVertexOffset(v_id v, int64_t val) {
   offsets_[v] = val;
   }
 */
