#if !defined(__OFFSETS_PTRS_COMPRESSED_H__)
#define      __OFFSETS_PTRS_COMPRESSED_H__

#include "globals.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"

class OffsetsPtrsCompressed {
  public:
    OffsetsPtrsCompressed(v_id n, v_id m, const int64_t* offsets);
    OffsetsPtrsCompressed(const TradListGraphR* t, const int64_t* offsets);
    ~OffsetsPtrsCompressed();

    // TODO: add an inline? 
    inline int64_t getVertexOffset(v_id v) __attribute__((always_inline));
    inline void setVertexOffset(v_id v, int64_t val) __attribute__((always_inline));
    inline uint64_t total_size_in_bytes() {return size_in_bytes_;}

  public:
    // TODO: make sure that new allocates aligned data
    unsigned char* data_;
    int64_t size_in_bytes_ = 0;
    v_id n_;
    v_id m_;

  private:
    void compress_data(const int64_t* offsets, unsigned long int size_in_bytes);
};

__attribute__((always_inline))
  inline int64_t OffsetsPtrsCompressed::getVertexOffset(v_id v) {
    int64_t* offsets = new int64_t[n_]();
    int64_t offset = -1;
    unsigned long int original_data_len_in_bytes = sizeof(int64_t)*n_;
    int res = uncompress((unsigned char*)offsets, &original_data_len_in_bytes, data_, size_in_bytes_);
    if(res == Z_BUF_ERROR){
      printf("De: Buffer was too small!\n");
      exit(EXIT_FAILURE);
    }
    if(res ==  Z_MEM_ERROR){
      printf("De: Not enough memory for compression!\n");
      exit(EXIT_FAILURE);
    }
    if(res ==  Z_DATA_ERROR){
      printf("De: Data error!\n");
      exit(EXIT_FAILURE);
    }
    assert(res == Z_OK);
    offset = offsets[v];
    delete [] offsets;
    return offset;
  }

__attribute__((always_inline))
  inline void OffsetsPtrsCompressed::setVertexOffset(v_id v, int64_t val) {
    __UNUSED(v);
    __UNUSED(val);
    //offsets_[v] = val;
  }

#endif
