#if !defined(__OFFSETS_PTRSLOGN_H__)
#define      __OFFSETS_PTRSLOGN_H__

#include "globals.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"

class OffsetsPtrsLogn {
  public:
    OffsetsPtrsLogn(v_id n, v_id m, const int64_t* offsets);
    OffsetsPtrsLogn(const TradListGraphR* t, const int64_t* offsets);
    ~OffsetsPtrsLogn();

    // TODO: add an inline? 
//    inline int64_t getVertexOffset(v_id v) __attribute__((always_inline));
//    inline void setVertexOffset(v_id v, int64_t val) __attribute__((always_inline));
    inline uint64_t total_size_in_bytes() {return size_in_bytes_;}

  public:
    // TODO: make sure that new allocates aligned data
    int64_t* offsets_ = NULL;
    int64_t size_in_bytes_ = 0;
    v_id n_;
    v_id m_;
};

/*

__attribute__((always_inline))
inline int64_t OffsetsPtrsLogn::getVertexOffset(v_id v) {
    return offsets_[v];
}

__attribute__((always_inline))
inline void OffsetsPtrsLogn::setVertexOffset(v_id v, int64_t val) {
    offsets_[v] = val;
}

*/

#endif
