#include "recPart.h"
#include <omp.h>

/*
// TODO: for now it only counts storage requirements
void RecPart::recVertexPartition(PartitioningType partType, MetisR* g, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results) {
  if(partType == METIS_PARTITIONING) {
    recVertexPartitionMETIS(g, balance, full, lvls, rep, results);
  }
  else {
    exitMsg("Wrong partitioning type");
  }
}

// TODO: for now it only counts storage requirements
void RecPart::recVertexPartitionMETIS(MetisR* r_met, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results) {
  idx_t n = r_met->n;
  assert(n > 0);

  //infoMsg("> RecPart: start initializeHelperStructures");
  initializeHelperStructures(balance, n);

  int graphs_nr = 1;
  MetisR** reps_met = new MetisR*[graphs_nr];
  reps_met[0] = r_met;

  bool finished = false;
  int lvl = 1;  
  bool edgesToCut = false;
  int val = -1; idx_t* part = NULL;

  while(!finished) {
    //infoMsg("> RecPart: START ITERATION");
    edgesToCut = false;
    vector<idx_t>* cuts = new vector<idx_t>();
    MetisR** next_reps_m = new MetisR*[graphs_nr*BIS_PARTS];
    int next_graph = 0;
  
    for(int j = 0; j < graphs_nr; j++) {
      if(reps_met[j]->n > 0) {
        part = new idx_t[reps_met[j]->n];
        //infoMsg("> RecPart: START RECURSION BISECTION");
        val = METIS_PartGraphRecursive(&(reps_met[j]->n), &ncon_, reps_met[j]->xadj, reps_met[j]->adjncy, NULL, NULL, NULL, &nparts_bisection_, NULL, NULL, options_, &objval_, part);
        //infoMsg("> RecPart: start checkMETISOutput");
        checkMETISOutput(val);
        cuts->push_back(objval_);

        //infoMsg("> RecPart: start fromEdgeCutToMetisR");
        MetisR** subgraphs = fromEdgeCutToMetisR(j, lvl, &objval_, part, reps_met[j], &edgesToCut);
        for(int k = 0; k < BIS_PARTS; k++) {
          next_reps_m[next_graph++] = subgraphs[k];
        }

        delete [] subgraphs;
        delete [] part;
      }
      else {
        //fprintf(stderr, "Size zero, level: %d, nr in the level: %d\n", lvl, j);
        cuts->push_back(-1);  //TODO: make more elegant
        for(int k = 0; k < BIS_PARTS; k++) {
          next_reps_m[next_graph++] = new MetisR(NULL, NULL, 0, 0);
        }
      }
    }

    if(lvl > 1) {
      for(int j = 0; j < graphs_nr; j++) {delete reps_met[j];}
    }
    delete [] reps_met;

    reps_met = next_reps_m;
    graphs_nr *= BIS_PARTS;
    (*res_)[lvl] = cuts;

    //infoMsg("> RecPart: updateEndingConditions");
    updateEndingConditions(full, lvls, edgesToCut, &lvl, &finished);
  }

  if(lvls > 0 || full == true) {
    for(int j = 0; j < graphs_nr; j++) {delete reps_met[j];}
  }
  delete [] reps_met;

  //map<string, v_id>* reversed_res = reverseResultMap();

  *rep = r;
  *results = res_;

  cleanUpHelperStructures();
}*/

// TODO: apply different balance ratios at different levels
void RecPart::recEdgePartition(PartitioningType partType, MetisR* g, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results) {
  if(partType == METIS_PARTITIONING) {
    recEdgePartitionMETIS(g, balance, full, lvls, rep, results);
  }
  else if(partType == METIS_PARTITIONING_MULTITHREADED) {
    recEdgePartitionMETISMultithreaded(g, balance, full, lvls, rep, results);
  }
  else {
    exitMsg("Wrong partitioning type");
  }
}

void RecPart::recEdgePartitionMETISMultithreaded(MetisR* r_met, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results) {
  idx_t n = r_met->n_;
  assert(n > 0);

  //initializeHelperStructures(balance, n);

  // METIS structures
  idx_t* options = new idx_t[METIS_NOPTIONS];
  METIS_SetDefaultOptions(options);
  options[METIS_OPTION_OBJTYPE] = METIS_OBJTYPE_CUT; 
  options[METIS_OPTION_PTYPE] = METIS_PTYPE_RB;
  options[METIS_OPTION_NUMBERING] = 0;
  options[METIS_OPTION_UFACTOR] = balance;

  // then output structures
  CutResults* res = new CutResults();
  //SimpleRecGraphR* r = new SimpleRecGraphR();
  r_ = new SimpleRecGraphR();
  for(v_id i = 0; i < n; i++) {
    (*r_)[i] = new string("");
  }

gen_to_bin_ = new map< idx_t, pair<idx_t, string> >();
  bin_to_gen_ = new map< pair<idx_t, string>, idx_t >();
    for(v_id i = 0; i < n; i++) {
          (*gen_to_bin_)[i] = pair<idx_t, string>(i, "");
              (*bin_to_gen_)[pair<idx_t, string>(i, "")] = i;
                }



  int graphs_nr = 1;
  MetisR** reps_met = new MetisR*[graphs_nr];
  reps_met[0] = r_met;

  bool finished = false;
  bool edgesToCut = false;
  int lvl = 1;  /* 2^lvl subgraphs are created in i-th iteration */
  //idx_t* part = NULL;

  while(!finished) {
    std::cout << "> RecPart: START ITERATION pomocy Panie " << lvl << std::endl;
    edgesToCut = false;
    idx_t* cuts = new idx_t[graphs_nr]();
    MetisR** next_reps_m = new MetisR*[graphs_nr*BIS_PARTS];

    //int next_graph = 0;
 
    #pragma omp parallel for 
    for(int j = 0; j < graphs_nr; j++) {
          int tid = omp_get_thread_num();
          //cout << "[T " << tid << "] START loop iteration " << j << endl;

      assert(reps_met != NULL);
      assert(reps_met[j] != NULL);
      idx_t* part = NULL;
      idx_t ncon = 1;
      idx_t nparts_bisection = BIS_PARTS;
      idx_t objval = -1;
      idx_t __n = reps_met[j]->n_;
      //idx_t __m = reps_met[j]->m_;
      idx_t __val;

   //   idx_t* __xadj = new idx_t[__n+1];
   //   idx_t* __adjncy = new idx_t[2*__m];

   /*   #pragma omp critical
      {
      memcpy(&__xadj[0], &(reps_met[j]->xadj_)[0], sizeof(idx_t)*(__n+1));
      memcpy(&__adjncy[0], &(reps_met[j]->adjncy_)[0], sizeof(idx_t)*(2*__m));
      }*/

      if(reps_met[j]->n_ > 0) {
        MetisR** subgraphs = NULL;
        part = new idx_t[reps_met[j]->n_];
        //val = METIS_PartGraphRecursive(&(reps_met[j]->n_), &ncon, reps_met[j]->xadj_, reps_met[j]->adjncy_, NULL, NULL, NULL, &nparts_bisection, NULL, NULL, options, &objval, &part[0]);
        __val = METIS_PartGraphRecursive(&__n, &ncon, reps_met[j]->xadj_, reps_met[j]->adjncy_, NULL, NULL, NULL, &nparts_bisection, NULL, NULL, options, &objval, &part[0]);
        //__val = METIS_PartGraphRecursive(&__n, &ncon, __xadj, __adjncy, NULL, NULL, NULL, &nparts_bisection, NULL, NULL, options, &objval, &part[0]);

        #pragma omp critical 
        //#pragma omp ordered
        {
        //  cout << "[T " << tid << "] START critical section in loop iteration " << j << endl;
        checkMETISOutput(__val);
        cuts[j] = objval;


        bool edgesToCut_local = false;

        //#pragma omp critical 
        //{

        //MetisR** subgraphs = fromEdgeCutToMetisRMultithreaded(j, lvl, &objval, part, reps_met[j], &edgesToCut_local);
        subgraphs = fromEdgeCutToMetisRMultithreaded(j, lvl, &objval, part, reps_met[j], &edgesToCut_local, tid);
        //MetisR** subgraphs = fromEdgeCutToMetisR(j, lvl, &objval, part, reps_met[j], &edgesToCut_local);
        //MetisR** subgraphs = fromEdgeCutToMetisRMultithreaded(j, lvl, &objval, part, reps_met[j], &edgesToCut);
        for(int k = 0; k < BIS_PARTS; k++) {
          next_reps_m[2*j + k] = subgraphs[k];
          //next_reps_m[next_graph++] = subgraphs[k];
        }

        //#pragma omp atomic
        //{
          edgesToCut = edgesToCut || edgesToCut_local;
        }

        delete [] subgraphs;
        delete [] part;
      }
      else {
        //fprintf(stderr, "Size zero, level: %d, nr in the level: %d\n", lvl, j);
        cuts[j] = -1;  //TODO: make more elegant
        for(int k = 0; k < BIS_PARTS; k++) {
          next_reps_m[2*j + k] = new MetisR(NULL, NULL, 0, 0);
          //next_reps_m[next_graph++] = new MetisR(NULL, NULL, 0, 0);
        }
      }

     // delete [] __xadj;
     // delete [] __adjncy;
      //}
    }

    if(lvl > 1) {
      for(int j = 0; j < graphs_nr; j++) {delete reps_met[j];}
    }
    delete [] reps_met;

    std::vector<v_id>* converted_res = new std::vector<v_id>();
    for(int w = 0; w < graphs_nr; ++w) {
      converted_res->push_back(cuts[w]);
    }

    reps_met = next_reps_m;
    graphs_nr *= BIS_PARTS;
    
    (*res)[lvl] = converted_res;
    delete [] cuts;

    //infoMsg("> RecPart: updateEndingConditions");
    updateEndingConditions(full, lvls, edgesToCut, &lvl, &finished);
  }

  if(lvls > 0 || full == true) {
    for(int j = 0; j < graphs_nr; j++) {delete reps_met[j];}
  }
  delete [] reps_met;

  //map<string, v_id>* reversed_res = reverseResultMap();

  *rep = r_;
  *results = res;

  //TODO: a quick hack to save the data to disk

  r_ = NULL;
    res = NULL;

delete bin_to_gen_;
delete gen_to_bin_;
      delete [] options;
}


void RecPart::recEdgePartitionMETIS(MetisR* r_met, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results) {
//void RecPart::recEdgePartitionMETIS(MetisR* r_met, int balance, bool full, int lvls, map<string, v_id>** rep, CutResults** results) {
  idx_t n = r_met->n_;
  assert(n > 0);

  //infoMsg("> RecPart: start initializeHelperStructures");
  initializeHelperStructures(balance, n);

  int graphs_nr = 1;
  MetisR** reps_met = new MetisR*[graphs_nr];
  reps_met[0] = r_met;

  bool finished = false;
  int lvl = 1;  /* 2^lvl subgraphs are created in i-th iteration */
  bool edgesToCut = false;
  int val = -1; idx_t* part = NULL;

  while(!finished) {
    std::cout << "> RecPart: START ITERATION " << lvl << std::endl;
    edgesToCut = false;
    vector<idx_t>* cuts = new vector<idx_t>();
    MetisR** next_reps_m = new MetisR*[graphs_nr*BIS_PARTS];
    int next_graph = 0;
  
    for(int j = 0; j < graphs_nr; j++) {
      if(reps_met[j]->n_ > 0) {
        part = new idx_t[reps_met[j]->n_];
        //infoMsg("> RecPart: START RECURSION BISECTION");
        val = METIS_PartGraphRecursive(&(reps_met[j]->n_), &ncon_, reps_met[j]->xadj_, reps_met[j]->adjncy_, NULL, NULL, NULL, &nparts_bisection_, NULL, NULL, options_, &objval_, part);
        //infoMsg("> RecPart: start checkMETISOutput");
        checkMETISOutput(val);
        cuts->push_back(objval_);

        //infoMsg("> RecPart: start fromEdgeCutToMetisR");
        MetisR** subgraphs = fromEdgeCutToMetisR(j, lvl, &objval_, part, reps_met[j], &edgesToCut);
        for(int k = 0; k < BIS_PARTS; k++) {
          next_reps_m[next_graph++] = subgraphs[k];
        }

        delete [] subgraphs;
        delete [] part;
      }
      else {
        //fprintf(stderr, "Size zero, level: %d, nr in the level: %d\n", lvl, j);
        cuts->push_back(-1);  //TODO: make more elegant
        for(int k = 0; k < BIS_PARTS; k++) {
          next_reps_m[next_graph++] = new MetisR(NULL, NULL, 0, 0);
        }
      }
    }

    if(lvl > 1) {
      for(int j = 0; j < graphs_nr; j++) {delete reps_met[j];}
    }
    delete [] reps_met;

    reps_met = next_reps_m;
    graphs_nr *= BIS_PARTS;
    (*res_)[lvl] = cuts;

    //infoMsg("> RecPart: updateEndingConditions");
    updateEndingConditions(full, lvls, edgesToCut, &lvl, &finished);
  }

  if(lvls > 0 || full == true) {
    for(int j = 0; j < graphs_nr; j++) {delete reps_met[j];}
  }
  delete [] reps_met;

  //map<string, v_id>* reversed_res = reverseResultMap();

  *rep = r_;
  *results = res_;

  //TODO: a quick hack to save the data to disk


  cleanUpHelperStructures();
}

void RecPart::initializeHelperStructures(int balance, idx_t n) {
  // METIS structures
  ncon_ = 1;
  objval_ = 0;
  nparts_bisection_ = BIS_PARTS;
  options_ = new idx_t[METIS_NOPTIONS];
  METIS_SetDefaultOptions(options_);
  options_[METIS_OPTION_OBJTYPE] = METIS_OBJTYPE_CUT; 
  options_[METIS_OPTION_PTYPE] = METIS_PTYPE_RB;
  options_[METIS_OPTION_NUMBERING] = 0;
  options_[METIS_OPTION_UFACTOR] = balance;

  // then output structures
  res_ = new CutResults();
  r_ = new SimpleRecGraphR();
  for(v_id i = 0; i < n; i++) {
    (*r_)[i] = new string("");
  }

  // finally, initialize helper maps
  gen_to_bin_ = new map< idx_t, pair<idx_t, string> >();
  bin_to_gen_ = new map< pair<idx_t, string>, idx_t >();
  for(v_id i = 0; i < n; i++) {
    (*gen_to_bin_)[i] = pair<idx_t, string>(i, "");
    (*bin_to_gen_)[pair<idx_t, string>(i, "")] = i;
  }
}

void RecPart::cleanUpHelperStructures() {
  delete gen_to_bin_;
  delete bin_to_gen_;
  
  r_ = NULL;
  res_ = NULL;

  delete [] options_;
}

void RecPart::checkMETISOutput(int val) {
  if(val != METIS_OK) {
    exitMsg("METIS error !!!, return val: " << val);
  }
}

void RecPart::updateEndingConditions(bool full, int lvls, bool edgesToCut, int* lvl, bool* finished) {
  ++(*lvl);
  if((!full && *lvl > lvls) || (full && !edgesToCut)) {
    *finished = true;
  }
}
/*
MetisR** RecPart::fromEdgeCutToMetisR_fast(int j, int lvl, idx_t* objval_, idx_t* parts, MetisR* prev_graph, bool* edgesToCut) {
  string* prefix = new string(decToBin(j, lvl-1));
  idx_t prev_n = prev_graph->n;
  idx_t prev_m = prev_graph->m;
  idx_t* p_xadj = prev_graph->xadj;
  idx_t* p_adjncy = prev_graph->adjncy;

  idx_t nS[BIS_PARTS] = {0,0}, mS[BIS_PARTS] = {0,0}, processed_e = 0;
  map< pair<idx_t, string*>*, pair<idx_t, string*>* >* t = new map< pair<idx_t, string*>*, pair<idx_t, string*>* >();

  int p = -1;
  for(idx_t v = 0; v < prev_n; ++v) {
    p = parts[v];
    assert(p >= 0 && p < BIS_PARTS);

    string* new_v_prefix = new string(*prefix);
    new_v_prefix->append((p == 0 ? "0" : "1"));
    (*t)[new pair<idx_t, string*>(v,prefix)] = new pair<idx_t,string*>(nS[p]++, new_v_prefix);

    for(idx_t i = p_xadj[v]; i < p_xadj[v+1]; ++i) {
      idx_t neigh = p_adjncy[i];
      assert(neigh >= 0 && neigh < prev_n);
      if (p == parts[neigh]) ++mS[p];
      ++processed_e;
    }
  }

  assert(processed_e == 2*prev_m);
  assert((mS[0] % BIS_PARTS == 0) && (mS[1] % BIS_PARTS == 0));
  mS[0] /= BIS_PARTS; mS[1] /= BIS_PARTS;
  assert(nS[0] + nS[1] == prev_n);
  assert(mS[0] + mS[1] + *objval_ == prev_m);

  if(nS[0] > 1 || nS[1] > 1) {
    *edgesToCut = true;
  }

  MetisR** new_met_r = new MetisR*[BIS_PARTS];
  idx_t** xadjS = new idx_t*[BIS_PARTS];
  idx_t** adjncyS = new idx_t*[BIS_PARTS];

  for(int i = 0; i < BIS_PARTS; i++) {
    xadjS[i] = new idx_t[nS[i]+1];
    adjncyS[i] = new idx_t[2*mS[i]];
    xadjS[i][0] = 0;
  }

  processed_e = 0;
  idx_t new_v_id[BIS_PARTS] = {0, 0};
  idx_t new_e_id[BIS_PARTS] = {0, 0};

  for(idx_t v = 0; v < prev_n; ++v) {
    p = parts[v];

    string* new_v_prefix = new string(prefix);
    new_v_prefix->append((p == 0 ? "0" : "1"));
    idx_t gen_v_id = (*bin_to_gen_)[pair<idx_t, string>(v, prefix)];
    (*gen_to_bin_)[gen_v_id] = pair<idx_t, string>(new_v_id[p], *new_v_prefix);
    (*bin_to_gen_)[pair<idx_t, string>(new_v_id[p], *new_v_prefix)] = gen_v_id;
    (*r)[gen_v_id]->append((p == 0 ? "0" : "1"));
    if((unsigned int)j == ((1UL << lvl) - 1)) {
      (*bin_to_gen_).erase(pair<idx_t, string>(v, *prefix));
    }

    idx_t new_neigh_nr = 0;

    for(idx_t i = p_xadj[v]; i < p_xadj[v+1]; ++i) {
      idx_t neigh = p_adjncy[i];
      assert(neigh >= 0 && neigh < prev_n);

      if(p == parts[neigh]) {
        pair<idx_t,string>* new_neigh = (*t)[pair<idx_t,string*>(neigh,prefix)];
        assert(new_neigh.first >= 0);
        assert(new_neigh.first < nS[p]);

        adjncyS[p][new_e_id[p]++] = new_neigh.first;
        ++new_neigh_nr;
      }
      ++processed_e;
    }
    xadjS[p][new_v_id[p]+1] = xadjS[p][new_v_id[p]] + new_neigh_nr;
    ++new_v_id[p];
  }

  assert(processed_e == 2*prev_m);
  for(int i = 0; i < BIS_PARTS; i++) {
    new_met_r[i] = new MetisR(xadjS[i], adjncyS[i]);
    new_met_r[i]->n = nS[i];
    new_met_r[i]->m = mS[i];
    new_met_r[i]->checkConsistency();
  }

  delete [] xadjS;
  delete [] adjncyS;

  return new_met_r;
}
*/

MetisR** RecPart::fromEdgeCutToMetisRMultithreaded(int j, int lvl, idx_t* objval, idx_t* parts, MetisR* prev_graph, bool* edgesToCut, int _tid) {
  // finally, initialize helper maps
/*  map< idx_t, pair<idx_t, string> >* gen_to_bin = new map< idx_t, pair<idx_t, string> >();
  map< pair<idx_t, string>, idx_t >* bin_to_gen = new map< pair<idx_t, string>, idx_t >();
  for(v_id i = 0; i < n; i++) {
    (*gen_to_bin)[i] = pair<idx_t, string>(i, "");
    (*bin_to_gen)[pair<idx_t, string>(i, "")] = i;
  }*/

  string prefix = decToBin(j, lvl-1);
  idx_t prev_n = prev_graph->n_;
  idx_t prev_m = prev_graph->m_;
  idx_t* p_xadj = prev_graph->xadj_;
  idx_t* p_adjncy = prev_graph->adjncy_;

          
//          cout << "[T " << _tid << "] iteration " << j << "; prefix: " << prefix << endl;
  idx_t nS[BIS_PARTS] = {0,0}, mS[BIS_PARTS] = {0,0}, processed_e = 0;
  map< pair<idx_t, string>, pair<idx_t, string> > t;

  int p = -1;
  for(idx_t v = 0; v < prev_n; ++v) {
    p = parts[v];
    assert(p >= 0 && p < BIS_PARTS);

    string new_v_prefix = prefix + (p == 0 ? "0" : "1");
    t[pair<idx_t, string>(v,prefix)] = pair<idx_t,string>(nS[p]++, new_v_prefix);

  //        cout << "[T " << _tid << "] iteration " << j << "; inner iteration (A) for vertex: " << v << ", p = parts[v]: " << p << endl;
    for(idx_t i = p_xadj[v]; i < p_xadj[v+1]; ++i) {
      idx_t neigh = p_adjncy[i];
      assert(neigh >= 0 && neigh < prev_n);
      if (p == parts[neigh]) ++mS[p];
      ++processed_e;
    }
  }

  assert(processed_e == 2*prev_m);
  assert((mS[0] % BIS_PARTS == 0) && (mS[1] % BIS_PARTS == 0));
  mS[0] /= BIS_PARTS; mS[1] /= BIS_PARTS;
  assert(nS[0] + nS[1] == prev_n);
  assert(mS[0] + mS[1] + *objval == prev_m);

  if(nS[0] > 1 || nS[1] > 1) {
    *edgesToCut = true;
  }

  MetisR** new_met_r = new MetisR*[BIS_PARTS];
  idx_t** xadjS = new idx_t*[BIS_PARTS];
  idx_t** adjncyS = new idx_t*[BIS_PARTS];

  for(int i = 0; i < BIS_PARTS; i++) {
    xadjS[i] = new idx_t[nS[i]+1];
    adjncyS[i] = new idx_t[2*mS[i]];
    xadjS[i][0] = 0;
  }

  processed_e = 0;
  idx_t new_v_id[BIS_PARTS] = {0, 0};
  idx_t new_e_id[BIS_PARTS] = {0, 0};

  for(idx_t v = 0; v < prev_n; ++v) {
    p = parts[v];

//#pragma omp critical 
//{
    string new_v_prefix = prefix + (p == 0 ? "0" : "1");
    //      cout << "[T " << _tid << "] iteration " << j << "; inner iteration for vertex: " << v << ", p = parts[v]: " << p << endl;
    idx_t gen_v_id = (*bin_to_gen_)[pair<idx_t, string>(v, prefix)];
    (*gen_to_bin_)[gen_v_id] = pair<idx_t, string>(new_v_id[p], new_v_prefix);
    (*bin_to_gen_)[pair<idx_t, string>(new_v_id[p], new_v_prefix)] = gen_v_id;
    (*r_)[gen_v_id]->append((p == 0 ? "0" : "1"));
    
          int tid = omp_get_thread_num();
          assert(tid == _tid);
      //    cout << "[T " << tid << "] Accessing r_ in loop iteration " << j << "; V " << gen_v_id << " getting prefix " << *(*r_)[gen_v_id] << endl;
          cout.flush();

    if((unsigned int)j == ((1UL << lvl) - 1)) {
      (*bin_to_gen_).erase(pair<idx_t, string>(v, prefix));
    }
//}

    idx_t new_neigh_nr = 0;

    for(idx_t i = p_xadj[v]; i < p_xadj[v+1]; ++i) {
      idx_t neigh = p_adjncy[i];
      assert(neigh >= 0 && neigh < prev_n);

      if(p == parts[neigh]) {
        pair<idx_t,string> new_neigh = t[pair<idx_t,string>(neigh,prefix)];
        assert(new_neigh.first >= 0);
        assert(new_neigh.first < nS[p]);

        adjncyS[p][new_e_id[p]++] = new_neigh.first;
        ++new_neigh_nr;
      }
      ++processed_e;
    }
    xadjS[p][new_v_id[p]+1] = xadjS[p][new_v_id[p]] + new_neigh_nr;
    ++new_v_id[p];
  }

  assert(processed_e == 2*prev_m);
  for(int i = 0; i < BIS_PARTS; i++) {
    new_met_r[i] = new MetisR(xadjS[i], adjncyS[i]);
    new_met_r[i]->n_ = nS[i];
    new_met_r[i]->m_ = mS[i];
    new_met_r[i]->checkConsistency();
  }

  delete [] xadjS;
  delete [] adjncyS;

  //delete gen_to_bin;
  //delete bin_to_gen;

  return new_met_r;
}



MetisR** RecPart::fromEdgeCutToMetisR(int j, int lvl, idx_t* objval, idx_t* parts, MetisR* prev_graph, bool* edgesToCut) {
  string prefix = decToBin(j, lvl-1);
  idx_t prev_n = prev_graph->n_;
  idx_t prev_m = prev_graph->m_;
  idx_t* p_xadj = prev_graph->xadj_;
  idx_t* p_adjncy = prev_graph->adjncy_;

  idx_t nS[BIS_PARTS] = {0,0}, mS[BIS_PARTS] = {0,0}, processed_e = 0;
  map< pair<idx_t, string>, pair<idx_t, string> > t;

  int p = -1;
  for(idx_t v = 0; v < prev_n; ++v) {
    p = parts[v];
    assert(p >= 0 && p < BIS_PARTS);

    string new_v_prefix = prefix + (p == 0 ? "0" : "1");
    t[pair<idx_t, string>(v,prefix)] = pair<idx_t,string>(nS[p]++, new_v_prefix);

    for(idx_t i = p_xadj[v]; i < p_xadj[v+1]; ++i) {
      idx_t neigh = p_adjncy[i];
      assert(neigh >= 0 && neigh < prev_n);
      if (p == parts[neigh]) ++mS[p];
      ++processed_e;
    }
  }

  assert(processed_e == 2*prev_m);
  assert((mS[0] % BIS_PARTS == 0) && (mS[1] % BIS_PARTS == 0));
  mS[0] /= BIS_PARTS; mS[1] /= BIS_PARTS;
  assert(nS[0] + nS[1] == prev_n);
  assert(mS[0] + mS[1] + *objval == prev_m);

  if(nS[0] > 1 || nS[1] > 1) {
    *edgesToCut = true;
  }

  MetisR** new_met_r = new MetisR*[BIS_PARTS];
  idx_t** xadjS = new idx_t*[BIS_PARTS];
  idx_t** adjncyS = new idx_t*[BIS_PARTS];

  for(int i = 0; i < BIS_PARTS; i++) {
    xadjS[i] = new idx_t[nS[i]+1];
    adjncyS[i] = new idx_t[2*mS[i]];
    xadjS[i][0] = 0;
  }

  processed_e = 0;
  idx_t new_v_id[BIS_PARTS] = {0, 0};
  idx_t new_e_id[BIS_PARTS] = {0, 0};

  for(idx_t v = 0; v < prev_n; ++v) {
    p = parts[v];

    string new_v_prefix = prefix + (p == 0 ? "0" : "1");
    idx_t gen_v_id = (*bin_to_gen_)[pair<idx_t, string>(v, prefix)];
    (*gen_to_bin_)[gen_v_id] = pair<idx_t, string>(new_v_id[p], new_v_prefix);
    (*bin_to_gen_)[pair<idx_t, string>(new_v_id[p], new_v_prefix)] = gen_v_id;
    (*r_)[gen_v_id]->append((p == 0 ? "0" : "1"));
    if((unsigned int)j == ((1UL << lvl) - 1)) {
      (*bin_to_gen_).erase(pair<idx_t, string>(v, prefix));
    }

    idx_t new_neigh_nr = 0;

    for(idx_t i = p_xadj[v]; i < p_xadj[v+1]; ++i) {
      idx_t neigh = p_adjncy[i];
      assert(neigh >= 0 && neigh < prev_n);

      if(p == parts[neigh]) {
        pair<idx_t,string> new_neigh = t[pair<idx_t,string>(neigh,prefix)];
        assert(new_neigh.first >= 0);
        assert(new_neigh.first < nS[p]);

        adjncyS[p][new_e_id[p]++] = new_neigh.first;
        ++new_neigh_nr;
      }
      ++processed_e;
    }
    xadjS[p][new_v_id[p]+1] = xadjS[p][new_v_id[p]] + new_neigh_nr;
    ++new_v_id[p];
  }

  assert(processed_e == 2*prev_m);
  for(int i = 0; i < BIS_PARTS; i++) {
    new_met_r[i] = new MetisR(xadjS[i], adjncyS[i]);
    new_met_r[i]->n_ = nS[i];
    new_met_r[i]->m_ = mS[i];
    new_met_r[i]->checkConsistency();
  }

  delete [] xadjS;
  delete [] adjncyS;

  return new_met_r;
}

//SimpleRecGraphRRev* RecPart::sortBinaryRecursiveResults() {
map<string, v_id>* RecPart::reverseResultMap() {
  map<string, v_id>* output = new map<string, v_id>();
  for(const auto& item: *r_) {
    v_id v = item.first;
    string* bin = item.second;
    (*output)[*bin] = v;
  }
  return output;
}

//working version, just not efficient
MetisR** RecPart::fromEdgeCutToMetisR_Expensive(int j, int lvl, idx_t* objval, idx_t* parts, MetisR* prev_graph, bool* edgesToCut) {
  string prefix = decToBin(j, lvl-1);
  idx_t prev_n = prev_graph->n_;
  idx_t prev_m = prev_graph->m_;
  idx_t* p_xadj = prev_graph->xadj_;
  idx_t* p_adjncy = prev_graph->adjncy_;

  idx_t nS[BIS_PARTS] = {0,0}, mS[BIS_PARTS] = {0,0}, processed_e = 0;
  map< pair<idx_t, string>, pair<idx_t, string> > t;

  int p = -1;
  for(idx_t v = 0; v < prev_n; ++v) {
    p = parts[v];
    assert(p >= 0 && p < BIS_PARTS);

    string new_v_prefix = prefix + (p == 0 ? "0" : "1");
    t[pair<idx_t, string>(v,prefix)] = pair<idx_t,string>(nS[p]++, new_v_prefix);

    for(idx_t i = p_xadj[v]; i < p_xadj[v+1]; ++i) {
      idx_t neigh = p_adjncy[i];
      assert(neigh >= 0 && neigh < prev_n);
      if (p == parts[neigh]) ++mS[p];
      ++processed_e;
    }
  }

  assert(processed_e == 2*prev_m);
  assert((mS[0] % BIS_PARTS == 0) && (mS[1] % BIS_PARTS == 0));
  mS[0] /= BIS_PARTS; mS[1] /= BIS_PARTS;
  assert(nS[0] + nS[1] == prev_n);
  assert(mS[0] + mS[1] + *objval == prev_m);

  if(nS[0] > 1 || nS[1] > 1) {
    *edgesToCut = true;
  }

  MetisR** new_met_r = new MetisR*[BIS_PARTS];
  idx_t** xadjS = new idx_t*[BIS_PARTS];
  idx_t** adjncyS = new idx_t*[BIS_PARTS];

  for(int i = 0; i < BIS_PARTS; i++) {
    xadjS[i] = new idx_t[nS[i]+1];
    adjncyS[i] = new idx_t[2*mS[i]];
    xadjS[i][0] = 0;
  }

  processed_e = 0;
  idx_t new_v_id[BIS_PARTS] = {0, 0};
  idx_t new_e_id[BIS_PARTS] = {0, 0};

  infoMsg("$$$ Second pass starting");

  for(idx_t v = 0; v < prev_n; ++v) {
    p = parts[v];

    infoMsg("$$ Analyzing vertex " << v << " in partition " << p);

    string new_v_prefix = prefix + (p == 0 ? "0" : "1");
    infoMsg("$ New vertex prefix: " << new_v_prefix);
    idx_t gen_v_id = (*bin_to_gen_)[pair<idx_t, string>(v, prefix)];
    infoMsg("$ General vertex id: " << gen_v_id);
    (*gen_to_bin_)[gen_v_id] = pair<idx_t, string>(new_v_id[p], new_v_prefix);
    (*bin_to_gen_)[pair<idx_t, string>(new_v_id[p], new_v_prefix)] = gen_v_id;
    (*r_)[gen_v_id]->append((p == 0 ? "0" : "1"));
    infoMsg("^^^^^^^^^^^ (*r_) [" << gen_v_id << "] : " << *((*r_)[gen_v_id]));

    idx_t new_neigh_nr = 0;

    infoMsg("$ Start to analyze its neighbors");

    for(idx_t i = p_xadj[v]; i < p_xadj[v+1]; ++i) {
      idx_t neigh = p_adjncy[i];
      infoMsg("Neighbor " << i << ": " << neigh);
      assert(neigh >= 0 && neigh < prev_n);

      if(p == parts[neigh]) {
        pair<idx_t,string> new_neigh = t[pair<idx_t,string>(neigh,prefix)];
        assert(new_neigh.first >= 0);
        assert(new_neigh.first < nS[p]);
        infoMsg("New neighbor id: " << new_neigh.first << ", new prefix: " << new_neigh.second);

        adjncyS[p][new_e_id[p]++] = new_neigh.first;
        ++new_neigh_nr;
      }
      ++processed_e;
    }
    xadjS[p][new_v_id[p]+1] = xadjS[p][new_v_id[p]] + new_neigh_nr;
    ++new_v_id[p];
  }

  assert(processed_e == 2*prev_m);
  for(int i = 0; i < BIS_PARTS; i++) {
    new_met_r[i] = new MetisR(xadjS[i], adjncyS[i]);
    new_met_r[i]->n_ = nS[i];
    new_met_r[i]->m_ = mS[i];
    new_met_r[i]->checkConsistency();
  }

  delete [] xadjS;
  delete [] adjncyS;

  return new_met_r;
}


