#if !defined(__REC_PART_H__)
#define      __REC_PART_H__

#include "globals.h"
#include "utils/convert.h"
#include "utils/debug.h"
#include "representations/misc.h"
#include "representations/metisR.h"


/* This class uses recursively bisections a given graph and produces various
 * representations */

class RecPart {
  public: 
    void recEdgePartition(PartitioningType partType, MetisR* g, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results);
    //void recEdgePartition(PartitioningType partType, MetisR* g, int balance, bool full, int lvls, map<string, v_id>** rep, CutResults** results);
    map<string, v_id>* reverseResultMap();

    //TODO: hack:
    void recEdgePartition_F(PartitioningType partType, MetisR* g, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results, std::string f_name);
    void recEdgePartition_fromF(PartitioningType partType, MetisR* g, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results, std::string f_name);

  private:
    void recEdgePartitionMETIS(MetisR* r_met, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results);
    void recEdgePartitionMETISMultithreaded(MetisR* r_met, int balance, bool full, int lvls, SimpleRecGraphR** rep, CutResults** results);

    MetisR** fromEdgeCutToMetisR(int j, int lvl, idx_t* objval, idx_t* parts, MetisR* prev_graph, bool* edgesToCut);
    MetisR** fromEdgeCutToMetisRMultithreaded(int j, int lvl, idx_t* objval, idx_t* parts, MetisR* prev_graph, bool* edgesToCut, int tid);
    MetisR** fromEdgeCutToMetisR_Expensive(int j, int lvl, idx_t* objval, idx_t* parts, MetisR* prev_graph, bool* edgesToCut);

    void initializeHelperStructures(int balance, v_id n);
    void checkMETISOutput(int val);
    void updateEndingConditions(bool full, int lvls, bool edgesToCut, int* lvl, bool* finished);

    void cleanUpHelperStructures();
    void sortBinaryRecursiveResults();

    /* We need this map to remember at each moment what is
     * the original vertex id. We use it because METIS needs
     * vertices' ids to start from 0 for each subgraph */
    map< idx_t, pair<idx_t, string> >* gen_to_bin_; 
    map< pair<idx_t, string>, idx_t >* bin_to_gen_;
    SimpleRecGraphR* r_;
    CutResults* res_;

    // METIS specific arguments
    idx_t ncon_;
    idx_t objval_;
    idx_t nparts_bisection_;
    idx_t* options_;
};

#endif
