#include "recPermuter.h"

//not working? verify
map<v_id, v_id>* RecPermuter::generateHelperPermutationStr(const SimpleRecGraphR* r, const MetisR* t, VertexOrder v_order) {
  assert(r != NULL && t != NULL && v_order < 0);  // just to avoid warnings
  return NULL;
}


map<v_id, v_id>* RecPermuter::generateHelperPermutationStr(const SimpleRecGraphR* r, const TradListGraphR* t, VertexOrder v_order) {
  if(v_order == INORDER || v_order == NO_CHANGES) {
    map<string, pair<v_id,v_id> >* res = new map<string, pair<v_id, v_id> >();
    for(const auto& item : *r) {
      // Here we're sorting the vertices using their
      // inorder rank that we get from the string ids
      (*res)[*(item.second)] = pair<v_id, v_id>(item.first, -1);
    }

    //TODO: get rid of this structure
    map<v_id, v_id>* trans = new map<v_id, v_id>();  
    v_id new_v = 0;
    for(auto& item : *res) {
      item.second.second = new_v;
      (*trans)[item.second.first] = new_v++;
    }

    verifyTranslationConsistency(trans);
    delete res;
    return trans;
  }
  if(v_order == OPTIMAL_DIFF_NN_ILP_UNCONSTR || v_order == OPTIMAL_DIFF_NN_LP_UNCONSTR || v_order == OPTIMAL_DIFF_NN_ILP_CONSTR || v_order == OPTIMAL_DIFF_NN_LP_CONSTR || 
      v_order == OPTIMAL_DIFF_VN_ILP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_LP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_ILP_CONSTR || v_order == OPTIMAL_DIFF_VN_LP_CONSTR ||
      v_order == __O_ILP_NN_UN_N || v_order == __O_ILP_VN_UN_N || v_order == __O_ILP_NN_CON_N || v_order == __O_ILP_VN_CON_N) {

    TradAdj<v_id>* adj = t->adj_;
    map<v_id, v_id>* trans = new map<v_id, v_id>();  
    IloEnv env;

    try {
      IloModel model(env);
      IloNumVarArray vars(env);
      IloExpr obj_fun(env);

      v_id n = t->n_;
      //v_id m = t->m_;

      for(v_id i = 0; i < n; ++i) {
        if(v_order == OPTIMAL_DIFF_NN_ILP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_ILP_UNCONSTR) {
          vars.add(IloNumVar(env, 0, IloInfinity, ILOINT));
        }
        else if(v_order == OPTIMAL_DIFF_NN_ILP_CONSTR || v_order == OPTIMAL_DIFF_VN_ILP_CONSTR) {
          vars.add(IloNumVar(env, 0, n-1, ILOINT));
        }
        else if(v_order == OPTIMAL_DIFF_NN_LP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_LP_UNCONSTR) {
          vars.add(IloNumVar(env, 0, IloInfinity, ILOFLOAT));
        }
        else if(v_order == OPTIMAL_DIFF_NN_LP_CONSTR || v_order == OPTIMAL_DIFF_VN_LP_CONSTR) {
          vars.add(IloNumVar(env, 0, n-1, ILOFLOAT));
        }
        else if(v_order == __O_ILP_NN_UN_N || v_order == __O_ILP_VN_UN_N) {
          vars.add(IloNumVar(env, 0, IloInfinity, ILOINT));
        }
        else if(v_order == __O_ILP_NN_CON_N || v_order == __O_ILP_VN_CON_N) {
          vars.add(IloNumVar(env, 0, n-1, ILOINT));
        }
      }

      for(const auto& item: *adj) {
        v_id v1 = item.first;
        const vector<v_id>* neighbors = &(item.second);
        cerr << "Analyzing v " <<  v1 << endl;

        bool first = true;
        for(v_id i = 0; i < (v_id)neighbors->size(); ++i) {
          v_id v2 = (*neighbors)[i];

          if(first) {
            obj_fun += vars[v2] - vars[v1];
            if(v_order == OPTIMAL_DIFF_NN_ILP_CONSTR || v_order == OPTIMAL_DIFF_VN_ILP_CONSTR || v_order == OPTIMAL_DIFF_NN_ILP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_ILP_UNCONSTR ||
               v_order == __O_ILP_NN_UN_N || v_order == __O_ILP_VN_UN_N || v_order == __O_ILP_NN_CON_N || v_order == __O_ILP_VN_CON_N) {
              model.add(vars[v1] - vars[v2] != 0);
            }
            else {
              model.add(vars[v1] - vars[v2] >= 1 || vars[v1] - vars[v2] <= 1);
            }

            first = false;
            continue;
          }

          v_id prev_v2 = (*neighbors)[i-1];

          if(v_order == OPTIMAL_DIFF_NN_ILP_UNCONSTR || v_order == OPTIMAL_DIFF_NN_ILP_CONSTR) {
            obj_fun += vars[v2] - vars[prev_v2];
            model.add(vars[v2] - vars[prev_v2] > 0);
          }
          else if(v_order == OPTIMAL_DIFF_NN_LP_UNCONSTR || v_order == OPTIMAL_DIFF_NN_LP_CONSTR) {
            obj_fun += vars[v2] - vars[prev_v2];
            model.add(vars[v2] - vars[prev_v2] >= 1);
          }
          else if(v_order == OPTIMAL_DIFF_VN_ILP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_ILP_CONSTR) {
            obj_fun += vars[v2] - vars[v1];
            model.add(vars[v2] - vars[v1] > 0);
          }
          else if(v_order == OPTIMAL_DIFF_VN_LP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_LP_CONSTR) {
            obj_fun += vars[v2] - vars[v1];
            model.add(vars[v2] - vars[v1] >= 1);
          }
          else if(v_order == __O_ILP_NN_UN_N || v_order == __O_ILP_NN_CON_N) {
            obj_fun += vars[v2] - vars[prev_v2];
          }
          else if(v_order == __O_ILP_VN_UN_N || v_order == __O_ILP_VN_CON_N) {
            obj_fun += vars[v2] - vars[v1];
          }
        }
      }

      cerr << "Adding final constraints ";
      for(const auto& item1: *adj) {
        v_id v1 = item1.first;
        for(const auto& item2: *adj) {
          v_id v2 = item2.first;

          if(v1 == v2) {
            continue;
          }
          if(v_order == OPTIMAL_DIFF_NN_ILP_CONSTR || v_order == OPTIMAL_DIFF_VN_ILP_CONSTR || v_order == OPTIMAL_DIFF_NN_ILP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_ILP_UNCONSTR) {
            model.add(vars[v1] - vars[v2] != 0);
          }
          else if(v_order == __O_ILP_NN_UN_N || v_order == __O_ILP_VN_UN_N || v_order == __O_ILP_NN_CON_N || v_order == __O_ILP_VN_CON_N) {
            model.add(vars[v1] - vars[v2] != 0);
          }
          else {
            model.add(vars[v1] - vars[v2] >= 1 || vars[v1] - vars[v2] <= 1);
          }
        }
      }
      cerr << "... done" << endl;

      cerr << "Adding the function to the model... ";
      model.add(IloMinimize(env, obj_fun));
      cerr << "... done" << endl;

      cerr << "Constructing the cplex ";
      IloCplex cplex(model);
      cerr << "... done" << endl;

      cerr << "Solving ";
      int ret_val = cplex.solve();
      cerr << "... done" << endl;

      if ( !ret_val ) {
        env.error() << "Failed to optimize LP." << endl;
        throw(-1);
      }

      cerr << "Constructing return vals ";
      IloNumArray vals(env);
      cerr << "... done" << endl;

      env.out() << "Solution status = " << cplex.getStatus() << endl;
      env.out() << "Solution value = " << cplex.getObjValue() << endl;
      cplex.getValues(vals, vars);
      env.out() << "Values = " << vals << endl;

      cerr << "####################### TESTING VALUES " << endl;
      for(v_id i = 0; i < n; ++i) {
        cerr << "### val " << i << ": " << vals[i] << endl;
      }
      cerr << "####################### DONE" << endl;

      if(v_order == OPTIMAL_DIFF_NN_LP_CONSTR || v_order == OPTIMAL_DIFF_VN_LP_CONSTR) {
        vector<bool> occupied;
        for(v_id i = 0; i < n; ++i) {
          occupied.push_back(false);
        }

        for(auto& item : *adj) {
          v_id old_v = item.first;
          assert(old_v < n && old_v >= 0);
          v_id val = round(vals[old_v]);

          if(val < 0) {
            val = 0;
          }
          if(val >= n) {
            val = n-1;
          }

          v_id spot = val;
          while(occupied[spot]) {
            ++spot;
            if(spot >= n) {
              spot = 0;
            }
          }
          occupied[spot] = true;
          (*trans)[old_v] = spot;
        }
      }
      else if(v_order == OPTIMAL_DIFF_NN_LP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_LP_UNCONSTR) {
        map<v_id, bool> occupied;

        for(auto& item : *adj) {
          v_id old_v = item.first;
          assert(old_v < n && old_v >= 0);
          v_id val = round(vals[old_v]);

          if(val < 0) {
            val = 0;
          }

          v_id spot = val;
          while(occupied.count(spot) == 1) {
            ++spot;
          }
          occupied[spot] = true;
          (*trans)[old_v] = spot;
        }
      }
      else {
        for(auto& item : *adj) {
          v_id old_v = item.first;
          (*trans)[old_v] = vals[old_v];
        }
      }
 
      if(v_order == OPTIMAL_DIFF_NN_ILP_UNCONSTR || v_order == OPTIMAL_DIFF_NN_LP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_ILP_UNCONSTR || v_order == OPTIMAL_DIFF_VN_LP_UNCONSTR ||
         v_order == __O_ILP_NN_UN_N || v_order == __O_ILP_VN_UN_N) {
        verifyNoncontiguousTranslationConsistency(trans);
      }
      else if(v_order == OPTIMAL_DIFF_NN_ILP_CONSTR || v_order == OPTIMAL_DIFF_NN_LP_CONSTR || v_order == OPTIMAL_DIFF_VN_ILP_CONSTR || v_order == OPTIMAL_DIFF_VN_LP_CONSTR ||
              v_order == __O_ILP_NN_CON_N || v_order == __O_ILP_VN_CON_N) {
        verifyTranslationConsistency(trans);
      }
    }
    catch (IloException& e) {
      cerr << "Concert exception caught: " << e << endl;
      for(auto& item : *adj) {
        (*trans)[item.first] = item.first;
      }

      verifyTranslationConsistency(trans);
      return trans;
    }
    catch (...) {
      cerr << "Unknown exception caught" << endl;
      for(auto& item : *adj) {
        (*trans)[item.first] = item.first;
      }

      verifyTranslationConsistency(trans);
      return trans;
    }
    env.end();

    return trans;
  }

  else if(v_order == DEGREE_HIGH_TO_LOW) {
    TradAdj<v_id>* t_adj = t->adj_;
    multimap<v_id, v_id>* sorted_vertices = new multimap<v_id, v_id>();

    // First, get the vertices sorted by their degrees.
    // We use a multimap for this.
    for(auto& item: *t_adj) {
      v_id v = item.first;
      v_id v_deg = item.second.size();
      sorted_vertices->insert(pair<v_id, v_id>(v_deg, v));
    }

    //TODO: get rid of this structure
    map<v_id, v_id>* trans = new map<v_id, v_id>();  
    v_id new_v = 0;
    for(auto& item : *sorted_vertices) {
      (*trans)[item.second] = new_v++;
    }

    delete sorted_vertices;
    verifyTranslationConsistency(trans);
    return trans;
  }
  else {
    assert(false);
    return NULL;
  }
}

TradListGraphR* RecPermuter::permute(const SimpleRecGraphR* r, const TradListGraphR* t, VertexOrder vOrder) {
  map<v_id, v_id>* trans = generateHelperPermutationStr(r, t, vOrder);

  //TODO: make sure (in some loading class) that these adj vectors are actually sorted
  TradAdj<v_id>* t_adj = t->adj_;
  TradAdj<v_id>* n_adj = new TradAdj<v_id>();

  //TODO: make these vectors actual pointers to vectors?
  if(vOrder == INORDER) {
    for(auto& item: *t_adj) {
      v_id v1 = item.first;
      vector<v_id>* neighs = &(item.second);
      vector<v_id> new_neighs;
      for(auto& v2: *neighs) {
        new_neighs.push_back((*trans)[v2]);
      }
      sort(new_neighs.begin(), new_neighs.end());
      (*n_adj)[(*trans)[v1]] = new_neighs;
    }
  }
  else if (vOrder == DEGREE_HIGH_TO_LOW) {
    for(auto& item: *t_adj) {
      v_id v1 = item.first;
      vector<v_id>* neighs = &(item.second);
      vector<v_id> new_neighs;
      for(auto& v2: *neighs) {
        new_neighs.push_back((*trans)[v2]);
      }
      sort(new_neighs.begin(), new_neighs.end());
      (*n_adj)[(*trans)[v1]] = new_neighs;
    }
  }
  else if (vOrder == NO_CHANGES) {
    for(auto& item: *t_adj) {
      v_id v1 = item.first;
      vector<v_id> new_neighs = item.second;
      sort(new_neighs.begin(), new_neighs.end());
      (*n_adj)[v1] = new_neighs;
    }
  }
  else if(vOrder == OPTIMAL_DIFF_NN_ILP_UNCONSTR || vOrder == OPTIMAL_DIFF_NN_LP_UNCONSTR || vOrder == OPTIMAL_DIFF_NN_ILP_CONSTR || vOrder == OPTIMAL_DIFF_NN_LP_CONSTR || 
      vOrder == OPTIMAL_DIFF_VN_ILP_UNCONSTR || vOrder == OPTIMAL_DIFF_VN_LP_UNCONSTR || vOrder == OPTIMAL_DIFF_VN_ILP_CONSTR || vOrder == OPTIMAL_DIFF_VN_LP_CONSTR ||
      vOrder == __O_ILP_NN_UN_N || vOrder == __O_ILP_VN_UN_N || vOrder == __O_ILP_NN_CON_N || vOrder == __O_ILP_VN_CON_N) {
    for(auto& item: *t_adj) {
      v_id v1 = item.first;
      vector<v_id>* neighs = &(item.second);
      vector<v_id> new_neighs;
      for(auto& v2: *neighs) {
        new_neighs.push_back((*trans)[v2]);
      }
      sort(new_neighs.begin(), new_neighs.end());
      (*n_adj)[(*trans)[v1]] = new_neighs;
    }
  }
  else {
    assert(false);
  }

  delete trans;
  verifyPermutationConsistency(n_adj);
  TradListGraphR* permuted_rep = new TradListGraphR(t->n_, t->m_, n_adj);
  return permuted_rep;
}

// not working? verify
MetisR* RecPermuter::permute(const SimpleRecGraphR* r, const MetisR* t, VertexOrder vOrder) {
  map<v_id, v_id>* trans = generateHelperPermutationStr(r, t, vOrder);
  verifyTranslationConsistency(trans);

  //TODO: make sure (in some loading class) that these adj vectors are actually sorted
  idx_t* xadj = t->xadj_;
  idx_t* adjncy = t->adjncy_;

  idx_t* n_xadj = new idx_t[t->n_+1]();
  idx_t* n_adjncy = new idx_t[2*t->m_]();
  std::fill_n(n_xadj, t->n_+1, -1);
  std::fill_n(n_adjncy, 2*t->m_, -1);

  if(vOrder == INORDER) {
    idx_t* temp = new idx_t[t->n_];
    std::fill_n(temp, t->n_, -1);
    v_id trans_v1 = -1;
    v_id trans_v2 = -1;

    // First,fill in the temp array with numbers of neighbors
    for(v_id v1 = 0; v1 < t->n_; ++v1) {
      trans_v1 = (*trans)[v1];
      temp[trans_v1] = xadj[v1+1]-xadj[v1];
    }

    // Now, construct the new xadj array
    n_xadj[0] = 0;
    for(v_id v1 = 0; v1 < t->n_; ++v1) {
      n_xadj[v1+1] = n_xadj[v1]+temp[v1];
    }

    // Finally, construct the new adjncy list
    for(v_id v1 = 0; v1 < t->n_; ++v1) {
      trans_v1 = (*trans)[v1];
      vector<idx_t> new_neighs;
      for(v_id v2 = xadj[v1]; v2 < xadj[v1+1]; ++v2) {
        trans_v2 = (*trans)[adjncy[v2]];
        new_neighs.push_back(trans_v2);
      }
      sort(new_neighs.begin(), new_neighs.end());
      idx_t cnt = 0;
      for(v_id p = n_xadj[trans_v1]; p < n_xadj[trans_v1+1]; ++p) {
        n_adjncy[p] = new_neighs[cnt++];
      }
      //idx_t cnt = n_xadj[trans_v1];
      //for(v_id trans_v2 : new_neighs) {
      //  n_adjncy[cnt++] = trans_v2;
      //}
    }
    delete [] temp;
  }
  else if (vOrder == NO_CHANGES) {
    for(v_id v = 0; v <= t->n_; ++v) {
      n_xadj[v] = xadj[v];
    }
    for(v_id v = 0; v < 2*t->m_; ++v) {
      n_adjncy[v] = adjncy[v];
    }
  }
  else {
    assert(false);
  }

  delete trans;
  MetisR* representation = new MetisR(n_xadj, n_adjncy, t->n_, t->m_);
  verifyPermutationConsistency(representation);
  return representation;
}

void RecPermuter::verifyTranslationConsistency(const map<v_id, v_id>* trans) {
  cerr << ">>> Verifying " << endl;
  v_id n = trans->size();
  v_id* numbers = new v_id[n]();

  int64_t prev_v1 = -1;
  int64_t v1 = -1, v2 = -1;
  for(auto& item: *trans) {
    v1 = item.first;
    v2 = item.second;
    //cerr << "  > v2: " << v2 << endl;
    assert(prev_v1+1 == v1);
    assert(v1 >= 0 && v1 < n);
    assert(v2 >= 0 && v2 < n);

    ++numbers[v2];
    prev_v1 = v1;
  }

  for(v_id v = 0; v < n; v++) {
    assert(numbers[v] == 1);
  }

  delete [] numbers;
}

void RecPermuter::verifyNoncontiguousTranslationConsistency(const map<v_id, v_id>* trans) {
  v_id n = trans->size();
  v_id* numbers = new v_id[n]();

  int64_t v1 = -1, v2 = -1;
  for(auto& item: *trans) {
    v1 = item.first;
    v2 = item.second;
    assert(v1 >= 0 && v1 < n);
    assert(v2 >= 0 && v2 < n);

    ++numbers[v2];
  }

  for(v_id v = 0; v < n; v++) {
    assert(numbers[v] == 1);
  }

  delete [] numbers;
}


void RecPermuter::verifyPermutationConsistency(const TradAdj<v_id>* n_adj) {
  assert(n_adj != NULL); //avoid warnings
  // TODO
}

void RecPermuter::verifyPermutationConsistency(const MetisR* n_adj) {
  assert(n_adj != NULL); //avoid warnings
  // TODO
}
