#if !defined(__RECPERMUTER_H__)
#define      __RECPERMUTER_H__

#include "globals.h"
#include "utils/debug.h"
#include "representations/misc.h"
#include "representations/metisR.h"
#include "representations/tradListGraphR.h"

#include <ilcplex/ilocplex.h>
ILOSTLBEGIN

class RecPermuter {
  public:
    RecPermuter() {}
    ~RecPermuter() {}

    TradListGraphR* permute(const SimpleRecGraphR* r, const TradListGraphR* t, VertexOrder vOrder);
    MetisR* permute(const SimpleRecGraphR* r, const MetisR* t, VertexOrder vOrder);
 
  private:
    map<v_id, v_id>* generateHelperPermutationStr(const SimpleRecGraphR* r, const TradListGraphR* t, VertexOrder v_order);
    map<v_id, v_id>* generateHelperPermutationStr(const SimpleRecGraphR* r, const MetisR* t, VertexOrder v_order);
    void verifyPermutationConsistency(const TradAdj<v_id>* t);
    void verifyPermutationConsistency(const MetisR* r);
    void verifyTranslationConsistency(const map<v_id, v_id>* trans);
    void verifyNoncontiguousTranslationConsistency(const map<v_id, v_id>* trans);
};

#endif
