#include "diffAnalysis.h"

void getSumOfDifferences(const TradListGraphR* t, v_id* sum_all_neighbors_out, v_id* sum_first_neighbors_out) {
  TradAdj<v_id>* n_adj = t->adj_;
  v_id sum_all_neighbors = 0;
  v_id sum_first_neighbors = 0;

  for(const auto& item : *n_adj) {
    v_id v = item.first;
    const vector<v_id>* neighbors = &(item.second);

    bool first_neighbor = true;
    for(v_id i = 0; i < (v_id)(neighbors->size()); ++i) {
      if(first_neighbor) {
        sum_first_neighbors += abs(v - (*neighbors)[i]);
        first_neighbor = false;
        continue;
      }

      assert((*neighbors)[i] > (*neighbors)[i-1]);
      sum_all_neighbors += (*neighbors)[i] - (*neighbors)[i-1];
    }
  }

  *sum_all_neighbors_out = sum_all_neighbors;
  *sum_first_neighbors_out = sum_first_neighbors;
}

void getSumOfDifferences(const TradListGraphR* t, double* sum_all_neighbors_out, double* sum_first_neighbors_out) {
  v_id val_1 = -1;
  v_id val_2 = -1;
  getSumOfDifferences(t, &val_1, &val_2);
  *sum_all_neighbors_out = (double)val_1;
  *sum_first_neighbors_out = (double)val_2;
}

void getSizeOfBitRepInBytes(const TradListGraphR* t, v_id* sum_all_neighbors_out, v_id* sum_first_neighbors_out) {
  __UNUSED(t); __UNUSED(sum_all_neighbors_out); __UNUSED(sum_first_neighbors_out);
/*  TradAdj<v_id>* n_adj = t->adj_;
  n_ = t->n_;
  m_ = t->m_;
  prefix_len_ = (*r)[0]->length();

  uint64_t itr = 0;
  uint64_t unused_bits = 0;
  uint64_t unused_bits_neighbors = 0;
  uint64_t unused_bits_signs = 0;
  uint64_t unused_bits_edges = 0;

  unsigned char* faked = new unsigned char[1024]();

  for(const auto& item : *n_adj) {
    v_id v = item.first;
    string* v_rec = (*r)[v];
    v_id v_deg = item.second.size();

    // first, get the size of the number of neighbors
    itr += toVarint(v_deg, &faked[0], &unused_bits);
    unused_bits_neighbors += unused_bits;

    map<v_id, vector<v_id> >* prefixes_lengths = new map<v_id, vector<v_id> >();

    for(const auto& n: item.second) {
      string* n_rec = (*r)[n];
      string prefix = commonPrefix(v_rec, n_rec);
      int  prefix_len = prefix.size();
      (*prefixes_lengths)[prefix_len].push_back(n);
    }

    v_id __neighbors = 0;
    for(const auto& item: *prefixes_lengths) {
      int prefix_len = item.first;
      vector<v_id> neighbors = item.second;
      assert(neighbors.size() > 0);

      string prefix = (*r)[neighbors[0]]->substr(0, prefix_len);

      // Encode the length of the prefix [bits]
      assert(prefix_len <= MAX_RECURSIVE_PREFIX_LEN);
      new_adj_data[itr++] = (unsigned char)(prefix_len);
      // TODO: verify log
      int add_bits = BITS_IN_BYTE - ((int)log2(prefix_len)+1);
      unused_bits_edges += add_bits;
      assert(add_bits >= 0 && add_bits < BITS_IN_BYTE);

      // Encode the number of neighbors with this prefix
      itr += toVarint(neighbors.size(), &new_adj_data[itr], &unused_bits);
      unused_bits_edges += unused_bits;

      // Encode the prefix
      int bit_nr = 0;
      //uint64_t* curr_addr = (uint64_t*)(&new_adj_data[itr]);
      for(char bit : prefix) {
        int bit_val = bit - '0';
        if(bit_val == 0) {
          new_adj_data[itr] &= ~(1 << bit_nr);
        }
        else if(bit_val == 1) {
          new_adj_data[itr] |= 1 << bit_nr;
        }
        else {
          assert(false);
        }
        // *itr ^= (-bit_val ^ *itr) & (1 << bit_nr);
        ++bit_nr;
        if(bit_nr == BITS_IN_BYTE) {
          ++itr;
          bit_nr = 0;
        }
      }

      // Encode the neighbors
      for(const auto& n: neighbors) {
        string n_rec = *((*r)[n]);
        n_rec.erase(0, prefix.size());

        for(char bit : n_rec) {
          int bit_val = bit - '0';
          if(bit_val == 0) {
            new_adj_data[itr] &= ~(1 << bit_nr);
          }
          else if(bit_val == 1) {
            new_adj_data[itr] |= 1 << bit_nr;
          }
          else {
            assert(false);
          }
          // *itr ^= (-bit_val ^ *itr) & (1 << bit_nr);
          ++bit_nr;
          if(bit_nr == BITS_IN_BYTE) {
            ++itr;
            bit_nr = 0;
          }
        }
        __neighbors++;
      }

      if(bit_nr != BITS_IN_BYTE) {
        ++itr;
        unused_bits_edges += (BITS_IN_BYTE - bit_nr);
      }
    }
    delete prefixes_lengths;
  }

  // TODO: make it always work. Now it may actually fail, if
  // we don't use enough space a priori
  assert(new_adj_data_size_in_bytes > itr);

  adj_data_size_info_ = new AdjDataSizeInfo();
  adj_data_size_info_->adj_data_total_size_in_bytes_ = itr;
  adj_data_size_info_->adj_data_total_redundancy_in_bytes_ = ceil((unused_bits_edges + unused_bits_signs + unused_bits_neighbors) / 8.0);
  adj_data_size_info_->adj_data_edges_redundancy_in_bytes_ = ceil(unused_bits_edges / 8.0);
  adj_data_size_info_->adj_data_signs_redundancy_in_bytes_ = ceil(unused_bits_signs / 8.0);
  adj_data_size_info_->adj_data_neighbors_redundancy_in_bytes_ = ceil(unused_bits_neighbors / 8.0);

  adj_data_ = new unsigned char[itr]();
  memcpy(&adj_data_[0], &new_adj_data[0], itr);
  delete [] new_adj_data;
  *offsets_out = offsets;*/
}


void verifySimpleRecGraphR(SimpleRecGraphR* r) {
  int elem_0_len = (*r)[0]->length();

  map<string, int> counts;

  for(const auto& item : *r) {
    //v_id v = item.first;
    string* s = item.second;
    assert(elem_0_len == (int)s->length());
    for(auto& bit : *s) {
      assert(bit == '0' || bit == '1');
    }

    if(counts.count(*s) > 0) {
      counts[*s] += 1;
    }
    else {
      counts[*s] = 1;
    }
  }

  for(const auto& elem: counts) {
    assert(elem.second == 1);
  }

  /* old, slow way (but working)
     for(const auto& item : *r) {
     v_id v = item.first;
     string* s = item.second;
     assert(elem_0_len == (int)s->length());
     for(auto& bit : *s) {
     assert(bit == '0' || bit == '1');
     }

     for(const auto& item2: *r) {
     v_id v2 = item2.first;
     string* s2 = item2.second;
     if(v == v2) {
     continue;
     }

     assert(s->compare(*s2) != 0);
     }
     }*/
}

void verifyContiguousTradListGraphR(const TradListGraphR* t) {
  TradAdj<v_id>* adj = t->adj_;
  v_id n = 0;
  v_id m = 0;

  v_id N = t->adj_->size();

  for(const auto& item : *adj) {
    v_id v = item.first;
    assert(v == n);
    ++n;

    const vector<v_id>* neighbors = &(item.second);
    map<v_id, int> counts;

    for(int i = 0; i < (int)neighbors->size(); ++i) {
      ++m;
      v_id neighbor = (*neighbors)[i];

      assert(neighbor < N);

      if(i > 0) {
        assert((*neighbors)[i] > (*neighbors)[i-1]);
      }

      if(counts.count(neighbor) > 0) {
        counts[neighbor] += 1;
      }
      else {
        counts[neighbor] = 1;
      }

      for(const auto& elem: counts) {
        assert(elem.second == 1);
      }
    }
  }



  /* slow, working
     for(const auto& item : *adj) {
     const vector<v_id>* neighbors = &(item.second);

     ++n;

     for(int i = 0; i < (int)neighbors->size(); ++i) {
     ++m;
     for(int j = 0; j < (int)neighbors->size(); ++j) {
     if(i == j) {
     continue;
     }
     assert((*neighbors)[i] != (*neighbors)[j]);
     }
     }
     }
   */

  assert(n == t->n_);
  assert(m == 2*t->m_);
}


void verifyTradListGraphR(const TradListGraphR* t) {
  TradAdj<v_id>* adj = t->adj_;
  v_id n = 0;
  v_id m = 0;

  bool first = true;
  v_id prev_v = -1;

  for(const auto& item : *adj) {
    const vector<v_id>* neighbors = &(item.second);
    ++n;

    v_id v = item.first;

    if(first) {
      first = false;
    }
    else {
      assert(v > prev_v);
      prev_v = v;
    }

    map<v_id, int> counts;

    for(int i = 0; i < (int)neighbors->size(); ++i) {
      ++m;
      v_id neighbor = (*neighbors)[i];

      if(i > 0) {
        assert((*neighbors)[i] > (*neighbors)[i-1]);
      }

      if(counts.count(neighbor) > 0) {
        counts[neighbor] += 1;
      }
      else {
        counts[neighbor] = 1;
      }

      for(const auto& elem: counts) {
        assert(elem.second == 1);
      }
    }
  }

  /* slow, working
     for(const auto& item : *adj) {
     const vector<v_id>* neighbors = &(item.second);

     ++n;

     for(int i = 0; i < (int)neighbors->size(); ++i) {
     ++m;
     for(int j = 0; j < (int)neighbors->size(); ++j) {
     if(i == j) {
     continue;
     }
     assert((*neighbors)[i] != (*neighbors)[j]);
     }
     }
     }
   */

  assert(n == t->n_);
  assert(m == 2*t->m_);
}

/* Works (but no tests yet). The resulting adj list is not contiguous.
TradListGraphR* convertSimpleRecToTradList(SimpleRecGraphR* r, const TradListGraphR* t) {
  TradAdj<v_id>* adj = new TradAdj<v_id>();
  v_id n = 0;
  v_id m = 0;
  int elem_0_len = (*r)[0]->length();

  for(const auto& item: *(t->adj_)) {
    ++n;
    v_id v = item.first;
    string* s = (*r)[v];
    assert(elem_0_len == (int)s->length());
    v_id R_v = binToDec(s);

    for(const auto& n: item.second) {
      (*adj)[R_v].push_back(binToDec((*r)[n]));
      ++m;
    }
    sort((*adj)[R_v].begin(), (*adj)[R_v].end());
  }

  assert(n == t->n_);
  assert(m == 2*t->m_);

  TradListGraphR* new_rep = new TradListGraphR(n,m / 2,adj);
  return new_rep;
}
*/

TradListGraphR* convertSimpleRecToContiguousTradList(SimpleRecGraphR* r, const TradListGraphR* t) {
  TradAdj<v_id>* adj = new TradAdj<v_id>();
  v_id n = 0;
  v_id m = 0;
  int elem_0_len = (*r)[0]->length();

  map<v_id, v_id> mapping;

  for(const auto& item: *(t->adj_)) {
    v_id v = item.first;
    string* s = (*r)[v];
    assert(elem_0_len == (int)s->length());
    v_id R_v = binToDec(s);
    mapping[R_v] = n;
    ++n;
  }

  for(const auto& item: *(t->adj_)) {
    v_id v = item.first;
    string* s = (*r)[v];
    assert(elem_0_len == (int)s->length());
    v_id R_v = binToDec(s);

    for(const auto& neighbor: item.second) {
      (*adj)[mapping[R_v]].push_back(mapping[binToDec((*r)[neighbor])]);
      ++m;
    }
    sort((*adj)[mapping[R_v]].begin(), (*adj)[mapping[R_v]].end());
  }

  assert(n == t->n_);
  assert(m == 2*t->m_);

  TradListGraphR* new_rep = new TradListGraphR(n,m / 2,adj);
  return new_rep;
}


TradListGraphR* convertSimpleRecToTradList(SimpleRecGraphR* r, const TradListGraphR* t) {
  TradAdj<v_id>* adj = new TradAdj<v_id>();
  v_id n = 0;
  v_id m = 0;
  int elem_0_len = (*r)[0]->length();

  for(const auto& item: *(t->adj_)) {
    ++n;
    v_id v = item.first;
    string* s = (*r)[v];
    assert(elem_0_len == (int)s->length());
    v_id R_v = binToDec(s);

    for(const auto& n: item.second) {
      (*adj)[R_v].push_back(binToDec((*r)[n]));
      ++m;
    }
    sort((*adj)[R_v].begin(), (*adj)[R_v].end());
  }

  assert(n == t->n_);
  assert(m == 2*t->m_);

  TradListGraphR* new_rep = new TradListGraphR(n,m / 2,adj);
  return new_rep;
}

SimpleRecGraphR* convertTradListToSimpleRec(const TradListGraphR* t) {
  SimpleRecGraphR* r = new SimpleRecGraphR();

  int len = ceil(log2(t->n_));

  for(const auto& item: *(t->adj_)) {
    v_id v = item.first;
    string* s = new string(decToBin(v, len));
    (*r)[v] = s;
  }
  return r;
}

