#if !defined(__DIFF_ANALYSIS_H__)
#define      __DIFF_ANALYSIS_H__

#include "globals.h"
#include "representations/tradListGraphR.h"
#include "representations/misc.h"
#include "utils/convert.h"

using namespace std;

void getSumOfDifferences(const TradListGraphR* t, v_id* sum_all_neighbors_out, v_id* sum_first_neighbors_out);
void getSumOfDifferences(const TradListGraphR* t, double* sum_all_neighbors_out, double* sum_first_neighbors_out);

// TODO: make it const.
void verifySimpleRecGraphR(SimpleRecGraphR* r);
void verifyTradListGraphR(const TradListGraphR* t);
void verifyContiguousTradListGraphR(const TradListGraphR* t);
TradListGraphR* convertSimpleRecToTradList(SimpleRecGraphR* r, const TradListGraphR* t);
TradListGraphR* convertSimpleRecToContiguousTradList(SimpleRecGraphR* r, const TradListGraphR* t);
SimpleRecGraphR* convertTradListToSimpleRec(const TradListGraphR* t);

#endif
