#include "metisR.h"

MetisR::MetisR(TradListGraphR* g) {
  construct(g);
}

MetisR::MetisR(idx_t* xadj, idx_t* adjncy, idx_t n, idx_t m) {
  this->xadj_ = xadj;
  this->adjncy_ = adjncy;
  this->n_ = n;
  this->m_ = m;
}

MetisR::MetisR(idx_t* xadj, idx_t* adjncy) {
  this->xadj_ = xadj;
  this->adjncy_ = adjncy;
}

MetisR::MetisR() {}

MetisR::~MetisR() {
  delete [] xadj_;
  delete [] adjncy_;
}

/*
uint64_t MetisR::adj_data_total_size_in_bytes() {
  return (2*m_)*sizeof(idx_t);
}

uint64_t MetisR::offsets_total_size_in_bytes() {
  return (n_+1)*sizeof(idx_t);
}*/

void MetisR::checkConsistency() {
  for(idx_t u = 0; u < n_; u++) {
    idx_t val = xadj_[u];
    idx_t next_val = xadj_[u+1];
    assert(next_val >= val);
    assert(val >= 0 && next_val >= 0);
    for(idx_t pos = val+1; pos < next_val; ++pos) {
      assert(adjncy_[pos] > adjncy_[pos-1]);
    }
  }

  for(idx_t u = 0; u < 2*m_; ++u) {
    assert(adjncy_[u] >= 0);
  }
}

/*
v_id MetisR::getVertexDegree(v_id v) {
  return xadj_[v+1] - xadj_[v];
}

v_id* MetisR::getVertexNeighborsAndDegree(v_id v, v_id* nr_neighs_out) {
  v_id deg = xadj_[v+1] - xadj_[v];
  *nr_neighs_out = deg;
  v_id* neighs = new v_id[deg]();
  memcpy(&neighs[0], &(adjncy_[xadj_[v]]), deg * sizeof(idx_t));
  return neighs;
}*/

/* TODO: make sure somewhere else that the input adj is contiguous */
void MetisR::construct(TradListGraphR* g) {
  n_ = g->n_;
  m_ = g->m_;

  TradAdj<v_id>* adj = g->adj_;

  xadj_ = new idx_t[n_+1];
  xadj_[0] = 0;

  adjncy_ = new idx_t[2*m_];

  idx_t curr_v = 0;
  idx_t e_processed = 0;

  for(auto& pair : *adj) {
    idx_t v = pair.first;
    std::vector<v_id>* neighS = &(pair.second);

    assert(curr_v++ == v);  // assert that the labels are contiguous
    assert((idx_t)neighS->size() >= 0 && (idx_t)neighS->size() < n_);

    xadj_[1+v] = xadj_[v] + (idx_t)(neighS->size());

    for(idx_t neigh: *neighS) {
      adjncy_[e_processed++] = neigh;
    }
  }
  assert(e_processed == 2*m_);
  checkConsistency();
}

