#if !defined(__METIS_R_H__)
#define      __METIS_R_H__

#include "metis.h"
#include "globals.h"
#include "representations/graphR.h"
#include "representations/tradListGraphR.h"

class MetisR : public GraphR {
 public:
  MetisR(idx_t* xadj, idx_t* adjncy, idx_t n, idx_t m);
  MetisR(idx_t* xadj, idx_t* adjncy);
  MetisR(TradListGraphR* g);
  MetisR();
  ~MetisR();

  void checkConsistency();
  inline uint64_t adj_data_total_size_in_bytes();
  inline uint64_t offsets_total_size_in_bytes();

  idx_t* xadj_ = NULL;
  idx_t* adjncy_ = NULL;

  inline v_id getVertexDegree(v_id v) __attribute__((always_inline));
  inline v_id* getVertexNeighborsAndDegree(v_id v, v_id* nr_neighs_out) __attribute__((always_inline));

 private:
  void construct(TradListGraphR* g);
};

uint64_t MetisR::adj_data_total_size_in_bytes() {
    return (2*m_)*sizeof(idx_t);
}

uint64_t MetisR::offsets_total_size_in_bytes() {
    return (n_+1)*sizeof(idx_t);
}

v_id MetisR::getVertexDegree(v_id v) {
    return xadj_[v+1] - xadj_[v];
}

v_id* MetisR::getVertexNeighborsAndDegree(v_id v, v_id* nr_neighs_out) {
    v_id deg = xadj_[v+1] - xadj_[v];
      *nr_neighs_out = deg;
        v_id* neighs = new v_id[deg]();
          memcpy(&neighs[0], &(adjncy_[xadj_[v]]), deg * sizeof(idx_t));
            return neighs;
}

#endif
