#if !defined(__MISC_H__)
#define      __MISC_H__

#include "metis.h"
#include "globals.h"
#include "utils/debug.h"

using namespace std;

typedef map< v_id, string* > SimpleRecGraphR; 
typedef map< string, v_id > SimpleRecGraphRRev; 
typedef std::map<int, std::vector<v_id>* > CutResults;

const int BIS_PARTS = 2;
const int LEFT = 0;
const int RIGHT = 1;

enum VarIntEncodingType {
  VARINT,
  GROUP_VARINT,
  NO_VARINT_ENCODING
};

enum DiffEncodingType {
  ELIAS_GAMMA,
  ELIAS_DELTA,
  NO_DIFF_ENCODING
};

enum VertexOrder {
  INORDER,
  NO_CHANGES,
  DEGREE_HIGH_TO_LOW,
  OPTIMAL_DIFF_NN_ILP_UNCONSTR,
  OPTIMAL_DIFF_NN_ILP_CONSTR,
  OPTIMAL_DIFF_NN_LP_UNCONSTR,
  OPTIMAL_DIFF_NN_LP_CONSTR,
  OPTIMAL_DIFF_VN_ILP_UNCONSTR,
  OPTIMAL_DIFF_VN_ILP_CONSTR,
  OPTIMAL_DIFF_VN_LP_UNCONSTR,
  OPTIMAL_DIFF_VN_LP_CONSTR,
  __O_ILP_NN_UN_N,
  __O_ILP_VN_UN_N,
  __O_ILP_NN_CON_N,
  __O_ILP_VN_CON_N
};

enum AdjListOffsetsType {
  STANDARD_PTRS,
  BITVECTOR_PLAIN,
  BITVECTOR_IL,
  BITVECTOR_RRR,
  BITVECTOR_SD,
  BITVECTOR_HYB
};

enum CutType {
  EDGE_CUT,
  VERTEX_CUT
};

enum PartitioningType {
  METIS_PARTITIONING,
  METIS_PARTITIONING_MULTITHREADED
};

double inline bytesToMB(uint64_t bytes) __attribute__((always_inline));

double inline bytesToMB(uint64_t bytes) {
  return (bytes / (1.0*TWO_POW_20));
}

#endif
