#if !defined(__TRAD_ARRAY_DIST_G500_GRAPH_H__)
#define      __TRAD_ARRAY_DIST_G500_GRAPH_H__

#ifdef __XGRAPH_DIST__

#include <mpi.h>

#include "globals.h"
#include "utils/debug.h"
#include "representations/graphR.h"
#include "representations/external_generators/g500_rmat/common.h"
#include "representations/external_generators/g500_rmat/oned_csr.h"

#include <math.h>
#include <mpi.h>
#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <limits.h>
#include <stdint.h>
#include <inttypes.h>

using namespace std;

//TODO: detach this class from the vertex distribution method.

class TradArrayDistG500GraphR : public GraphR {
  public:
    TradArrayDistG500GraphR(v_id SCALE, v_id edgefactor, int loading_rank, MPI_Comm comm);
    ~TradArrayDistG500GraphR();

    inline v_id getVertexGlobalID(int _g500_rank, v_id v_local_id) __attribute__((always_inline));
    inline v_id getVertexLocalID(v_id v_global_id) __attribute__((always_inline));
    inline int  getVertexOwningRank(v_id v_global_id) __attribute__((always_inline));

    inline v_id getLocalVertexDegree(v_id v_local_id) __attribute__((always_inline));
    //inline v_id getVertexDegree(v_id v_global_id) __attribute__((always_inline));
    //inline v_id getVertexWindowOffset(v_id v_global_id) __attribute__((always_inline));

    void configureParameters(MPI_Comm comm, v_id n, v_id m);
    void loadAndDistributeGraphFromMemory(int loading_rank);

    inline uint64_t adj_data_total_size_in_bytes();
    inline uint64_t offsets_total_size_in_bytes();

    v_id* offsets_local_;
    v_id* adj_local_;

    v_id n_local_ = 0;
    v_id m_local_ = 0;

    int num_procs_ = 0;
    int log_of_num_procs_ = 0;
    int rank_ = 0;

    MPI_Comm comm_;
};

v_id TradArrayDistG500GraphR::getVertexGlobalID(int _g500_rank, v_id v_local_id) {
  return VERTEX_TO_GLOBAL(_g500_rank, v_local_id);
}

v_id TradArrayDistG500GraphR::getVertexLocalID(v_id v_global_id) {
  return VERTEX_LOCAL(v_global_id);
}

//TODO: It's not just 'local' degree, make sure it's just the degree?
v_id TradArrayDistG500GraphR::getLocalVertexDegree(v_id v_local_id) {
  return offsets_local_[v_local_id+1] - offsets_local_[v_local_id];
}

/*
v_id TradArrayDistG500GraphR::getVertexDegree(v_id v_global_id) {
}

v_id TradArrayDistG500GraphR::getVertexWindowOffset(v_id v_global_id) {
  return getVertexLocalID(v_global_id);
}
*/
  
int TradArrayDistG500GraphR::getVertexOwningRank(v_id v_global_id) {
  return VERTEX_OWNER(v_global_id);
}

uint64_t TradArrayDistG500GraphR::adj_data_total_size_in_bytes() {
  uint64_t size = 2*m_*sizeof(v_id) + num_procs_ * sizeof(v_id*); 
  return size;
}

uint64_t TradArrayDistG500GraphR::offsets_total_size_in_bytes() {
  uint64_t size = (n_ + num_procs_)*sizeof(v_id); 
  size += num_procs_ * sizeof(v_id*);
  return size;
}

#endif

#endif
