#if !defined(__TRAD_ARRAY_DIST_GRAPH_H__)
#define      __TRAD_ARRAY_DIST_GRAPH_H__

#ifdef __XGRAPH_DIST__

#include <mpi.h>

#include "globals.h"
#include "utils/debug.h"
#include "representations/graphR.h"

using namespace std;

//TODO: detach this class from the vertex distribution method.

class TradArrayDistGraphR : public GraphR {
  public:
    TradArrayDistGraphR(v_id n, v_id m, v_id* offsets, v_id* adj, int loading_rank, MPI_Comm comm);
    ~TradArrayDistGraphR();

    inline v_id getVertexGlobalID(v_id v_local_id, int rank) __attribute__((always_inline));
    inline v_id getVertexLocalID(v_id v_global_id) __attribute__((always_inline));
    inline int  getVertexOwningRank(v_id v_global_id) __attribute__((always_inline));

    inline v_id getLocalVertexDegree(v_id v_local_id) __attribute__((always_inline));
    //inline v_id getVertexDegree(v_id v_global_id) __attribute__((always_inline));
    //inline v_id getVertexWindowOffset(v_id v_global_id) __attribute__((always_inline));

    void configureParameters(MPI_Comm comm, v_id n, v_id m);
    void loadAndDistributeGraphFromMemory(v_id* offsets, v_id* adj, int loading_rank);

    inline uint64_t adj_data_total_size_in_bytes();
    inline uint64_t offsets_total_size_in_bytes();

    v_id* offsets_local_;
    v_id* adj_local_;

    v_id n_local_ = 0;
    v_id m_local_ = 0;

    int num_procs_ = 0;
    int log_of_num_procs_ = 0;
    int rank_ = 0;

    MPI_Comm comm_;
};

v_id TradArrayDistGraphR::getVertexGlobalID(v_id v_local_id, int rank) {
#ifdef NUM_OF_PROCS_IS_A_POWER_OF_TWO
  return ((v_id)(v_local_id << log_of_num_procs_) + rank);
#else
  return ((v_id)(v_local_id * num_procs_) + rank);
#endif
}

v_id TradArrayDistGraphR::getVertexLocalID(v_id v_global_id) {
#ifdef NUM_OF_PROCS_IS_A_POWER_OF_TWO
  return v_global_id >> log_of_num_procs_;
#else
  return v_global_id / num_procs_;
#endif
}

//TODO: It's not just 'local' degree, make sure it's just the degree?
v_id TradArrayDistGraphR::getLocalVertexDegree(v_id v_local_id) {
  return offsets_local_[v_local_id+1] - offsets_local_[v_local_id];
}

/*
v_id TradArrayDistGraphR::getVertexDegree(v_id v_global_id) {
}

v_id TradArrayDistGraphR::getVertexWindowOffset(v_id v_global_id) {
  return getVertexLocalID(v_global_id);
}
*/

int TradArrayDistGraphR::getVertexOwningRank(v_id v_global_id) {
#ifdef NUM_OF_PROCS_IS_A_POWER_OF_TWO
  return (v_global_id & (((int)1 << log_of_num_procs_) - 1));
#else
  return (v_global_id % num_procs_);
#endif
}

uint64_t TradArrayDistGraphR::adj_data_total_size_in_bytes() {
  uint64_t size = 2*m_*sizeof(v_id) + num_procs_ * sizeof(v_id*); 
  return size;
}

uint64_t TradArrayDistGraphR::offsets_total_size_in_bytes() {
  uint64_t size = (n_ + num_procs_)*sizeof(v_id); 
  size += num_procs_ * sizeof(v_id*);
  return size;
}

#endif

#endif
