#if !defined(__TRAD_ARRAY_GRAPH_H__)
#define      __TRAD_ARRAY_GRAPH_H__

#include "globals.h"
#include "representations/graphR.h"

using namespace std;

class TradArrayGraphR : public GraphR {
  public:
    TradArrayGraphR(v_id n, v_id m);
    TradArrayGraphR(v_id n, v_id m, v_id* offsets, v_id* adj);
    ~TradArrayGraphR();

    inline uint64_t adj_data_total_size_in_bytes();
    inline uint64_t offsets_total_size_in_bytes();

    v_id* offsets_;
    v_id* adj_;
};

uint64_t TradArrayGraphR::adj_data_total_size_in_bytes() {
  uint64_t size = 0;

  //TODO: this size is not exactly the size of the map structure
  //but rather the size of the ``ideal'' adj list
  //maybe change it to reflect the exact size? Or better - improve
  //the structure from map to a better optimized simple adj list

  size = n_*sizeof(v_id); //size of the fields that say the size of each list
  size += 2*m_*sizeof(v_id); //size of actual lists
  return size;
}

uint64_t TradArrayGraphR::offsets_total_size_in_bytes() {
  uint64_t size = 0;

  //TODO: this size is not exactly the size of the map structure
  //but rather the size of the ``ideal'' adj list
  //maybe change it to reflect the exact size? Or better - improve
  //the structure from map to a better optimized simple adj list

  size = n_*sizeof(v_id*); //size of pointers
  size += sizeof(v_id**); //size of the main pointer
  return size;
}

#endif
