#include "tradArrayLocalityAwareNoDegGraphR.h"

TradArrayLocalityAwareNoDegGraphR::TradArrayLocalityAwareNoDegGraphR(TradArrayNoDegGraphR* G, int num_threads) : GraphR(G->n_,G->m_) {
  num_threads_ = num_threads;
  adj_local_ = new v_id*[num_threads_]();
  offsets_local_ = new v_id*[num_threads]();
  adj_remote_ = new v_id*[num_threads_]();
  offsets_remote_ = new v_id*[num_threads]();

  //std_graph = G;

  v_id* offsets = G->offsets_;
  v_id* adj = G->adj_;

  n_ = G->n_;
  m_ = G->m_;

  v_id n = n_;
  v_id m = m_;

#ifdef NUM_OF_THREADS_PER_NODE_IS_A_POWER_OF_TWO
  if((num_threads_ & (num_threads_ - 1)) != 0) {
    exitMsg("The number of threads should be a power of two! (" << num_threads_ << ")" << endl);
  }

  for(log_of_num_threads_ = 0; log_of_num_threads_ < num_threads_; ++log_of_num_threads_) {
    if((1 << log_of_num_threads_) == num_threads_) break;
  }
  assert (log_of_num_threads_ < num_threads_);
#endif

  //TODO: warning! This code is specific to the cyclic distribution!

  n_local_ = new v_id[num_threads_]();
  m_local_ = new v_id[num_threads_]();
  m_remote_ = new v_id[num_threads_]();

  for(v_id v = 0; v < n; ++v) {
    int owner = getVertexOwningThread(v);
    ++n_local_[owner];

    v_id offset = offsets[v];
    v_id deg = offsets[v+1] - offsets[v];
    for(v_id e = 0; e < deg; ++e) {
      v_id neigh = adj[offset + e];
      int neigh_owner = getVertexOwningThread(neigh);
      if(neigh_owner == owner) {
        ++m_local_[owner];
      }
      else {
        ++m_remote_[owner];
      }
    }
  }

#ifdef __XGRAPH_DEBUGGING__
  v_id _m = 0;
  v_id _n = 0;
  for(int t = 0; t < num_threads; ++t) {
    _m += m_local_[t];
    _m += m_remote_[t];
    _n += n_local_[t];
  }

  assert(_m == 2*m);
  assert(_n == n);
#endif

  v_id* adj_local_pos = new v_id[num_threads]();
  v_id* adj_remote_pos = new v_id[num_threads]();

  for(int t = 0; t < num_threads_; ++t) {
    offsets_local_[t] = new v_id[n_local_[t] + 1]();
    offsets_remote_[t] = new v_id[n_local_[t] + 1]();
    adj_local_[t] = new v_id[m_local_[t]]();
    adj_remote_[t] = new v_id[m_remote_[t]]();
  }

  v_id* prev_v = new v_id[num_threads]();
  bool* first_itr = new bool[num_threads]();
  for(int i = 0; i < num_threads; ++i) {
    first_itr[i] = true;
  }

  for(v_id v = 0; v < n; ++v) {
    int owner = getVertexOwningThread(v);
    v_id offset = offsets[v];
    v_id deg = offsets[v+1] - offsets[v];
    v_id v_local_id = getVertexLocalID(v);

    //cout << "v: " << v << ", owner: " << owner << ", local id: " << v_local_id << endl;

    if(first_itr[owner]) {
      first_itr[owner] = false;
    }
    else {
      assert(v_local_id == (prev_v[owner] + 1));
    }

    //v_id deg_local = 0;
    //v_id deg_remote = 0;

    for(v_id e = 0; e < deg; ++e) {
      v_id neigh = adj[offset + e];
      int neigh_owner = getVertexOwningThread(neigh);
      if(neigh_owner == owner) {
        //++deg_local;
        adj_local_[owner][adj_local_pos[owner]++] = neigh;
      }
      else {
        //++deg_remote;
        adj_remote_[owner][adj_remote_pos[owner]++] = neigh;
      }
    }

    offsets_local_[owner][v_local_id + 1] = adj_local_pos[owner];
    offsets_remote_[owner][v_local_id + 1] = adj_remote_pos[owner];

    prev_v[owner] = v_local_id;
  }

  delete [] prev_v;
  delete [] first_itr;

#ifdef __XGRAPH_DEBUGGING__
  v_id _m_sum = 0;
  for(int t = 0; t < num_threads; ++t) {
    //cout << ">>> Thread " << t << ":" << endl;
    //cout << "Local: ";
    for(v_id e = 0; e < m_local_[t]; ++e) {
      _m_sum += adj_local_[t][e];
      //cout << adj_local_[t][e] << " ";
    }
    //cout << endl;
    //cout << "Remote: ";
    for(v_id e = 0; e < m_remote_[t]; ++e) {
      _m_sum += adj_remote_[t][e];
      //cout << adj_remote_[t][e] << " ";
    }
    //cout << endl;
  }

  //cout << ">>> Global: ";
  v_id _m_sum_g = 0;
  for(v_id e = 0; e < 2*m; ++e) {
    _m_sum_g += adj[e];
    //cout << adj[e] << " ";
  }
  //cout << endl;

  //cout << _m_sum << " " << _m_sum_g << endl;

  assert(_m_sum == _m_sum_g);

  for(int t = 0; t < num_threads; ++t) {
    for(v_id v = 0; v < n_local_[t]; ++v) {
      assert(offsets_local_[t][v+1] >= offsets_local_[t][v]);
    }
    for(v_id v = 0; v < n_local_[t]; ++v) {
      assert(offsets_remote_[t][v+1] >= offsets_remote_[t][v]);
    }
  }
#endif

  delete [] adj_local_pos;
  delete [] adj_remote_pos;
}

TradArrayLocalityAwareNoDegGraphR::~TradArrayLocalityAwareNoDegGraphR() {
  for(int t = 0; t < num_threads_; ++t) {
    delete [] offsets_local_[t];
    delete [] offsets_remote_[t];
    delete [] adj_local_[t];
    delete [] adj_remote_[t];
  }

  delete [] offsets_local_;
  delete [] adj_local_;
  delete [] offsets_remote_;
  delete [] adj_remote_;
}

v_id* TradArrayLocalityAwareNoDegGraphR::convertToArrayOfEdges() {
  return NULL;
}

