#if !defined(__TRAD_ARRAY_LOCALITY_AWARE_NO_DEG_GRAPH_H__)
#define      __TRAD_ARRAY_LOCALITY_AWARE_NO_DEG_GRAPH_H__

#include "globals.h"
#include "representations/graphR.h"
#include "representations/tradArrayNoDegGraphR.h"

#include "utils/debug.h"

using namespace std;

class TradArrayLocalityAwareNoDegGraphR : public GraphR {
  public:
    TradArrayLocalityAwareNoDegGraphR(TradArrayNoDegGraphR* G, int num_threads);
    ~TradArrayLocalityAwareNoDegGraphR();

    v_id* convertToArrayOfEdges();

    inline int getVertexOwningThread(v_id v_global_id) __attribute__((always_inline));
    inline v_id getVertexGlobalID(v_id v_local_id, int thread_num) __attribute__((always_inline));
    inline v_id getVertexLocalID(v_id v_global_id) __attribute__((always_inline));
    
    v_id** adj_local_ = NULL;
    v_id** adj_remote_ = NULL;
    v_id** offsets_local_ = NULL;
    v_id** offsets_remote_ = NULL;

    v_id* n_local_ = NULL;
    v_id* m_local_ = NULL;
    v_id* m_remote_ = NULL;

    v_id n_ = 0;
    v_id m_ = 0;

    int num_threads_ = 0;
    int log_of_num_threads_ = 0;
};

v_id TradArrayLocalityAwareNoDegGraphR::getVertexGlobalID(v_id v_local_id, int thread_num) {
#ifdef NUM_OF_THREADS_PER_NODE_IS_A_POWER_OF_TWO
    return ((v_id)(v_local_id << log_of_num_threads_) + thread_num);
#else
      return ((v_id)(v_local_id * num_threads_) + thread_num);
#endif
}

v_id TradArrayLocalityAwareNoDegGraphR::getVertexLocalID(v_id v_global_id) {
#ifdef NUM_OF_THREADS_PER_NODE_IS_A_POWER_OF_TWO
    return v_global_id >> log_of_num_threads_;
#else
      return v_global_id / num_threads_;
#endif
}

int TradArrayLocalityAwareNoDegGraphR::getVertexOwningThread(v_id v_global_id) {
#ifdef NUM_OF_THREADS_PER_NODE_IS_A_POWER_OF_TWO
    return (v_global_id & (((int)1 << log_of_num_threads_) - 1));
#else
      return (v_global_id % num_threads_);
#endif
}

#endif
