#if !defined(__TRAD_ARRAY_NO_DEG_EWGRAPH_H__)
#define      __TRAD_ARRAY_NO_DEG_EWGRAPH_H__

#include "globals.h"
#include "representations/graphR.h"

using namespace std;

class TradArrayNoDegEWGraphR : public GraphR {
  public:
    TradArrayNoDegEWGraphR(v_id n, v_id m);
    TradArrayNoDegEWGraphR(v_id n, v_id m, v_id* offsets, v_id* adj);
    ~TradArrayNoDegEWGraphR();

    inline uint64_t adj_data_total_size_in_bytes();
    inline uint64_t offsets_total_size_in_bytes();

    // Get the neighbors of a given vertex. TODO: test it!
    inline  __attribute__((always_inline)) v_id* N(v_id v);

    // Get the degree of a given vertex.
    inline  __attribute__((always_inline)) v_id d(v_id v);

    // Get the edge (the vertex it goes to) of an id-th edge of a vertex v.
    inline  __attribute__((always_inline)) v_id e(v_id v, v_id id);

    // Get the weight of an id-th edge of a vertex v.
    inline  __attribute__((always_inline)) v_id w(v_id v, v_id id);

    v_id* convertToArrayOfEdges();

    v_id* offsets_;
    v_id* adj_;
};

inline  __attribute__((always_inline)) v_id* TradArrayNoDegEWGraphR::N(v_id v) {
  return &adj_[offsets_[2*v]];
}

inline  __attribute__((always_inline)) v_id TradArrayNoDegEWGraphR::d(v_id v) {
  return (offsets_[v+1] - offsets_[v]) >> 1;
}

inline  __attribute__((always_inline)) v_id TradArrayNoDegEWGraphR::e(v_id v, v_id id) {
  // !!! id must be lower than deg(v)!
  return (adj_[offsets_[v] + 2*id]);
}

inline  __attribute__((always_inline)) v_id TradArrayNoDegEWGraphR::w(v_id v, v_id id) {
  // !!! id must be lower than deg(v)!
  return (adj_[offsets_[v] + 2*id + 1]);
}

uint64_t TradArrayNoDegEWGraphR::adj_data_total_size_in_bytes() {
  uint64_t size = 0;
  size = n_*sizeof(v_id); //size of the fields that say the size of each list
  size += 4*m_*sizeof(v_id); //size of actual lists
  return size;
}

uint64_t TradArrayNoDegEWGraphR::offsets_total_size_in_bytes() {
  uint64_t size = 0;
  size = n_*sizeof(v_id*); //size of pointers
  size += sizeof(v_id**); //size of the main pointer
  return size;
}

#endif
