#include "tradArrayNoDegLogGraphR.h"

TradArrayNoDegLogGraphR::TradArrayNoDegLogGraphR(v_id n, v_id m) : GraphR(n,m) {
  assert(CHAR_BIT == 8);

  bits_per_vertex_ = ceil( log2(n) );
  max_offset_value_ = ceil( (2*m * bits_per_vertex_) / (double)CHAR_BIT);
  bits_per_offset_ = ceil( log2(max_offset_value_) );

  offsets_size_in_bits_ = bits_per_offset_ * (n+1);
  adj_size_in_bits_ = bits_per_vertex * (2 * m);

  offsets_size_in_bytes_ = ceil( offsets_size_in_bits_ / (double)CHAR_BIT);
  adj_size_in_bytes_ = ceil( adj_size_in_bits_ / (double)CHAR_BIT);

  offsets_ = new unsigned char[ offsets_size_in_bytes_ ]();
  adj_ = new v_id[ adj_size_in_bytes_ ]();
}

TradArrayNoDegLogGraphR::TradArrayNoDegLogGraphR(v_id n, v_id m, unsigned char* offsets, unsigned char* adj) : GraphR(n,m) {
  adj_ = adj; 
  offsets_ = offsets;
}

TradArrayNoDegLogGraphR::~TradArrayNoDegLogGraphR() {
  delete [] offsets_;
  delete [] adj_;
}


