#if !defined(__TRAD_ARRAY_NO_DEG_LOG_GRAPH_H__)
#define      __TRAD_ARRAY_NO_DEG_LOG_GRAPH_H__

#include "globals.h"
#include "representations/graphR.h"

using namespace std;

class TradArrayNoDegLogGraphR : public GraphR {
  public:
    TradArrayNoDegLogGraphR(v_id n, v_id m);
    TradArrayNoDegLogGraphR(v_id n, v_id m, unsigned char* offsets, unsigned char* adj);
    ~TradArrayNoDegLogGraphR();

    inline unsigned char* vertex_offset(v_id v) {
      return offsets_[ (bits_per_offset_ * v) >> 3 ];
    }

    inline uint64_t adj_data_total_size_in_bytes();
    inline uint64_t offsets_total_size_in_bytes();

    unsigned char* offsets_;
    unsigned char* adj_;

    uint64_t adj_size_in_bytes_;
    uint64_t adj_size_in_bits_;

    uint64_t offsets_size_in_bytes_;
    uint64_t offsets_size_in_bytes_;
};

uint64_t TradArrayNoDegLogGraphR::adj_data_total_size_in_bytes() {
  return offsets_size_in_bytes_;
}

uint64_t TradArrayNoDegLogGraphR::offsets_total_size_in_bytes() {
  return adj_size_in_bytes_;
}

#endif
