#include "tradListGraphR.h"

TradListGraphR::TradListGraphR() {
  adj_ = new TradAdj<v_id>();
}

TradListGraphR::TradListGraphR(v_id n, v_id m) : GraphR(n,m) {
  adj_ = new TradAdj<v_id>();
}

TradListGraphR::TradListGraphR(v_id n, v_id m, TradAdj<v_id>* adj) : GraphR(n,m) {
  adj_ = adj; 
}

TradListGraphR::~TradListGraphR() {
  delete adj_;
}

/*
uint64_t TradListGraphR::adj_data_total_size_in_bytes() {
  uint64_t size = 0;

  //TODO: this size is not exactly the size of the map structure
  //but rather the size of the ``ideal'' adj list
  //maybe change it to reflect the exact size? Or better - improve
  //the structure from map to a better optimized simple adj list

  size = n_*sizeof(v_id); //size of the fields that say the size of each list
  size += 2*m_*sizeof(v_id); //size of actual lists
  return size;
}

uint64_t TradListGraphR::offsets_total_size_in_bytes() {
  uint64_t size = 0;

  //TODO: this size is not exactly the size of the map structure
  //but rather the size of the ``ideal'' adj list
  //maybe change it to reflect the exact size? Or better - improve
  //the structure from map to a better optimized simple adj list

  size = n_*sizeof(v_id*); //size of pointers
  size += sizeof(v_id**); //size of the main pointer
  return size;
}
*/
