#if !defined(__TUPLE_GRAPH_R_H__)
#define      __TUPLE_GRAPH_R_H__

#include "globals.h"
#include "graphR.h"

// This representation partially emulates the one from g500
// for now, there's no suppoer for storing it on a disk

class PackedEdge {
 public:
  uint32_t v0_low;
  uint32_t v1_low;
  uint32_t high; /* v1 in high half, v0 in low half */

  inline void setEdge(int64_t v0, int64_t v1) {
    v0_low = (uint32_t)v0;
    v1_low = (uint32_t)v1;
    high = ((v0 >> 32) & 0xFFFF) | (((v1 >> 32) & 0xFFFF) << 16); 
  }

  inline int64_t getV0() {
    return (v0_low | ((int64_t)((int16_t)(high & 0xFFFF)) << 32));
  }

  inline int64_t getV1() {
    return (v1_low | ((int64_t)((int16_t)(high >> 16)) << 32));
  }
};

class SimpleEdge {
 public:
  int64_t v0;
  int64_t v1;
};

class SimpleTupleGraphR : public GraphR {
 public:
  SimpleTupleGraphR(int64_t m); 
  ~SimpleTupleGraphR();

  SimpleEdge* edges; 
};

class PackedTupleGraphR : public GraphR {
 public:
  PackedTupleGraphR(int64_t m);
  ~PackedTupleGraphR();

  PackedEdge* edges; 
};

#endif
