#include "globals.h"
#include "utils/convert.h"

bool verbose = false;

int main() {
  assert(decToBin(3,2) == "11");
  assert(decToBin(3,3) == "011");
  assert(decToBin(3,5) == "00011");
  assert(decToBin(8,8) == "00001000");
  assert(decToBin(10,4) == "1010");
  assert(decToBin(10,5) == "01010");
  assert(decToBin(0,1) == "0");
  assert(decToBin(1,1) == "1");
  assert(decToBin(1,2) == "01");
  assert(decToBin(2,2) == "10");

  assert(commonPrefix("0010101010", "0011111111") == "001");
  assert(commonPrefix("0", "0") == "0");
  assert(commonPrefix("1", "0") == "");
  assert(commonPrefix("1", "1") == "1");
  assert(commonPrefix("", "") == "");
  assert(commonPrefix("1001", "1101") == "1");

  assert(charbitToInt('0') == 0);
  assert(charbitToInt('1') == 1);

  assert(binToDec("1") == 1);
  assert(binToDec("0") == 0);
  assert(binToDec("10") == 2);
  assert(binToDec("01") == 1);
  assert(binToDec("001") == 1);
  assert(binToDec("00001") == 1);
  assert(binToDec("10001") == 17);
  assert(binToDec("111") == 7);
  assert(binToDec("0111") == 7);
  assert(binToDec("000000111") == 7);
  assert(binToDec("1111") == 15);
  assert(binToDec("111101011") == 491);

  printf("OK\n");

  return 0;
}
