#include <iostream>
#include "tree.hh"
#include "tree_util.hh"

#include "trees/treeGeneration.h"
#include "trees/treeIO.h"

using namespace std;

int main(int argc, char** argv)  {
  assert(argc == 4);

  v_id levels = atoi(argv[1]);
  v_id min_children = atoi(argv[2]);
  v_id max_children = atoi(argv[3]);

  v_id actual_min_children = min_children;
  v_id actual_max_children = max_children;

  string f_name = "random_BP_tree.levels_" + string(argv[1]) + ".min_children_" + string(argv[2]) + ".max_children_" + string(argv[3]);
  tree<v_id>* my_tree = generateRandomTree(levels, min_children, max_children, &actual_min_children, &actual_max_children);

  printTreeToCout(my_tree, actual_min_children, actual_max_children);
  printTreeToFile(my_tree, actual_min_children, actual_max_children, f_name);

  delete my_tree;
}
