#include "globals.h"
#include "utils/graphIO.h"
#include "representations/tradArrayNoDegEWGraphR.h"
#include "representations/metisR.h"

bool verbose = false;
const int v_nr = 9;
const int e_nr = 14;

const int v_nr_2 = 10;
const int e_nr_2 = 21;

int main() {
  const char* file_name = "input/g1_EW.txt";
  TradArrayNoDegEWGraphR*  loaded_g_a_nd = NULL;
  GraphIO::loadGraph(file_name, &loaded_g_a_nd);

  v_id* a_offsets_nd = loaded_g_a_nd->offsets_;
  v_id* a_adj_nd = loaded_g_a_nd->adj_;

  assert(loaded_g_a_nd->n_ == 9);
  assert(loaded_g_a_nd->m_ == 14);

//1 1 2 3 4 8 5 2
//2 1 3 8 5 4
//3 2 4 4 6 2 8 12
//5 2 7 1 8 5 9 3
//6 1 8 2 9 1
//5 12 6 5 7 2 9 4
//6 3 7 1 8 4

  v_id corr_adj_nd[74] = {2, 1,   2, 3, 3, 1,   0, 1, 1, 3, 3, 8, 4, 2,   1, 1, 2, 8, 4, 4,   2, 2, 3, 4, 5, 2, 7, 12,   4, 2, 6, 1, 7, 5, 8, 3,   5, 1, 7, 2, 8, 1,   4, 12, 5, 5, 6, 2, 8, 4,   5, 3, 6, 1, 7, 4};
  v_id corr_offsets_nd[10] = {0, 2, 6, 14, 20, 28, 36, 42, 50, 56};
  v_id v_degs[9] = {1, 2, 4, 3, 4, 4, 3, 4, 3};
  v_id e_ids[9][4] = { {2, -1, -1, -1}, {2, 3, -1, -1}, {0, 1, 3, 4}, {1, 2, 4, -1}, {2, 3, 5, 7}, {4, 6, 7, 8}, {5, 7, 8, -1}, {4, 5, 6, 8}, {5, 6, 7, -1} };
  v_id e_weights[9][4] = { {1, -1, -1, -1}, {3, 1, -1, -1}, {1, 3, 8, 2}, {1, 8, 4, -1}, {2, 4, 2, 12}, {2, 1, 5, 3}, {1, 2, 1, -1}, {12, 5, 2, 4}, {3, 1, 4, -1} }; 

  for(int i = 0; i < 10; ++i) {
    cout << a_offsets_nd[i] << " " << corr_offsets_nd[i] << endl;
    assert(a_offsets_nd[i] == corr_offsets_nd[i]);
  }

  for(int i = 0; i < 28; ++i) {
    cout << a_adj_nd[i] << " " << corr_adj_nd[i] << endl;
    assert(a_adj_nd[i] == corr_adj_nd[i]);
  }

  for(int v = 0; v < 9; ++v) {
    assert(loaded_g_a_nd->d(v) == v_degs[v]);

    for(int e_id = 0; e_id < loaded_g_a_nd->d(v); ++e_id) {
      cout << loaded_g_a_nd->e(v,e_id) << " " << e_ids[v][e_id] << endl;
      assert(loaded_g_a_nd->e(v,e_id) == e_ids[v][e_id]);
      assert(loaded_g_a_nd->w(v,e_id) == e_weights[v][e_id]);
    }
  }

  delete loaded_g_a_nd;








  file_name = "input/g1.txt";
  loaded_g_a_nd = NULL;
  GraphIO::loadGraph(file_name, &loaded_g_a_nd);

  a_offsets_nd = loaded_g_a_nd->offsets_;
  a_adj_nd = loaded_g_a_nd->adj_;

  assert(loaded_g_a_nd->n_ == 9);
  assert(loaded_g_a_nd->m_ == 14);

  v_id corr_adj_nd_UW[74] = {2, 1,   2, 1, 3, 1,   0, 1, 1, 1, 3, 1, 4, 1,   1, 1, 2, 1, 4, 1,   2, 1, 3, 1, 5, 1, 7, 1,   4, 1, 6, 1, 7, 1, 8, 1,   5, 1, 7, 1, 8, 1,   4, 1, 5, 1, 6, 1, 8, 1,   5, 1, 6, 1, 7, 1};
  v_id corr_offsets_nd_UW[10] = {0, 2, 6, 14, 20, 28, 36, 42, 50, 56};
  v_id v_degs_UW[9] = {1, 2, 4, 3, 4, 4, 3, 4, 3};
  v_id e_ids_UW[9][4] = { {2, -1, -1, -1}, {2, 3, -1, -1}, {0, 1, 3, 4}, {1, 2, 4, -1}, {2, 3, 5, 7}, {4, 6, 7, 8}, {5, 7, 8, -1}, {4, 5, 6, 8}, {5, 6, 7, -1} };
  v_id e_weights_UW[9][4] = { {1, -1, -1, -1}, {1, 1, -1, -1}, {1, 1, 1, 1}, {1, 1, 1, -1}, {1, 1, 1, 1}, {1, 1, 1, 1}, {1, 1, 1, -1}, {1, 1, 1, 1}, {1, 1, 1, -1} }; 

  for(int i = 0; i < 10; ++i) {
//    cout << a_offsets_nd[i] << " " << corr_offsets_nd[i] << endl;
    assert(a_offsets_nd[i] == corr_offsets_nd_UW[i]);
  }

  for(int i = 0; i < 28; ++i) {
//    cout << a_adj_nd[i] << " " << corr_adj_nd[i] << endl;
    assert(a_adj_nd[i] == corr_adj_nd_UW[i]);
  }

  for(int v = 0; v < 9; ++v) {
    assert(loaded_g_a_nd->d(v) == v_degs_UW[v]);

    for(int e_id = 0; e_id < loaded_g_a_nd->d(v); ++e_id) {
      cout << loaded_g_a_nd->e(v,e_id) << " " << e_ids_UW[v][e_id] << endl;
      assert(loaded_g_a_nd->e(v,e_id) == e_ids_UW[v][e_id]);
      assert(loaded_g_a_nd->w(v,e_id) == e_weights_UW[v][e_id]);
    }
  }

  delete loaded_g_a_nd;

  printf("OK\n");

  return 0;
}
