#include "globals.h"
#include "utils/graphIO.h"
#include "representations/tradListGraphR.h"
#include "representations/tradArrayGraphR.h"
#include "representations/tradArrayNoDegGraphR.h"
#include "representations/metisR.h"

bool verbose = false;
const int v_nr = 9;
const int e_nr = 14;

const int v_nr_2 = 10;
const int e_nr_2 = 21;

int main() {
  const char* file_name = "input/g1.txt";
  TradArrayGraphR*  loaded_g_a = NULL;
  TradArrayNoDegGraphR*  loaded_g_a_nd = NULL;
  TradListGraphR*  loaded_g_t = NULL;
  MetisR* loaded_g_m = NULL;

  GraphIO::loadGraph(file_name, &loaded_g_t, &loaded_g_m);
  GraphIO::loadGraph(file_name, &loaded_g_a);
  GraphIO::loadGraph(file_name, &loaded_g_a_nd);

  TradAdj<v_id>* adj = loaded_g_t->adj_;
  idx_t* xadj = loaded_g_m->xadj_;
  idx_t* adjncy = loaded_g_m->adjncy_;
  v_id* a_offsets = loaded_g_a->offsets_;
  v_id* a_adj = loaded_g_a->adj_;
  v_id* a_offsets_nd = loaded_g_a_nd->offsets_;
  v_id* a_adj_nd = loaded_g_a_nd->adj_;

  assert(loaded_g_t->n_ == v_nr);
  assert(loaded_g_m->n_ == v_nr);
  assert(loaded_g_a->n_ == v_nr);
  assert(loaded_g_a_nd->n_ == v_nr);

  assert(loaded_g_t->m_ == e_nr);
  assert(loaded_g_m->m_ == e_nr);
  assert(loaded_g_a->m_ == e_nr);
  assert(loaded_g_a_nd->m_ == e_nr);

  idx_t xadj_t[v_nr+1] = {0, 1, 3, 7, 10, 14, 18, 21, 25, 28};
  idx_t adjncy_t[2*e_nr] = {2, 2, 3, 0, 1, 3, 4, 1, 2, 4, 2, 3, 5, 7, 4, 6, 7, 8, 5, 7, 8, 4, 5, 6, 8, 5, 6, 7};

  TradAdj<v_id> adj_t;
  adj_t[0] = vector<v_id>(1); adj_t[0] = {2};
  adj_t[1] = vector<v_id>(2); adj_t[1] = {2,3};
  adj_t[2] = vector<v_id>(4); adj_t[2] = {0,1,3,4};
  adj_t[3] = vector<v_id>(3); adj_t[3] = {1,2,4};
  adj_t[4] = vector<v_id>(4); adj_t[4] = {2,3,5,7};
  adj_t[5] = vector<v_id>(4); adj_t[5] = {4,6,7,8};
  adj_t[6] = vector<v_id>(3); adj_t[6] = {5,7,8};
  adj_t[7] = vector<v_id>(4); adj_t[7] = {4,5,6,8};
  adj_t[8] = vector<v_id>(3); adj_t[8] = {5,6,7};

  v_id corr_adj[37] = {1, 2,   2, 2, 3,   4, 0, 1, 3, 4,   3, 1, 2, 4,   4, 2, 3, 5, 7,   4, 4, 6, 7, 8,   3, 5, 7, 8,   4, 4, 5, 6, 8,   3, 5, 6, 7};
  v_id corr_offsets[10] = {0, 2, 5, 10, 14, 19, 24, 28, 33, 37};

  for(int i = 0; i < 10; ++i) {
    assert(a_offsets[i] == corr_offsets[i]);
  }

  for(int i = 0; i < 37; ++i) {
    assert(a_adj[i] == corr_adj[i]);
  }

  v_id corr_adj_nd[37] = {2,   2, 3,   0, 1, 3, 4,   1, 2, 4,   2, 3, 5, 7,   4, 6, 7, 8,   5, 7, 8,   4, 5, 6, 8,   5, 6, 7};
  v_id corr_offsets_nd[10] = {0, 1, 3, 7, 10, 14, 18, 21, 25, 28};

  for(int i = 0; i < 10; ++i) {
    assert(a_offsets_nd[i] == corr_offsets_nd[i]);
  }

  for(int i = 0; i < 28; ++i) {
    assert(a_adj_nd[i] == corr_adj_nd[i]);
  }



  for(int i = 0; i < v_nr; ++i) {
    assert(adj_t[i].size() == (*adj)[i].size());
    assert(xadj[i+1]-xadj[i] >= 0);
    assert(adj_t[i].size() == (unsigned int)(xadj[i+1]-xadj[i]));

    for(unsigned int j = 0; j < adj_t[i].size(); ++j) {
      assert(adj_t[i][j] == (*adj)[i][j]);
    }
  }

  for(int i = 0; i < v_nr+1; ++i) {
    assert(xadj_t[i] == xadj[i]);
  }

  for(int i = 0; i < 2*e_nr; ++i) {
    assert(adjncy_t[i] == adjncy[i]);
  }

  delete loaded_g_t;
  delete loaded_g_m;
  delete loaded_g_a;

  file_name = "input/g2.txt";
  loaded_g_t = NULL;
  loaded_g_m = NULL;

  GraphIO::loadGraph(file_name, &loaded_g_t, &loaded_g_m);

  adj = loaded_g_t->adj_;
  xadj = loaded_g_m->xadj_;
  adjncy = loaded_g_m->adjncy_;

  assert(loaded_g_t->n_ == v_nr_2);
  assert(loaded_g_m->n_ == v_nr_2);

  assert(loaded_g_t->m_ == e_nr_2);
  assert(loaded_g_m->m_ == e_nr_2);

  idx_t xadj_t_2[v_nr_2+1] = {0, 4, 8, 13, 16, 20, 25, 29, 33, 37, 42};
  idx_t adjncy_t_2[2*e_nr_2] = {1, 2, 3, 4, 0, 2, 4, 9, 0, 1, 3, 4, 5, 0, 2, 4, 0, 1, 2, 3, 2, 6, 7, 8, 9, 5, 7, 8, 9, 5, 6, 8, 9, 5, 6, 7, 9, 1, 5, 6, 7, 8};

  TradAdj<v_id> adj_t_2;
  adj_t_2[0] = vector<v_id>(4); adj_t_2[0] = {1,2,3,4};
  adj_t_2[1] = vector<v_id>(4); adj_t_2[1] = {0,2,4,9};
  adj_t_2[2] = vector<v_id>(5); adj_t_2[2] = {0,1,3,4,5};
  adj_t_2[3] = vector<v_id>(3); adj_t_2[3] = {0,2,4};
  adj_t_2[4] = vector<v_id>(4); adj_t_2[4] = {0,1,2,3};
  adj_t_2[5] = vector<v_id>(5); adj_t_2[5] = {2,6,7,8,9};
  adj_t_2[6] = vector<v_id>(4); adj_t_2[6] = {5,7,8,9};
  adj_t_2[7] = vector<v_id>(4); adj_t_2[7] = {5,6,8,9};
  adj_t_2[8] = vector<v_id>(4); adj_t_2[8] = {5,6,7,9};
  adj_t_2[9] = vector<v_id>(5); adj_t_2[9] = {1,5,6,7,8};

  for(int i = 0; i < v_nr_2; ++i) {
    assert(adj_t_2[i].size() == (*adj)[i].size());
    assert(xadj[i+1]-xadj[i] >= 0);
    assert(adj_t_2[i].size() == (unsigned int)(xadj[i+1]-xadj[i]));

    for(unsigned int j = 0; j < adj_t_2[i].size(); ++j) {
      assert(adj_t_2[i][j] == (*adj)[i][j]);
    }
  }

  for(int i = 0; i < v_nr+1; ++i) {
    assert(xadj_t_2[i] == xadj[i]);
  }

  for(int i = 0; i < 2*e_nr; ++i) {
    assert(adjncy_t_2[i] == adjncy[i]);
  }

  delete loaded_g_t;
  delete loaded_g_m;

  printf("OK\n");

  return 0;
}
