#include "globals.h"
#include "utils/graphIO.h"
#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "tests/testsMisc.h"

bool verbose = true;
const int graphs_nr = 13;
string path="../../graphs/snap/";

int main() {
  GraphTest** graphs = new GraphTest*[graphs_nr];

  graphs[0] = new GraphTest("amazon0302.txt_metis", 262111, 899792 );
  graphs[1] = new GraphTest("amazon0312.txt_metis", 400727, 2349869 );
  graphs[2] = new GraphTest("amazon0505.txt_metis", 410236, 2439437 );
  graphs[3] = new GraphTest("amazon0601.txt_metis", 403394, 2443408 );
  graphs[4] = new GraphTest("com-amazon.ungraph.txt_metis", 334863, 925872 );
  graphs[5] = new GraphTest("com-dblp.ungraph.txt_metis", 317080, 1049866 );
  graphs[6] = new GraphTest("com-youtube.ungraph.txt_metis", 1134890, 2987624 );
  graphs[7] = new GraphTest("email-EuAll.txt_metis", 265214, 364481 );
  graphs[8] = new GraphTest("flickrEdges.txt_metis", 105938, 2316948 );
  graphs[9] = new GraphTest("loc-gowalla_edges.txt_metis", 196591, 950327 );
  graphs[10] = new GraphTest("soc-Slashdot0811.txt_metis", 77360, 469180 );
  graphs[11] = new GraphTest("soc-Slashdot0902.txt_metis", 82168, 504230 );
  graphs[12] = new GraphTest("web-NotreDame.txt_metis", 325729, 1090108 );

  for(int i = 0; i < graphs_nr; i++) {
    TradListGraphR*  loaded_g_t = NULL;
    MetisR* loaded_g_m = NULL;

    string name = path + graphs[i]->file_name;
    GraphIO::loadGraph(name.c_str(), &loaded_g_t, &loaded_g_m);

    assert(loaded_g_t->n_ == graphs[i]->n_);
    assert(loaded_g_m->n_ == graphs[i]->n_);

    assert(loaded_g_t->m_ == graphs[i]->m_);
    assert(loaded_g_m->m_ == graphs[i]->m_);

    delete loaded_g_t;
    delete loaded_g_m;
  }

  for(int i = 0; i < graphs_nr; i++) {
    delete graphs[i];
  }
  delete [] graphs;

  printf("OK\n");

  return 0;
}
