#include "globals.h"
#include "utils/myVarint.h"

bool verbose = false;

int main() {
  uint64_t test_val = 512;
  uint64_t bits = 1000;
  unsigned char varint[10];

  int next = toVarint(test_val, &varint[0], &bits);

  assert(next == 2);
  assert(bits == 4);

  uint64_t out1;
  next = fromVarint(&varint[0], &out1);

  assert(out1 == 512);
  assert(next == 2);

  ////////////////////////////////////////////////////////

  test_val = 12345678;
  bits = 1000;

  next = toVarint(test_val, &varint[0], &bits);

  assert(next == 4);
  assert(bits == 4);

  uint64_t out2;
  next = fromVarint(&varint[0], &out2);

  assert(out2 == 12345678);
  assert(next == 4);

  ////////////////////////////////////////////////////////

  test_val = 67;
  bits = 1000;

  next = toVarint(test_val, &varint[0], &bits);

  assert(next == 1);
  assert(bits == 0);

  uint64_t out3;
  next = fromVarint(&varint[0], &out3);

  assert(out3 == 67);
  assert(next == 1);

  ////////////////////////////////////////////////////////

  test_val = 1;
  bits = 1000;

  next = toVarint(test_val, &varint[0], &bits);

  assert(next == 1);
  assert(bits == 6);

  uint64_t out4;
  next = fromVarint(&varint[0], &out4);

  assert(out4 == 1);
  assert(next == 1);

  ////////////////////////////////////////////////////////

  test_val = 2;
  bits = 1000;

  next = toVarint(test_val, &varint[0], &bits);

  assert(next == 1);
  assert(bits == 5);

  uint64_t out5;
  next = fromVarint(&varint[0], &out5);

  assert(out5 == 2);
  assert(next == 1);

  printf("OK\n");


  return 0;
}
